/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.search;

import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.tag.TagService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NewsESSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(NewsESSearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private final ConfigurationManager configurationManager;
    private final IdentityManager identityManager;
    private final ActivityStorage activityStorage;
    private final ElasticSearchingClient client;
    private final String index;
    private final String searchType;
    private String searchQueryFilePath;
    private String searchQuery;
    public static final String SEARCH_QUERY_TERM = "\"should\": {  \"match_phrase\": {    \"body\": {      \"query\": \"@term@\",      \"boost\": 5    }  }},\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"summary\", \"title\"],    \"query\": \"@term_query@\"  }},";

    public NewsESSearchConnector(ConfigurationManager configurationManager, IdentityManager identityManager, ActivityStorage activityStorage, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        this.activityStorage = activityStorage;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchType = param.getProperty("searchType");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<NewsESSearchResult> search(Identity viewerIdentity, NewsFilter filter) {
        if (viewerIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (filter.getOffset() < 0) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (filter.getLimit() < 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((String)filter.getSearchText()) && !filter.isFavorites() && CollectionUtils.isEmpty(filter.getTagNames())) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        Set streamFeedOwnerIds = this.activityStorage.getStreamFeedOwnerIds(viewerIdentity);
        String esQuery = this.buildQueryStatement(viewerIdentity, streamFeedOwnerIds, filter);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    private String buildQueryStatement(Identity viewerIdentity, Set<Long> streamFeedOwnerIds, NewsFilter filter) {
        Map<String, List<String>> metadataFilters = this.buildMetadatasFilter(filter, viewerIdentity);
        String metadataQuery = this.buildMetadatasQueryStatement(metadataFilters);
        String termQuery = this.buildTermQueryStatement(filter.getSearchText());
        return this.retrieveSearchQuery().replace("@term_query@", termQuery).replace("@metadatas_query@", metadataQuery).replace("@permissions@", StringUtils.join(streamFeedOwnerIds, (String)",")).replace("@offset@", String.valueOf(filter.getOffset())).replace("@limit@", String.valueOf(filter.getLimit()));
    }

    private List<NewsESSearchResult> buildResult(String jsonResponse) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<NewsESSearchResult> results = new ArrayList<NewsESSearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                JSONArray bodyExcepts;
                NewsESSearchResult newsSearchResult = new NewsESSearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                String id = (String)hitSource.get((Object)"id");
                String posterId = (String)hitSource.get((Object)"posterId");
                String spaceDisplayName = (String)hitSource.get((Object)"spaceDisplayName");
                String newsActivityId = (String)hitSource.get((Object)"newsActivityId");
                Long postedTime = this.parseLong(hitSource, "postedTime");
                Long lastUpdatedTime = this.parseLong(hitSource, "lastUpdatedTime");
                String title = (String)hitSource.get((Object)"title");
                String body = (String)hitSource.get((Object)"body");
                JSONObject highlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                ArrayList<String> excerpts = new ArrayList();
                if (highlightSource != null && (bodyExcepts = (JSONArray)highlightSource.get((Object)"body")) != null) {
                    excerpts = Arrays.asList((String[])bodyExcepts.toArray((Object[])new String[0]));
                }
                newsSearchResult.setId(id);
                newsSearchResult.setTitle(title);
                if (posterId != null) {
                    Identity posterIdentity = this.identityManager.getOrCreateIdentity("organization", posterId);
                    newsSearchResult.setPoster(posterIdentity);
                }
                newsSearchResult.setPostedTime(postedTime);
                newsSearchResult.setLastUpdatedTime(lastUpdatedTime);
                newsSearchResult.setSpaceDisplayName(spaceDisplayName);
                newsSearchResult.setActivityId(newsActivityId);
                String portalName = PortalContainer.getCurrentPortalContainerName();
                String portalOwner = CommonsUtils.getCurrentPortalOwner();
                StringBuilder newsUrl = new StringBuilder("");
                newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/activity?id=").append(newsActivityId);
                newsSearchResult.setNewsUrl(newsUrl.toString());
                newsSearchResult.setBody(body);
                newsSearchResult.setExcerpts(excerpts);
                results.add(newsSearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing news search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private String buildTermQueryStatement(String term) {
        if (StringUtils.isBlank((String)term)) {
            return term;
        }
        term = this.removeSpecialCharacters(term);
        List termsQuery = Arrays.stream(term.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
            if (((String)(word = ((String)word).trim())).length() > 5) {
                word = (String)word + "~1";
            }
            return word;
        }).collect(Collectors.toList());
        String termQuery = StringUtils.join(termsQuery, (String)" AND ");
        return SEARCH_QUERY_TERM.replace("@term@", term).replace("@term_query@", termQuery);
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((String)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replaceAll("'", " ");
        return string;
    }

    private String buildMetadatasQueryStatement(Map<String, List<String>> metadataFilters) {
        StringBuilder metadataQuerySB = new StringBuilder();
        Set<Map.Entry<String, List<String>>> metadataFilterEntries = metadataFilters.entrySet();
        for (Map.Entry<String, List<String>> metadataFilterEntry : metadataFilterEntries) {
            metadataQuerySB.append("{\"terms\":{\"metadatas.").append(metadataFilterEntry.getKey()).append(".metadataName.keyword").append("\": [\"").append(StringUtils.join((Collection)metadataFilterEntry.getValue(), (String)"\",\"")).append("\"]}},");
        }
        return metadataQuerySB.toString();
    }

    private Map<String, List<String>> buildMetadatasFilter(NewsFilter filter, Identity viewerIdentity) {
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (filter.isFavorites()) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(viewerIdentity.getId()));
        }
        if (CollectionUtils.isNotEmpty(filter.getTagNames())) {
            metadataFilters.put(TagService.METADATA_TYPE.getName(), filter.getTagNames());
        }
        return metadataFilters;
    }
}

