/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.model.NewsTargetObject;
import org.exoplatform.news.rest.NewsTargetingEntity;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public class NewsTargetingServiceImpl
implements NewsTargetingService {
    private static final Log LOG = ExoLogger.getLogger(NewsTargetingServiceImpl.class);
    public static final long LIMIT = 100L;
    private static final String REFERENCED = "referenced";
    private MetadataService metadataService;
    private IdentityManager identityManager;

    public NewsTargetingServiceImpl(MetadataService metadataService, IdentityManager identityManager) {
        this.metadataService = metadataService;
        this.identityManager = identityManager;
    }

    @Override
    public List<NewsTargetingEntity> getTargets() {
        List targets = this.metadataService.getMetadatas(METADATA_TYPE.getName(), 100L);
        return targets.stream().map(this::toEntity).collect(Collectors.toList());
    }

    @Override
    public void deleteTargetByName(String targetName, Identity currentIdentity) throws IllegalAccessException {
        if (currentIdentity != null && !NewsUtils.canManageNewsPublishTargets(currentIdentity)) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " not authorized to delete news target with name " + targetName);
        }
        MetadataKey targetMetadataKey = new MetadataKey(METADATA_TYPE.getName(), targetName, 0L);
        Metadata targetMetadata = this.metadataService.getMetadataByKey(targetMetadataKey);
        this.metadataService.deleteMetadataById(targetMetadata.getId());
    }

    @Override
    public List<NewsTargetingEntity> getReferencedTargets(Identity currentIdentity) throws IllegalAccessException {
        if (!NewsUtils.canPublishNews(currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to get referenced news targets");
        }
        List referencedTargets = this.metadataService.getMetadatasByProperty(REFERENCED, String.valueOf(true), 100L);
        return referencedTargets.stream().map(this::toEntity).collect(Collectors.toList());
    }

    @Override
    public List<String> getTargetsByNewsId(String newsId) {
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", newsId, null);
        List newsTargets = this.metadataService.getMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), (MetadataObject)newsTargetObject);
        return newsTargets.stream().map(MetadataItem::getMetadata).map(Metadata::getName).collect(Collectors.toList());
    }

    @Override
    public void saveNewsTarget(String newsId, boolean staged, List<String> targets, String currentUserId) throws IllegalAccessException {
        Identity currentIdentity = NewsUtils.getUserIdentity(currentUserId);
        if (!NewsUtils.canPublishNews(currentIdentity)) {
            throw new IllegalAccessException("User " + currentUserId + " not authorized to save news targets");
        }
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", newsId, null);
        org.exoplatform.social.core.identity.model.Identity currentSocIdentity = this.identityManager.getOrCreateIdentity("organization", currentUserId);
        targets.stream().forEach(targetName -> {
            try {
                MetadataKey metadataKey = new MetadataKey(NewsTargetingService.METADATA_TYPE.getName(), targetName, 0L);
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                properties.put("staged", String.valueOf(staged));
                this.metadataService.createMetadataItem((MetadataObject)newsTargetObject, metadataKey, properties, Long.parseLong(currentSocIdentity.getId()));
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.warn("Targets with name {} is already associated to object {}. Ignore error since it will not affect result.", new Object[]{targetName, newsTargetObject, e});
            }
        });
    }

    @Override
    public List<MetadataItem> getNewsTargetItemsByTargetName(String targetName, long offset, long limit) {
        return this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(targetName, METADATA_TYPE.getName(), "news", "staged", String.valueOf(false), offset, limit);
    }

    @Override
    public void deleteNewsTargets(String newsId) {
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", newsId, null);
        this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), (MetadataObject)newsTargetObject);
    }

    @Override
    public void deleteNewsTargets(String newsId, String currentUserId) throws IllegalAccessException {
        Identity currentIdentity = NewsUtils.getUserIdentity(currentUserId);
        if (!NewsUtils.canPublishNews(currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to delete news targets");
        }
        this.deleteNewsTargets(newsId);
    }

    @Override
    public Metadata createNewsTarget(NewsTargetingEntity newsTargetingEntity, Identity currentIdentity) throws IllegalArgumentException, IllegalAccessException {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
        long userIdentityId = identity == null ? 0L : Long.parseLong(identity.getId());
        Metadata metadata = this.fromEntity(newsTargetingEntity);
        metadata.setCreatorId(userIdentityId);
        if (!NewsUtils.canManageNewsPublishTargets(currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to create news targets");
        }
        MetadataKey targetMetadataKey = new MetadataKey(METADATA_TYPE.getName(), metadata.getName(), 0L);
        Metadata storedMetadata = this.metadataService.getMetadataByKey(targetMetadataKey);
        if (storedMetadata != null) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " not authorized to create news target with same name " + metadata.getName());
        }
        return this.metadataService.createMetadata(metadata, userIdentityId);
    }

    @Override
    public Metadata updateNewsTargets(String originalTargetName, NewsTargetingEntity newsTargetingEntity, Identity currentIdentity) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        boolean isSameDescription;
        if (!NewsUtils.canManageNewsPublishTargets(currentIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " not authorized to get news targets");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
        long userIdentityId = identity == null ? 0L : Long.parseLong(identity.getId());
        MetadataKey targetMetadataKey = new MetadataKey(METADATA_TYPE.getName(), originalTargetName, 0L);
        Metadata storedMetadata = this.metadataService.getMetadataByKey(targetMetadataKey);
        if (storedMetadata == null) {
            throw new IllegalStateException("User " + currentIdentity.getUserId() + " can not get news target with this name " + originalTargetName);
        }
        boolean isSameName = StringUtils.equals((CharSequence)newsTargetingEntity.getName(), (CharSequence)originalTargetName);
        if (!isSameName) {
            storedMetadata.setName(newsTargetingEntity.getName());
        }
        if (!(isSameDescription = newsTargetingEntity.getProperties().entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(storedMetadata.getProperties().get(e.getKey()))))) {
            storedMetadata.setProperties(newsTargetingEntity.getProperties());
        }
        if (isSameName && isSameDescription) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " don't make any changes");
        }
        return this.metadataService.updateMetadata(storedMetadata, userIdentityId);
    }

    private NewsTargetingEntity toEntity(Metadata metadata) {
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName(metadata.getName());
        if (metadata.getProperties() != null) {
            newsTargetingEntity.setProperties(metadata.getProperties());
        }
        return newsTargetingEntity;
    }

    private Metadata fromEntity(NewsTargetingEntity newsTargetingEntity) {
        Metadata metadata = new Metadata();
        metadata.setName(newsTargetingEntity.getName());
        metadata.setAudienceId(0L);
        metadata.setType(METADATA_TYPE);
        metadata.setProperties(newsTargetingEntity.getProperties());
        metadata.setCreatorId(0L);
        return metadata;
    }
}

