/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.storage;

import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;

public interface NewsStorage {
    public News createNews(News var1) throws Exception;

    public void publishNews(News var1) throws Exception;

    public String getNewsIllustration(News var1) throws Exception;

    public News updateNews(News var1, String var2) throws Exception;

    public void updateNewsActivities(String var1, News var2) throws Exception;

    public News getNewsById(String var1, boolean var2) throws Exception;

    public List<News> getNews(NewsFilter var1) throws Exception;

    public int getNewsCount(NewsFilter var1) throws Exception;

    public void markAsRead(News var1, String var2) throws Exception;

    public boolean isCurrentUserInNewsViewers(String var1, String var2) throws Exception;

    public void unpublishNews(String var1) throws Exception;

    public void shareNews(News var1, Space var2, Identity var3, String var4) throws IllegalAccessException, ObjectNotFoundException;

    public void deleteNews(String var1, boolean var2) throws Exception;

    public News scheduleNews(News var1) throws Exception;

    public News unScheduleNews(News var1) throws Exception;

    public void archiveNews(String var1) throws Exception;

    public void unarchiveNews(String var1) throws Exception;

    public List<News> searchNews(NewsFilter var1, String var2) throws Exception;
}

