/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.HashMap;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiHomeTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;

public class WikiTreeNode
extends TreeNode {
    private Wiki wiki;

    public WikiTreeNode(Wiki wiki) throws Exception {
        super(wiki.getOwner(), TreeNodeType.WIKI);
        this.wiki = wiki;
        this.path = this.buildPath();
        this.hasChild = true;
    }

    public WikiHomeTreeNode getWikiHomeTreeNode() {
        return (WikiHomeTreeNode)this.children.get(0);
    }

    @Override
    protected void addChildren(HashMap<String, Object> context) throws Exception {
        this.children.add(new WikiHomeTreeNode(this.wiki.getWikiHome()));
        super.addChildren(context);
    }

    public Wiki getWiki() {
        return this.wiki;
    }

    public void setWiki(Wiki wiki) {
        this.wiki = wiki;
    }

    @Override
    public String buildPath() {
        WikiPageParams params = new WikiPageParams(this.wiki.getType(), this.wiki.getOwner(), null);
        return TreeUtils.getPathFromPageParams(params);
    }
}

