/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs.text;

import java.text.Format;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.suigeneris.jrcs.rcs.text.KeywordAndValueFormatter;
import org.suigeneris.jrcs.rcs.text.KeywordOnlyFormatter;
import org.suigeneris.jrcs.rcs.text.ValueOnlyFormatter;

public abstract class KeywordFormatter {
    private static final String DOLLAR = "\\\\\\$";
    private final Format Header_FORMAT = new MessageFormat("$Header: {1} {2} {3, date,yyyy/MM/dd HH:mm:ss} {4} {5} $");
    private final Format Id_FORMAT = new MessageFormat("$Id: {1} {2} {3, date,yyyy/MM/dd HH:mm:ss} {4} {5} $");
    private final Format RCSFile_FORMAT = new MessageFormat("$RCSfile: {1} $");
    private final Format Revision_FORMAT = new MessageFormat("$Revision: {2} $");
    private final Format Date_FORMAT = new MessageFormat("$Date: {3, date,yyyy/MM/dd HH:mm:ss} $");
    private final Format Author_FORMAT = new MessageFormat("$Author: {4} $");
    private final Format State_FORMAT = new MessageFormat("$State: {5} $");
    private final Format Locker_FORMAT = new MessageFormat("$Locker: {6} $");
    private final Format Source_FORMAT = new MessageFormat("$Source: {0} $");
    protected final Pattern ID_RE = Pattern.compile("\\$Id(:[^\\$]*)?\\$");
    protected final Pattern HEADER_RE = Pattern.compile("\\$Header(:[^\\$]*)?\\$");
    protected final Pattern SOURCE_RE = Pattern.compile("\\$Source(:[^\\$]*)?\\$");
    protected final Pattern RCSFILE_RE = Pattern.compile("\\$RCSfile(:[^\\$]*)?\\$");
    protected final Pattern REVISION_RE = Pattern.compile("\\$Revision(:[^\\$]*)?\\$");
    protected final Pattern DATE_RE = Pattern.compile("\\$Date(:[^\\$]*)?\\$");
    protected final Pattern AUTHOR_RE = Pattern.compile("\\$Author(:[^\\$]*)?\\$");
    protected final Pattern STATE_RE = Pattern.compile("\\$State(:[^\\$]*)?\\$");
    protected final Pattern LOCKER_RE = Pattern.compile("\\$Locker(:[^\\$]*)?\\$");
    protected final Pattern NAME_RE = Pattern.compile("\\$Name(:[^\\$]*)?\\$");
    protected final Pattern LOG_RE = Pattern.compile("\\$Log(:[^\\$]*)?\\$");
    private static final KeywordFormatter V_FORMATTER = new ValueOnlyFormatter();
    private static final KeywordFormatter K_FORMATTER = new KeywordOnlyFormatter();
    private static final KeywordFormatter KV_FORMATTER = new KeywordAndValueFormatter();

    public String update(String text, Object[] revisionInfo) {
        String result = new String(text);
        result = this.substitute(result, this.ID_RE, this.Id_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.HEADER_RE, this.Header_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.SOURCE_RE, this.Source_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.RCSFILE_RE, this.RCSFile_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.REVISION_RE, this.Revision_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.DATE_RE, this.Date_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.AUTHOR_RE, this.Author_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.STATE_RE, this.State_FORMAT.format(revisionInfo));
        result = this.substitute(result, this.LOCKER_RE, this.Locker_FORMAT.format(revisionInfo));
        return result;
    }

    public String reset(String text) {
        String data = text;
        data = this.substitute(data, this.ID_RE, "$Id$");
        data = this.substitute(data, this.HEADER_RE, "$Header$");
        data = this.substitute(data, this.SOURCE_RE, "$Source$");
        data = this.substitute(data, this.RCSFILE_RE, "$RCSfile$");
        data = this.substitute(data, this.REVISION_RE, "$Revision$");
        data = this.substitute(data, this.DATE_RE, "$Date$");
        data = this.substitute(data, this.AUTHOR_RE, "$Author$");
        data = this.substitute(data, this.STATE_RE, "$State$");
        data = this.substitute(data, this.LOCKER_RE, "$Locker$");
        data = this.substitute(data, this.NAME_RE, "$Name$");
        data = this.substitute(data, this.LOG_RE, "$Log$");
        return data;
    }

    protected String remove(String text) {
        String data = text;
        data = this.substitute(data, this.ID_RE, "");
        data = this.substitute(data, this.HEADER_RE, "");
        data = this.substitute(data, this.SOURCE_RE, "");
        data = this.substitute(data, this.RCSFILE_RE, "");
        data = this.substitute(data, this.REVISION_RE, "");
        data = this.substitute(data, this.DATE_RE, "");
        data = this.substitute(data, this.AUTHOR_RE, "");
        data = this.substitute(data, this.STATE_RE, "");
        data = this.substitute(data, this.LOCKER_RE, "");
        data = this.substitute(data, this.NAME_RE, "");
        data = this.substitute(data, this.LOG_RE, "");
        return data;
    }

    private final String substitute(String input, Pattern pattern, String substitution) {
        try {
            Matcher m = pattern.matcher(input);
            substitution = substitution.replaceAll("\\$", DOLLAR);
            return m.replaceAll(substitution);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Format getAuthorFormat() {
        return this.Author_FORMAT;
    }

    public Format getDateFormat() {
        return this.Date_FORMAT;
    }

    public Format getHeaderFormat() {
        return this.Header_FORMAT;
    }

    public Format getIdFormat() {
        return this.Id_FORMAT;
    }

    public Format getLockerFormat() {
        return this.Locker_FORMAT;
    }

    public Format getRCSFileFormat() {
        return this.RCSFile_FORMAT;
    }

    public Format getRevisionFormat() {
        return this.Revision_FORMAT;
    }

    public Format getSourceFormat() {
        return this.Source_FORMAT;
    }

    public Format getStateFormat() {
        return this.State_FORMAT;
    }

    public static KeywordFormatter getKeywordOnlyFormatter() {
        return K_FORMATTER;
    }

    public static KeywordFormatter getKeywordAndValueFormatter() {
        return KV_FORMATTER;
    }

    public static KeywordFormatter getValueOnlyFormatter() {
        return V_FORMATTER;
    }
}

