/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.WikiPortletPreference;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.webui.EditMode;
import org.exoplatform.wiki.webui.EditorMode;
import org.exoplatform.wiki.webui.UIWikiApplicationControlArea;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiContentDisplay;
import org.exoplatform.wiki.webui.UIWikiEmptyAjaxBlock;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiMiddleArea;
import org.exoplatform.wiki.webui.UIWikiPageArea;
import org.exoplatform.wiki.webui.UIWikiPageContentArea;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageInfoArea;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPageVersionsList;
import org.exoplatform.wiki.webui.UIWikiPermissionForm;
import org.exoplatform.wiki.webui.UIWikiPortletPreferences;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.UIWikiSidePanelArea;
import org.exoplatform.wiki.webui.UIWikiUpperArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIAttachmentContainer;
import org.exoplatform.wiki.webui.control.action.AddPageActionComponent;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/wiki/webui/UIWikiPortlet.gtmpl", events={@EventConfig(listeners={ViewPageActionListener.class}, csrfCheck=false), @EventConfig(listeners={ChangeModeActionListener.class}, csrfCheck=false), @EventConfig(listeners={RedirectActionListener.class}, csrfCheck=false)})
public class UIWikiPortlet
extends UIPortletApplication {
    private WikiMode mode = WikiMode.VIEW;
    private EditMode editmode = EditMode.ALL;
    private EditorMode editorMode_ = EditorMode.RICHTEXT;
    private String sectionIndex = "";
    private WikiMode previousMode;
    private WikiPortletPreference portletPreferences = new WikiPortletPreference();
    public static String VIEW_PAGE_ACTION = "ViewPage";
    public static String CHANGE_MODE_ACTION = "ChangeMode";
    public static String REDIRECT_ACTION = "Redirect";
    public static String WIKI_PORTLET_ACTION_PREFIX = "UIWikiPortlet_";
    private String redirectURL = "";
    private ResourceBundle resourceBundle;
    private WikiService wikiService;
    private PortletMode portletMode;

    public UIWikiPortlet() throws Exception {
        try {
            this.wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            this.addChild(UIWikiEmptyAjaxBlock.class, null, null);
            this.addChild(UIWikiPortletPreferences.class, null, null);
            this.addChild(UIWikiUpperArea.class, null, null);
            this.addChild(UIWikiMiddleArea.class, null, null);
            this.addChild(UIWikiMaskWorkspace.class, null, "UIWikiMaskWorkspace");
            UIPopupContainer uiPopupContainer = (UIPopupContainer)this.addChild(UIPopupContainer.class, null, "UIWikiPopupContainer" + PopupLevel.L1);
            ((UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class)).setId("UIWikiPopupWindow" + PopupLevel.L1);
            uiPopupContainer = (UIPopupContainer)uiPopupContainer.addChild(UIPopupContainer.class, null, "UIWikiPopupContainer" + PopupLevel.L2);
            ((UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class)).setId("UIWikiPopupWindow" + PopupLevel.L2);
            this.loadPreferences();
        }
        catch (Exception e) {
            log.error((Object)"An exception happens when init WikiPortlet", (Throwable)e);
        }
    }

    public WikiPortletPreference getPortletPreferences() {
        return this.portletPreferences;
    }

    public void setPortletPreferences(WikiPortletPreference portletPreferences) {
        this.portletPreferences = portletPreferences;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            this.resourceBundle = context.getApplicationResourceBundle();
        }
        return this.resourceBundle;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        this.redirectURL = this.url(REDIRECT_ACTION);
        this.loadPreferences();
        this.portletMode = portletReqContext.getApplicationMode();
        if (this.portletMode == PortletMode.VIEW) {
            UIWikiPermissionForm wikiPermissionForm;
            block20: {
                UIWikiPageInfoArea pageInfoArea;
                Event xEvent;
                UIWikiPermissionForm wikiPermissionForm2;
                if (this.mode.equals((Object)WikiMode.PORTLETPREFERENCES)) {
                    this.changeMode(WikiMode.VIEW);
                }
                ((UIWikiBreadCrumb)((UIWikiApplicationControlArea)((UIWikiUpperArea)this.getChild(UIWikiUpperArea.class)).getChild(UIWikiApplicationControlArea.class)).getChild(UIWikiBreadCrumb.class)).setRendered(this.portletPreferences.isShowBreadcrumb());
                String requestURL = Utils.getCurrentRequestURL();
                WikiPageParams wikiPageParams = Utils.getCurrentWikiPageParams();
                Wiki wiki = Utils.getCurrentWiki();
                if (wiki == null) {
                    wiki = this.wikiService.createWiki(wikiPageParams.getType(), wikiPageParams.getOwner());
                }
                if (!context.useAjax() && (wikiPermissionForm2 = (UIWikiPermissionForm)this.findComponentById("UIWikiPagePermissionForm")) != null) {
                    this.getPopupContainer(wikiPermissionForm2.getPopupLevel()).deActivate();
                }
                Identity currentIdentity = ConversationState.getCurrent().getIdentity();
                Page page = Utils.getCurrentWikiPage();
                if (page == null) {
                    this.changeMode(WikiMode.PAGE_NOT_FOUND);
                    super.processRender(app, context);
                    return;
                }
                if (!this.wikiService.hasPermissionOnPage(page, PermissionType.VIEWPAGE, currentIdentity)) {
                    this.changeMode(WikiMode.PAGE_NOT_FOUND);
                    super.processRender(app, context);
                    return;
                }
                if (this.mode.equals((Object)WikiMode.PAGE_NOT_FOUND)) {
                    this.changeMode(WikiMode.VIEW);
                }
                if ((WikiMode.EDITPAGE.equals((Object)this.getWikiMode()) || WikiMode.ADDPAGE.equals((Object)this.getWikiMode())) && !this.wikiService.hasPermissionOnPage(page, PermissionType.EDITPAGE, currentIdentity)) {
                    this.changeMode(WikiMode.VIEW);
                }
                if (StringUtils.isEmpty((String)page.getUrl())) {
                    page.setUrl(Utils.getURLFromParams(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName())));
                }
                if ("AddPage".equalsIgnoreCase(wikiPageParams.getParameter("action"))) {
                    AddPageActionComponent addPageComponent = (AddPageActionComponent)this.findFirstComponentOfType(AddPageActionComponent.class);
                    if (addPageComponent != null && (xEvent = addPageComponent.createEvent("AddPage", Event.Phase.PROCESS, context)) != null) {
                        xEvent.broadcast();
                    }
                } else if ("CompareRevision".equalsIgnoreCase(wikiPageParams.getParameter("action")) && (pageInfoArea = (UIWikiPageInfoArea)this.findFirstComponentOfType(UIWikiPageInfoArea.class)) != null && (xEvent = pageInfoArea.createEvent("CompareRevision", Event.Phase.PROCESS, context)) != null) {
                    xEvent.setCsrfCheck(false);
                    xEvent.broadcast();
                }
                try {
                    context.setAttribute("wikiPage", (Object)page);
                    ((UIWikiPageTitleControlArea)this.findComponentById("UIWikiPageTitleControlForm_PageControlArea")).getUIFormInputInfo().setValue((Object)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)page.getTitle()));
                }
                catch (Exception e) {
                    context.setAttribute("wikiPage", null);
                    UIWikiPageContentArea wikiPageContentArea = (UIWikiPageContentArea)this.findFirstComponentOfType(UIWikiPageContentArea.class);
                    if (wikiPageContentArea != null) {
                        UIWikiContentDisplay contentDisplay = (UIWikiContentDisplay)wikiPageContentArea.getChildById("UIViewContentDisplay");
                        contentDisplay.setHtmlOutput("Exceptions occur when rendering content!");
                    }
                    if (!log.isWarnEnabled()) break block20;
                    log.warn((Object)("An exception happens when resolving URL: " + requestURL), (Throwable)e);
                }
            }
            if (!WikiMode.VIEW.equals((Object)this.getWikiMode()) && (wikiPermissionForm = (UIWikiPermissionForm)this.findComponentById("UIWikiPagePermissionForm")) != null && UIWikiPermissionForm.Scope.PAGE.equals((Object)wikiPermissionForm.getScope())) {
                this.getPopupContainer(wikiPermissionForm.getPopupLevel()).deActivate();
            }
            super.processRender(app, context);
        } else if (this.portletMode == PortletMode.EDIT) {
            this.changeMode(WikiMode.PORTLETPREFERENCES);
            super.processRender(app, context);
        } else {
            super.processRender(app, context);
        }
    }

    public UIPopupContainer getPopupContainer(PopupLevel level) {
        UIPopupContainer popupContainer = (UIPopupContainer)this.getChildById("UIWikiPopupContainer" + PopupLevel.L1);
        if (level == PopupLevel.L2) {
            popupContainer = (UIPopupContainer)popupContainer.getChildById("UIWikiPopupContainer" + PopupLevel.L2);
        }
        return popupContainer;
    }

    public WikiMode getWikiMode() {
        return this.mode;
    }

    public EditMode getEditMode() {
        return this.editmode;
    }

    public EditorMode getEditorMode() {
        return this.editorMode_;
    }

    public String getSectionIndex() {
        return this.sectionIndex;
    }

    public void setSectionIndex(String sectionIndex) {
        this.sectionIndex = sectionIndex;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void changeMode(WikiMode newMode) {
        if (newMode.equals((Object)WikiMode.VIEW)) {
            ((UIWikiPageTitleControlArea)this.findFirstComponentOfType(UIWikiPageTitleControlArea.class)).toInfoMode();
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)((UIWikiBottomArea)this.findFirstComponentOfType(UIWikiBottomArea.class)).setRendered(true);
            ((UIAttachmentContainer)bottomArea.getChild(UIAttachmentContainer.class)).setRendered(false);
            ((UIWikiPageVersionsList)bottomArea.getChild(UIWikiPageVersionsList.class)).setRendered(false);
        }
        if (newMode.equals((Object)WikiMode.EDITPAGE) || newMode.equals((Object)WikiMode.ADDPAGE)) {
            ((UIAttachmentContainer)this.findFirstComponentOfType(UIAttachmentContainer.class)).setRendered(true);
            ((UIWikiSidePanelArea)this.findFirstComponentOfType(UIWikiSidePanelArea.class)).setRendered(EditorMode.SOURCE.equals((Object)this.editorMode_));
            ((UIWikiBottomArea)this.findFirstComponentOfType(UIWikiBottomArea.class)).setRendered(EditorMode.SOURCE.equals((Object)this.editorMode_));
            ((UIWikiPageEditForm)this.findFirstComponentOfType(UIWikiPageEditForm.class)).getUIFormTextAreaInput("Markup").setRendered(EditorMode.SOURCE.equals((Object)this.editorMode_));
            ((UIWikiRichTextArea)this.findFirstComponentOfType(UIWikiRichTextArea.class)).setRendered(EditorMode.RICHTEXT.equals((Object)this.editorMode_));
        }
        this.mode = newMode;
    }

    public void changeEditMode(EditMode newEditMode) {
        this.editmode = newEditMode;
    }

    public void changeEditorMode(EditorMode newMode) {
        this.editorMode_ = newMode;
    }

    private void loadPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            this.portletPreferences.setShowBreadcrumb(Boolean.parseBoolean(portletPref.getValue(WikiPortletPreference.SHOW_BREADCRUMB, "true")));
            this.portletPreferences.setShowNavigationTree(Boolean.parseBoolean(portletPref.getValue(WikiPortletPreference.SHOW_NAVIGATIONTREE, "true")));
        }
        catch (Exception e) {
            log.error((Object)"Fail to load wiki portlet's preference: ", (Throwable)e);
        }
    }

    public HashMap<String, Object> getUIExtContext() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        List permissions = Utils.getCurrentWikiPage().getPermissions();
        context.put("Permissions", permissions);
        context.put("mode", (Object)this.mode);
        context.put("page", params.getPageName());
        context.put("wikiOwner", params.getOwner());
        context.put("wikiType", params.getType());
        UIWikiPageArea wikiPageArea = (UIWikiPageArea)this.findFirstComponentOfType(UIWikiPageArea.class);
        UIWikiPageEditForm wikiPageEditForm = (UIWikiPageEditForm)wikiPageArea.findFirstComponentOfType(UIWikiPageEditForm.class);
        UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)wikiPageEditForm.findFirstComponentOfType(UIWikiRichTextArea.class);
        context.put("isMarkup", !wikiRichTextArea.isRendered());
        return context;
    }

    protected boolean isKeepSessionAlive() {
        return this.mode == WikiMode.EDITPAGE || this.mode == WikiMode.EDITTEMPLATE || this.mode == WikiMode.ADDPAGE || this.mode == WikiMode.ADDTEMPLATE;
    }

    public static class RedirectActionListener
    extends EventListener<UIWikiPortlet> {
        public void execute(Event<UIWikiPortlet> event) throws Exception {
            String value = event.getRequestContext().getRequestParameter("objectId");
            value = TitleResolver.getId((String)value, (boolean)false);
            WikiPageParams params = TreeUtils.getPageParamsFromPath((String)value);
            Utils.redirect(params, WikiMode.VIEW);
        }
    }

    public static class ChangeModeActionListener
    extends EventListener<UIWikiPortlet> {
        public void execute(Event<UIWikiPortlet> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((Object)event.getSource());
            String mode = event.getRequestContext().getRequestParameter("mode");
            String currentModeName = mode.equals("") ? WikiMode.VIEW.toString() : mode;
            WikiMode currentMode = Utils.getModeFromAction(currentModeName);
            if (!wikiPortlet.mode.equals((Object)currentMode)) {
                if (currentMode == null) {
                    currentMode = WikiMode.VIEW;
                }
                ((UIWikiPortlet)((Object)event.getSource())).changeMode(currentMode);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(wikiPortlet.findFirstComponentOfType(UIWikiEmptyAjaxBlock.class));
        }
    }

    public static class ViewPageActionListener
    extends EventListener<UIWikiPortlet> {
        public void execute(Event<UIWikiPortlet> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((Object)event.getSource());
            WikiMode currentMode = wikiPortlet.getWikiMode();
            if (currentMode.equals((Object)WikiMode.VIEW)) {
                event.getRequestContext().addUIComponentToUpdateByAjax(wikiPortlet.findFirstComponentOfType(UIWikiEmptyAjaxBlock.class));
            } else {
                ((UIWikiPortlet)((Object)event.getSource())).changeMode(WikiMode.VIEW);
            }
        }
    }

    public static enum PopupLevel {
        L1,
        L2;

    }
}

