/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.utils.Utils;

public class WikiPageIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "wiki-page";
    private static final Log LOGGER = ExoLogger.getExoLogger(WikiPageIndexingServiceConnector.class);
    private final PageDAO dao;
    private final MetadataService metadataService;

    public WikiPageIndexingServiceConnector(InitParams initParams, PageDAO dao, MetadataService metadataService) {
        super(initParams);
        this.dao = dao;
        this.metadataService = metadataService;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"name\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"title\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"owner\" : {\"type\" : \"keyword\"},\n").append("    \"id\" : {\"type\" : \"long\"},\n").append("    \"wikiType\" : {\"type\" : \"keyword\"},\n").append("    \"wikiOwner\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"url\" : {\"type\" : \"text\", \"index\": false},\n").append("    \"sites\" : {\"type\" : \"keyword\"},\n").append("    \"comment\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"content\" : {\"type\" : \"text\", \"store\": true, \"term_vector\": \"with_positions_offsets\"},\n").append("    \"createdDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"updatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    public Document create(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        PageEntity page = (PageEntity)this.dao.find(Long.valueOf(Long.parseLong(id)));
        if (page == null) {
            LOGGER.info("The page entity with id {} doesn't exist.", new Object[]{id});
            return null;
        }
        try {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("owner", page.getOwner());
            fields.put("name", page.getName());
            fields.put("id", String.valueOf(page.getId()));
            String content = Utils.html2text(page.getContent());
            fields.put("content", content);
            fields.put("title", page.getTitle());
            fields.put("createdDate", String.valueOf(page.getCreatedDate().getTime()));
            fields.put("updatedDate", String.valueOf(page.getUpdatedDate().getTime()));
            fields.put("comment", page.getComment());
            fields.put("wikiType", page.getWiki().getType());
            String wikiOwner = page.getWiki().getOwner();
            if (page.getWiki().getType().toUpperCase().equals(WikiType.GROUP.name())) {
                wikiOwner = this.dao.validateGroupWikiOwner(wikiOwner);
            }
            fields.put("wikiOwner", wikiOwner);
            DocumentWithMetadata document = new DocumentWithMetadata();
            document.setId(id);
            document.setUrl(page.getUrl());
            document.setLastUpdatedDate(page.getUpdatedDate());
            document.setPermissions(this.computePermissions(page));
            document.setFields(fields);
            this.addDocumentMetadata(document, Long.toString(page.getId()));
            return document;
        }
        catch (Exception e) {
            LOGGER.info("Cannot index page with id {} ", new Object[]{id, e});
            return null;
        }
    }

    public Document update(String id) {
        return this.create(id);
    }

    public String getConnectorName() {
        return TYPE;
    }

    private Set<String> computePermissions(PageEntity page) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        HashSet<String> permissions = new HashSet<String>();
        try {
            if (page.getWiki().getType().toUpperCase().equals(WikiType.GROUP.name())) {
                SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
                Space space = spaceService.getSpaceByGroupId(page.getWiki().getOwner());
                if (space != null) {
                    permissions.add(identityManager.getOrCreateIdentity("space", space.getPrettyName()).getId());
                }
            } else if (page.getWiki().getType().toUpperCase().equals(WikiType.USER.name())) {
                permissions.add(identityManager.getOrCreateIdentity("organization", page.getWiki().getOwner()).getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get Identity of the wiki Owner", new Object[]{e.getMessage()});
        }
        return permissions;
    }

    public List<String> getAllIds(int offset, int limit) {
        ArrayList<String> result;
        List<Long> ids = this.dao.findAllIds(offset, limit);
        if (ids == null) {
            result = new ArrayList<String>(0);
        } else {
            result = new ArrayList(ids.size());
            for (Long id : ids) {
                result.add(String.valueOf(id));
            }
        }
        return result;
    }

    private void addDocumentMetadata(DocumentWithMetadata document, String documentId) {
        MetadataObject metadataObject = new MetadataObject("notes", documentId);
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }
}

