/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.webui.UIWikiPageVersionsCompare;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;

public class CompareRevisionActionListener
extends EventListener<UIComponent> {
    private static final Log log = ExoLogger.getLogger(CompareRevisionActionListener.class);
    private int from = 1;
    private int to = 0;
    private List<PageVersion> versionToCompare = new ArrayList<PageVersion>();

    public List<PageVersion> getVersionToCompare() {
        return this.versionToCompare;
    }

    public void setVersionToCompare(List<PageVersion> versionToCompare) {
        this.versionToCompare = versionToCompare;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public void execute(Event<UIComponent> event) throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIComponent)event.getSource()).getAncestorOfType(UIWikiPortlet.class);
        UIWikiPageVersionsCompare versionCompareArea = (UIWikiPageVersionsCompare)wikiPortlet.findFirstComponentOfType(UIWikiPageVersionsCompare.class);
        if (this.versionToCompare.size() > 1) {
            try {
                versionCompareArea.renderVersionsDifference(this.versionToCompare, this.from, this.to);
                wikiPortlet.changeMode(WikiMode.COMPAREREVISION);
            }
            catch (Exception e) {
                log.error((Object)("Cannot compare versions - Cause : " + e.getMessage()), (Throwable)e);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiPageVersionsCompare.label.ComparaisonError", null, 0));
                wikiPortlet.changeMode(WikiMode.VIEW);
            }
        }
    }
}

