/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import java.util.ResourceBundle;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.webui.EditorMode;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.commons.UIWikiGrid;
import org.exoplatform.wiki.webui.commons.UIWikiTemplateForm;
import org.exoplatform.wiki.webui.popup.UIWikiPagePreview;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/commons/UIWikiTemplateForm.gtmpl", events={@EventConfig(listeners={AddPageWithTemplateActionListener.class}), @EventConfig(listeners={PreviewTemplateActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={UIWikiTemplateForm.SearchTemplateActionListener.class})})
public class UIWikiSelectTemplateForm
extends UIWikiTemplateForm
implements UIPopupComponent {
    public static final String ACTION_PREVIEW = "PreviewTemplate";
    public static final String ACTION_ADD = "AddPageWithTemplate";
    public static final String ACTION_SEARCH = "SearchTemplate";
    public static final String ACTION_CANCEL = "Cancel";
    public static final String SELECT_TEMPLATE_ITER = "SelectTemplateIter";
    private static final String[] USER_ACTION = new String[]{"AddPageWithTemplate", "PreviewTemplate"};

    public UIWikiSelectTemplateForm() throws Exception {
        ((UIWikiGrid)this.grid.configure("id", TEMPLATE_FIELD, USER_ACTION)).setUIGridMode("Template");
    }

    protected String getMode() {
        return "Template";
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UIWikiSelectTemplateForm> {
        public void execute(Event<UIWikiSelectTemplateForm> event) throws Exception {
            UIWikiSelectTemplateForm form = (UIWikiSelectTemplateForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)form.getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.deActivate();
        }
    }

    public static class PreviewTemplateActionListener
    extends EventListener<UIWikiSelectTemplateForm> {
        public void execute(Event<UIWikiSelectTemplateForm> event) throws Exception {
            UIWikiSelectTemplateForm form = (UIWikiSelectTemplateForm)((Object)event.getSource());
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)form.getAncestorOfType(UIWikiPortlet.class);
            UIWikiMaskWorkspace mask = (UIWikiMaskWorkspace)wikiPortlet.findFirstComponentOfType(UIWikiMaskWorkspace.class);
            UIWikiPagePreview wikiPagePreview = (UIWikiPagePreview)mask.createUIComponent(UIWikiPagePreview.class, null, null);
            String templateId = event.getRequestContext().getRequestParameter("objectId");
            Template template = form.wService.getTemplatePage(Utils.getCurrentWikiPageParams(), templateId);
            wikiPagePreview.renderWikiMarkup(template.getContent(), template.getSyntax());
            String pageTitle = template.getTitle();
            if (pageTitle != null) {
                wikiPagePreview.setPageTitle(pageTitle);
            }
            mask.setUIComponent((UIComponent)wikiPagePreview);
            mask.setShow(true);
            mask.setPopupTitle(res.getString("UIEditorTabs.action.PreviewPage"));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)mask);
        }
    }

    public static class AddPageWithTemplateActionListener
    extends EventListener<UIWikiSelectTemplateForm> {
        public void execute(Event<UIWikiSelectTemplateForm> event) throws Exception {
            UIWikiSelectTemplateForm form = (UIWikiSelectTemplateForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)form.getAncestorOfType(UIWikiPortlet.class);
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormStringInput descriptionInput = (UIFormStringInput)pageEditForm.findComponentById("Description");
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            String templateId = null;
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            if (event.getRequestContext().getRequestParameterValues("objectId") != null) {
                templateId = event.getRequestContext().getRequestParameterValues("objectId")[0].toString();
            }
            if (templateId == null) {
                popupContainer.deActivate();
            } else {
                titleInput.setReadOnly(false);
                commentInput.setRendered(false);
                Template template = form.wService.getTemplatePage(Utils.getCurrentWikiPageParams(), templateId);
                titleInput.setValue((Object)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)template.getTitle()));
                descriptionInput.setValue((Object)template.getDescription());
                pageEditForm.setTitle(template.getTitle());
                markupInput.setValue((Object)template.getContent());
                if (EditorMode.RICHTEXT.equals((Object)wikiPortlet.getEditorMode())) {
                    Utils.feedDataForWYSIWYGEditor(pageEditForm, null);
                }
                pageEditForm.setInitDraftName("");
                popupContainer.deActivate();
                wikiPortlet.changeMode(WikiMode.ADDPAGE);
            }
        }
    }
}

