/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.notification.builder;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;
import org.exoplatform.wiki.notification.Utils.NotificationsUtils;

public class WikiTemplateBuilder
extends AbstractTemplateBuilder {
    private TemplateProvider templateProvider;
    private boolean pushNotification;

    public WikiTemplateBuilder(TemplateProvider templateProvider, boolean pushNotification) {
        this.templateProvider = templateProvider;
        this.pushNotification = pushNotification;
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String pluginId = notification.getKey().getId();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        String creatorId = notification.getValueOwnerParameter(NotificationsUtils.WIKI_EDITOR.getKey());
        String wikiUrl = notification.getValueOwnerParameter(NotificationsUtils.WIKI_URL.getKey());
        String wikiPageName = notification.getValueOwnerParameter(NotificationsUtils.WIKI_PAGE_NAME.getKey());
        String wikiContentChange = notification.getValueOwnerParameter(NotificationsUtils.CONTENT_CHANGE.getKey());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"READ", (Object)(Boolean.parseBoolean(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) ? "read" : "unread"));
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
        templateContext.put((Object)"WIKI_EDITOR", (Object)creatorId);
        templateContext.put((Object)"USER", (Object)notification.getTo());
        String notificationURL = CommonsUtils.getCurrentDomain();
        templateContext.put((Object)"WIKI_URL", (Object)(notificationURL + wikiUrl));
        templateContext.put((Object)"WIKI_PAGE_NAME", (Object)wikiPageName);
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"CONTENT_CHANGE", (Object)wikiContentChange);
        MessageInfo messageInfo = new MessageInfo();
        if (this.pushNotification) {
            messageInfo.subject(wikiUrl);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext));
        }
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        ctx.setException(templateContext.getException());
        return messageInfo.body(body).end();
    }

    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
        return false;
    }
}

