/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.BeanToJsons;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TitleSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;
import org.gatein.api.EntityNotFoundException;
import org.json.JSONObject;

@Path(value="/notes")
@Tag(name="/notes", description="Managing notes")
@RolesAllowed(value={"users"})
public class NotesRestService
implements ResourceContainer {
    private static final String NOTE_NAME_EXISTS = "Note name already exists";
    private static final Log log = ExoLogger.getLogger(NotesRestService.class);
    private final NoteService noteService;
    private final WikiService noteBookService;
    private final NotesExportService notesExportService;
    private final UploadService uploadService;
    private final ResourceBundleService resourceBundleService;
    private final CacheControl cc;

    public NotesRestService(NoteService noteService, WikiService noteBookService, UploadService uploadService, ResourceBundleService resourceBundleService, NotesExportService notesExportService) {
        this.noteService = noteService;
        this.noteBookService = noteBookService;
        this.notesExportService = notesExportService;
        this.uploadService = uploadService;
        this.resourceBundleService = resourceBundleService;
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @GET
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get note by notes params", method="GET", description="This get the not if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNote(@Parameter(description="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @Parameter(description="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="source", required=true) @QueryParam(value="source") String source) {
        try {
            Page note;
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (noteBookType.toUpperCase().equals(WikiType.GROUP.name())) {
                noteBookOwner = this.formatWikiOwnerToGroupId(noteBookOwner);
            }
            Wiki noteBook = null;
            noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                noteBook = this.noteBookService.createWiki(noteBookType, noteBookOwner);
            }
            if (noteId.equals("homeNote") || noteId.equals("Home")) {
                noteId = noteBook.getWikiHome().getId();
                note = this.noteService.getNoteById(noteId, identity, source);
            } else {
                note = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId, identity, source);
            }
            if (note == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String content = note.getContent();
            if (content.contains("class=\"noteLink\" href=\"//-")) {
                while (content.contains("class=\"noteLink\" href=\"//-")) {
                    String linkedParams = content.split("class=\"noteLink\" href=\"//-")[1].split("-//\"")[0];
                    String NoteName = linkedParams.split("-////-")[2];
                    Page linkedNote = null;
                    linkedNote = this.noteService.getNoteOfNoteBookByName(note.getWikiType(), note.getWikiOwner(), NoteName);
                    if (linkedNote == null || !(content = content.replaceAll("\"noteLink\" href=\"//-" + linkedParams + "-//", "\"noteLink\" href=\"" + linkedNote.getId())).equals(note.getContent())) continue;
                    break;
                }
                if (!content.equals(note.getContent())) {
                    note.setContent(content);
                    this.noteService.updateNote(note);
                }
            }
            note.setContent(HTMLSanitizer.sanitize((String)note.getContent()));
            note.setBreadcrumb(this.noteService.getBreadCrumb(noteBookType, noteBookOwner, note.getName(), false));
            return Response.ok((Object)note).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            log.error("Can't get note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/note/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get note by id", method="GET", description="This get the note if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="noteBookType") @QueryParam(value="noteBookType") String noteBookType, @Parameter(description="noteBookOwner") @QueryParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="withChildren") @QueryParam(value="withChildren") boolean withChildren, @Parameter(description="source", required=false) @QueryParam(value="source") String source) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity, source);
            if (note == null || note.isDeleted()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotEmpty((CharSequence)noteBookType) && !note.getWikiType().equals(noteBookType)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotEmpty((CharSequence)noteBookOwner) && !note.getWikiOwner().equals(noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (BooleanUtils.isTrue((Boolean)withChildren)) {
                note.setChildren(this.noteService.getChildrenNoteOf(note, identity.getUserId(), false, withChildren));
            }
            if (note.getContent().contains("wiki-children-pages ck-widget")) {
                note = this.updateChildrenContainer(note);
            }
            note.setContent(HTMLSanitizer.sanitize((String)note.getContent()));
            note.setBreadcrumb(this.noteService.getBreadCrumb(note.getWikiType(), note.getWikiOwner(), note.getName(), false));
            return Response.ok((Object)note).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            log.error("Can't get note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/draftNote/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get draft note by id", method="GET", description="This returns the draft note if the authenticated user is the author of the draft.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getDraftNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String currentUserId = identity.getUserId();
            DraftPage draftNote = this.noteService.getDraftNoteById(noteId, currentUserId);
            if (draftNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Page parentPage = this.noteService.getNoteById(draftNote.getParentPageId(), identity);
            if (parentPage == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            draftNote.setContent(HTMLSanitizer.sanitize((String)draftNote.getContent()));
            draftNote.setBreadcrumb(this.noteService.getBreadCrumb(parentPage.getWikiType(), parentPage.getWikiOwner(), draftNote.getId(), true));
            return Response.ok((Object)draftNote).build();
        }
        catch (Exception e) {
            log.error("Can't get draft note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/latestDraftNote/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get latest draft note of page", method="GET", description="This returns the latest draft of the note if the authenticated user is the author of the draft.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getLatestDraftOfPage(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String currentUserId = identity.getUserId();
            Page targetPage = this.noteService.getNoteById(noteId);
            if (targetPage == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            DraftPage draftNote = this.noteService.getLatestDraftOfPage(targetPage, currentUserId);
            return Response.ok((Object)(draftNote != null ? draftNote : JSONObject.NULL)).build();
        }
        catch (Exception e) {
            log.error("Can't get draft note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/versions/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get versions of note by id", method="GET", description="This get the versions of a note if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNoteVersions(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok(this.noteService.getVersionsHistoryOfNote(note, identity.getUserId())).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            log.error("Can't get versions list of note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/note")
    @RolesAllowed(value={"users"})
    @Operation(summary="Add a new note", method="POST", description="This adds a new note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response createNote(@Parameter(description="note object to be created", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        String noteBookType = note.getWikiType();
        String noteBookOwner = note.getWikiOwner();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (StringUtils.isNotEmpty((CharSequence)note.getParentPageId())) {
                Page note_ = this.noteService.getNoteById(note.getParentPageId(), identity);
                if (note_ != null) {
                    noteBookType = note_.getWikiType();
                    noteBookOwner = note_.getWikiOwner();
                    note.setParentPageName(note_.getName());
                } else {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (StringUtils.isEmpty((CharSequence)noteBookType) || StringUtils.isEmpty((CharSequence)noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (this.noteService.isExisting(noteBookType, noteBookOwner, TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)NOTE_NAME_EXISTS).build();
            }
            Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String syntaxId = this.noteBookService.getDefaultWikiSyntaxId();
            String currentUser = identity.getUserId();
            note.setAuthor(currentUser);
            note.setOwner(currentUser);
            note.setSyntax(syntaxId);
            note.setName(TitleResolver.getId(note.getTitle(), false));
            note.setUrl("");
            Page createdNote = this.noteService.createNote(noteBook, note.getParentPageName(), note, identity);
            return Response.ok((Object)createdNote, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{note.getName(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform save noteBook note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="saveDraft")
    @RolesAllowed(value={"users"})
    @Operation(summary="Add or update a new note draft page", method="POST", description="This adds a new note draft page or updates an existing one.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response saveDraft(@RequestBody(description="Note draft page object to be created", required=true) DraftPage draftNoteToSave) {
        if (draftNoteToSave == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)draftNoteToSave.getTitle())) {
            log.warn((Object)"Draft Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Draft Note's title should not be number}").build();
        }
        String noteBookType = draftNoteToSave.getWikiType();
        String noteBookOwner = draftNoteToSave.getWikiOwner();
        Page parentNote = null;
        Page targetNote = null;
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{draftNoteToSave.getParentPageId()})) {
                parentNote = this.noteService.getNoteById(draftNoteToSave.getParentPageId(), identity);
            }
            if (parentNote != null) {
                noteBookType = parentNote.getWikiType();
                noteBookOwner = parentNote.getWikiOwner();
                draftNoteToSave.setParentPageName(parentNote.getName());
            }
            if (StringUtils.isEmpty((CharSequence)noteBookType) || StringUtils.isEmpty((CharSequence)noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{draftNoteToSave.getTargetPageId()})) {
                targetNote = this.noteService.getNoteById(draftNoteToSave.getTargetPageId());
            }
            String syntaxId = this.noteBookService.getDefaultWikiSyntaxId();
            String currentUser = identity.getUserId();
            draftNoteToSave.setAuthor(currentUser);
            draftNoteToSave.setSyntax(syntaxId);
            draftNoteToSave = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{draftNoteToSave.getId()}) ? (targetNote != null ? this.noteService.updateDraftForExistPage(draftNoteToSave, targetNote, null, System.currentTimeMillis(), currentUser) : this.noteService.updateDraftForNewPage(draftNoteToSave, System.currentTimeMillis())) : (targetNote != null ? this.noteService.createDraftForExistPage(draftNoteToSave, targetNote, null, System.currentTimeMillis(), currentUser) : this.noteService.createDraftForNewPage(draftNoteToSave, System.currentTimeMillis()));
            return Response.ok((Object)draftNoteToSave, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform save noteBook draft note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, draftNoteToSave.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific note by note's params", method="PUT", description="This updates the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateNote(@Parameter(description="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @Parameter(description="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @RequestBody(description="note object to be updated", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        try {
            if (noteBookType.toUpperCase().equals(WikiType.GROUP.name())) {
                noteBookOwner = this.formatWikiOwnerToGroupId(noteBookOwner);
            }
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!note_.isCanManage()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            note_.setToBePublished(note.isToBePublished());
            if (!note_.getTitle().equals(note.getTitle()) && this.noteService.isExisting(noteBookType, noteBookOwner, TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)NOTE_NAME_EXISTS).build();
            }
            if (!note_.getTitle().equals(note.getTitle()) && !note_.getContent().equals(note.getContent())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                note_.setTitle(note.getTitle());
                note_.setContent(note.getContent());
                if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(noteBookType, noteBookOwner, note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId());
            } else if (!note_.getTitle().equals(note.getTitle())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(noteBookType, noteBookOwner, note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_.setTitle(note.getTitle());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId());
            } else if (!note_.getContent().equals(note.getContent())) {
                note_.setContent(note.getContent());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId());
            }
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.error("Failed to perform update noteBook note {}:{}:{}", new Object[]{note.getWikiType(), note.getWikiOwner(), note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/note/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific note by id", method="PUT", description="This updates the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @RequestBody(description="note object to be updated", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteById(noteId, identity);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!note_.isCanManage()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            if (!note_.getTitle().equals(note.getTitle()) && this.noteService.isExisting(note.getWikiType(), note.getWikiOwner(), TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)NOTE_NAME_EXISTS).build();
            }
            note_.setToBePublished(note.isToBePublished());
            String newNoteName = TitleResolver.getId(note.getTitle(), false);
            if (!note_.getTitle().equals(note.getTitle()) && !note_.getContent().equals(note.getContent())) {
                note_.setTitle(note.getTitle());
                note_.setContent(note.getContent());
                if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(note_.getWikiType(), note_.getWikiOwner(), note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId());
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams);
                }
            } else if (!note_.getTitle().equals(note.getTitle())) {
                if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(note_.getWikiType(), note_.getWikiOwner(), note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_.setTitle(note.getTitle());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId());
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams);
                }
            } else if (!note_.getContent().equals(note.getContent())) {
                note_.setContent(note.getContent());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId());
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams);
                }
            } else {
                note_.setUrl(Utils.getPageUrl(note));
            }
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have edit permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.error("Failed to perform update noteBook note {}:{}:{}", new Object[]{note.getWikiType(), note.getWikiOwner(), note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/restore/{noteVersion}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Restore a specific note version by version id", method="PUT", description="This restore the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response RestoreNoteVersion(@Parameter(description="Version Number", required=true) @PathParam(value="noteVersion") String noteVersion, @RequestBody(description="note object to be updated", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (NumberUtils.isNumber((String)note.getTitle())) {
            log.warn((Object)"Note's title should not be number");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ message: Note's title should not be number}").build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String currentUser = identity.getUserId();
            Page note_ = this.noteService.getNoteById(note.getId(), identity);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!note_.isCanManage()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.noteService.restoreVersionOfNote(noteVersion, note, currentUser);
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have permissions to restore the note {} version", new Object[]{note.getId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.error("Failed to perform restore note version {}", new Object[]{noteVersion, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete note by note's params", method="PUT", description="This delets the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteNote(@Parameter(description="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @Parameter(description="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity;
            Page note_;
            if (noteBookType.toUpperCase().equals(WikiType.GROUP.name())) {
                noteBookOwner = this.formatWikiOwnerToGroupId(noteBookOwner);
            }
            if ((note_ = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId, identity = ConversationState.getCurrent().getIdentity())) == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.noteService.deleteNote(noteBookType, noteBookOwner, noteId, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have delete permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform Delete of noteBook note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/note/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete note by note's params", method="PUT", description="This deletes the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String noteName = note.getName();
            if (!"__anonim".equals(identity.getUserId())) {
                WikiPageParams noteParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), noteName);
                this.noteService.removeDraftOfNote(noteParams);
            }
            this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), noteName, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have delete permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform Delete of noteBook note {}", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/draftNote/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete note by note's params", method="PUT", description="This deletes the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteDraftNote(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            String currentUserId = ConversationState.getCurrent().getIdentity().getUserId();
            DraftPage draftNote = this.noteService.getDraftNoteById(noteId, currentUserId);
            if (draftNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String draftNoteName = draftNote.getName();
            this.noteService.removeDraft(draftNoteName);
            return Response.ok().build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform Delete of noteBook note {}", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PATCH
    @Path(value="/note/move/{noteId}/{destinationNoteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Move note under the destination one", method="PUT", description="This moves the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response moveNote(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="Destination Note id", required=true) @PathParam(value="destinationNoteId") String toNoteId) {
        try {
            WikiPageParams newLocationParams;
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Page toNote = this.noteService.getNoteById(toNoteId);
            if (toNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            WikiPageParams currentLocationParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName());
            boolean isMoved = this.noteService.moveNote(currentLocationParams, newLocationParams = new WikiPageParams(toNote.getWikiType(), toNote.getWikiOwner(), toNote.getName()), identity);
            if (isMoved) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have move permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.warn("Failed to perform move of noteBook note {} under {}", new Object[]{noteId, toNoteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/{exportId}/{notes}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Export notes", method="GET", description="This export selected notes and provide a zip file.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response exportNote(@Parameter(description="List of notes ids", required=true) @PathParam(value="notes") String notesList, @Parameter(description="export ID", required=true) @PathParam(value="exportId") int exportId, @Parameter(description="exportAll") @QueryParam(value="exportAll") Boolean exportAll) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String[] notes = notesList.split(",");
            this.notesExportService.startExportNotes(exportId, notes, exportAll, identity);
            return Response.ok().build();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/zip/{exportId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Export notes", method="GET", description="This export selected notes and provide a zip file.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getExportedZip(@Parameter(description="List of notes ids", required=true) @PathParam(value="exportId") int exportId) {
        try {
            byte[] filesBytes = this.notesExportService.getExportedNotes(exportId);
            return Response.ok((Object)filesBytes).type("application/zip").header("Content-Disposition", (Object)("attachment; filename=\"notesExport_" + new Date().getTime() + ".zip\"")).build();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/status/{exportId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Export notes", method="GET", description="This export selected notes and provide a zip file.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getExportNoteStatus(@Parameter(description="export id", required=true) @PathParam(value="exportId") int exportId) {
        try {
            return Response.ok((Object)this.notesExportService.getStatus(exportId)).build();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/cancel/{exportId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Export notes", method="GET", description="This cancel export.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response cancelExportNote(@Parameter(description="export id", required=true) @PathParam(value="exportId") int exportId) {
        try {
            this.notesExportService.cancelExportNotes(exportId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="/note/import/{noteId}/{uploadId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Import notes from a zip file", method="POST", description="This import notes from defined zip file under given note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response importNote(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="Upload id", required=true) @PathParam(value="uploadId") String uploadId, @Parameter(description="Conflict", required=true) @QueryParam(value="conflict") String conflict) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page parent = this.noteService.getNoteById(noteId, identity);
            if (parent == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
            if (uploadResource != null) {
                this.noteService.importNotes(uploadResource.getStoreLocation(), parent, conflict, identity);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have move permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            log.warn("Failed to export note {} ", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/tree/{type}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get node's tree", method="GET", description="Display the current tree of a noteBook based on is path")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getTreeData(@PathParam(value="type") String type, @QueryParam(value="path") String path, @QueryParam(value="page") String currentPath, @QueryParam(value="canEdit") Boolean canEdit, @QueryParam(value="excerpt") Boolean showExcerpt, @QueryParam(value="depth") String depth) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            List<JsonNodeData> responseData = new ArrayList<JsonNodeData>();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("canEdit", canEdit);
            if (currentPath != null) {
                currentPath = URLDecoder.decode(currentPath, StandardCharsets.UTF_8);
                context.put("page", currentPath);
                WikiPageParams currentNoteParam = TreeUtils.getPageParamsFromPath(currentPath);
                Page currentNote = this.noteService.getNoteOfNoteBookByName(currentNoteParam.getType(), currentNoteParam.getOwner(), currentNoteParam.getPageName(), identity);
                context.put("currentPage", currentNote);
            }
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            path = URLDecoder.decode(path, StandardCharsets.UTF_8);
            context.put("path", path);
            WikiPageParams noteParam = TreeUtils.getPageParamsFromPath(path);
            Page note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), noteParam.getPageName(), identity);
            if (note == null) {
                log.warn("User [{}] can not get noteBook path [{}]. Home is used instead", new Object[]{ConversationState.getCurrent().getIdentity().getUserId(), path});
                note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), "Home");
                if (note == null) {
                    ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.portlet.wiki.WikiPortlet", request.getLocale());
                    String errorMessage = "";
                    if (resourceBundle != null) {
                        errorMessage = resourceBundle.getString("UIWikiMovePageForm.msg.no-permission-at-wiki-destination");
                    }
                    return Response.serverError().entity((Object)("{ \"message\": \"" + errorMessage + "\"}")).cacheControl(this.cc).build();
                }
            }
            context.put("selectedPage", note);
            context.put("excerpt", showExcerpt);
            if (type.equalsIgnoreCase(TreeNode.TREETYPE.ALL.toString())) {
                Deque<WikiPageParams> stk = Utils.getStackParams(note);
                context.put("stackParams", stk);
                responseData = this.getJsonTree(noteParam, context);
            } else if (type.equalsIgnoreCase(TreeNode.TREETYPE.CHILDREN.toString())) {
                if (depth == null) {
                    depth = "1";
                }
                context.put("depth", depth);
                responseData = this.getJsonDescendants(noteParam, context);
            }
            this.encodeWikiTree(responseData, request.getLocale());
            BeanToJsons<JsonNodeData> toJsons = new BeanToJsons<JsonNodeData>(responseData);
            return Response.ok(toJsons, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{path, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            log.error((Object)("Failed for get tree data by rest service - Cause : " + e.getMessage()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/tree/full")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get node's tree", method="GET", description="Display the current tree of a noteBook based on is path")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getFullTreeData(@Parameter(description="Note path", required=true) @QueryParam(value="path") String path, @Parameter(description="With draft notes", required=true) @QueryParam(value="withDrafts") Boolean withDrafts) {
        try {
            List<JsonNodeData> bottomChildren;
            Identity identity = ConversationState.getCurrent().getIdentity();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("withDrafts", withDrafts);
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            path = URLDecoder.decode(path, StandardCharsets.UTF_8);
            context.put("path", path);
            WikiPageParams noteParam = TreeUtils.getPageParamsFromPath(path);
            Page note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), noteParam.getPageName(), identity);
            if (note == null) {
                log.warn("User [{}] can not get noteBook path [{}]. Home is used instead", new Object[]{ConversationState.getCurrent().getIdentity().getUserId(), path});
                note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), "Home");
                if (note == null) {
                    ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.portlet.wiki.WikiPortlet", request.getLocale());
                    String errorMessage = "";
                    if (resourceBundle != null) {
                        errorMessage = resourceBundle.getString("UIWikiMovePageForm.msg.no-permission-at-wiki-destination");
                    }
                    return Response.serverError().entity((Object)("{ \"message\": \"" + errorMessage + "\"}")).cacheControl(this.cc).build();
                }
            }
            context.put("selectedPage", note);
            context.put("canEdit", null);
            context.put("excerpt", null);
            Deque<WikiPageParams> stk = Utils.getStackParams(note);
            context.put("stackParams", stk);
            List<Object> finalTree = new ArrayList<JsonNodeData>();
            List<JsonNodeData> responseData = this.getJsonTree(noteParam, context);
            JsonNodeData rootNodeData = responseData.get(0);
            rootNodeData.setHasDraftDescendant(true);
            finalTree.add(rootNodeData);
            context.put("depth", "1");
            List<JsonNodeData> children = new ArrayList<JsonNodeData>(rootNodeData.getChildren());
            ArrayList<JsonNodeData> parents = new ArrayList<JsonNodeData>();
            do {
                parents.addAll(children);
                children.clear();
                for (JsonNodeData jsonNodeData2 : parents) {
                    if (jsonNodeData2.isHasChild()) {
                        path = URLDecoder.decode(jsonNodeData2.getPath(), StandardCharsets.UTF_8);
                        context.put("path", path);
                        noteParam = TreeUtils.getPageParamsFromPath(path);
                        try {
                            Page parentNote = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), noteParam.getPageName(), identity);
                            context.put("selectedPage", parentNote);
                        }
                        catch (EntityNotFoundException e) {
                            log.warn("Cannot find the note {}", new Object[]{noteParam.getPageName()});
                        }
                        List<JsonNodeData> childNotes = this.getJsonDescendants(noteParam, context);
                        children.addAll(childNotes);
                        jsonNodeData2.setChildren(childNotes);
                    }
                    finalTree.add(jsonNodeData2);
                }
                parents.clear();
            } while (!children.isEmpty());
            List<JsonNodeData> list = bottomChildren = Boolean.TRUE.equals(withDrafts) ? finalTree.stream().filter(JsonNodeData::isDraftPage).collect(Collectors.toList()) : finalTree.stream().filter(jsonNodeData -> !jsonNodeData.isHasChild()).collect(Collectors.toList());
            if (Boolean.TRUE.equals(withDrafts)) {
                for (JsonNodeData child : bottomChildren) {
                    JsonNodeData parent;
                    do {
                        parent = null;
                        String parentId = child.getParentPageId();
                        Optional<JsonNodeData> parentOptional = finalTree.stream().filter(jsonNodeData -> StringUtils.equals((CharSequence)jsonNodeData.getNoteId(), (CharSequence)parentId)).findFirst();
                        if (parentOptional.isPresent()) {
                            parent = parentOptional.get();
                            parent.setHasDraftDescendant(true);
                            int index = finalTree.indexOf(parent);
                            finalTree.set(index, parent);
                        }
                        child = parent;
                    } while (parent != null);
                }
                finalTree = finalTree.stream().filter(jsonNodeData -> jsonNodeData.isDraftPage() || Boolean.TRUE.equals(jsonNodeData.isHasDraftDescendant())).collect(Collectors.toList());
            }
            while (bottomChildren.size() > 1 || bottomChildren.size() == 1 && ((JsonNodeData)bottomChildren.get(0)).getParentPageId() != null) {
                for (JsonNodeData bottomChild : bottomChildren) {
                    int index;
                    String parentPageId = bottomChild.getParentPageId();
                    Optional<JsonNodeData> parentOptional = finalTree.stream().filter(jsonNodeData -> StringUtils.equals((CharSequence)jsonNodeData.getNoteId(), (CharSequence)parentPageId)).findFirst();
                    if (!parentOptional.isPresent()) continue;
                    JsonNodeData parent = parentOptional.get();
                    if (Boolean.TRUE.equals(withDrafts) && !Boolean.TRUE.equals(parent.isHasDraftDescendant())) continue;
                    children = parent.getChildren();
                    if (Boolean.TRUE.equals(withDrafts)) {
                        children = children.stream().filter(jsonNodeData -> jsonNodeData.isDraftPage() || Boolean.TRUE.equals(jsonNodeData.isHasDraftDescendant())).collect(Collectors.toList());
                    }
                    int indexChild = children.indexOf(bottomChild);
                    children.remove(bottomChild);
                    if (!Boolean.TRUE.equals(withDrafts) || bottomChild.isDraftPage() || Boolean.TRUE.equals(bottomChild.isHasDraftDescendant())) {
                        children.add(indexChild, bottomChild);
                    }
                    parent.setChildren(children);
                    if (finalTree.contains(parent)) {
                        index = finalTree.indexOf(parent);
                        finalTree.set(index, parent);
                    }
                    if (parents.contains(parent)) {
                        index = parents.indexOf(parent);
                        parents.set(index, parent);
                        continue;
                    }
                    parents.add(parent);
                }
                bottomChildren.clear();
                bottomChildren.addAll(parents);
                parents.clear();
            }
            this.encodeWikiTree(bottomChildren, request.getLocale());
            BeanToJsons<JsonNodeData> beanToJsons = new BeanToJsons<JsonNodeData>(finalTree, bottomChildren);
            return Response.ok(beanToJsons, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            log.error("User does not have view permissions on the note {}", new Object[]{path, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            log.error((Object)("Failed for get tree data by rest service - Cause : " + e.getMessage()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="contextsearch/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response searchData(@Context UriInfo uriInfo, @QueryParam(value="keyword") String keyword, @QueryParam(value="limit") int limit, @QueryParam(value="wikiType") String wikiType, @QueryParam(value="wikiOwner") String wikiOwner, @QueryParam(value="favorites") boolean favorites) throws Exception {
        limit = limit > 0 ? limit : RestUtils.getLimit((UriInfo)uriInfo);
        try {
            keyword = keyword.toLowerCase();
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            WikiSearchData data = new WikiSearchData(keyword, currentIdentity.getUserId());
            data.setLimit(limit);
            data.setFavorites(favorites);
            List results = this.noteService.search(data).getAll();
            ArrayList<TitleSearchResult> titleSearchResults = new ArrayList<TitleSearchResult>();
            for (SearchResult searchResult : results) {
                Page page = this.noteService.getNoteOfNoteBookByName(searchResult.getWikiType(), searchResult.getWikiOwner(), searchResult.getPageName(), currentIdentity);
                if (page != null) {
                    page.setUrl(Utils.getPageUrl(page));
                    if (SearchResultType.ATTACHMENT.equals((Object)searchResult.getType())) {
                        Attachment attachment = this.noteBookService.getAttachmentOfPageByName(searchResult.getAttachmentName(), page);
                        TitleSearchResult titleSearchResult = new TitleSearchResult();
                        titleSearchResult.setTitle(attachment.getName());
                        titleSearchResult.setId(page.getId());
                        titleSearchResult.setActivityId(page.getActivityId());
                        titleSearchResult.setType(searchResult.getType());
                        titleSearchResult.setUrl(attachment.getDownloadURL());
                        titleSearchResult.setMetadatas(page.getMetadatas());
                        titleSearchResults.add(titleSearchResult);
                        continue;
                    }
                    if (searchResult.getPoster() == null) continue;
                    IdentityEntity posterIdentity = EntityBuilder.buildEntityIdentity((org.exoplatform.social.core.identity.model.Identity)searchResult.getPoster(), (String)uriInfo.getPath(), (String)"all");
                    IdentityEntity wikiOwnerIdentity = searchResult.getWikiOwnerIdentity() != null ? EntityBuilder.buildEntityIdentity((org.exoplatform.social.core.identity.model.Identity)searchResult.getWikiOwnerIdentity(), (String)uriInfo.getPath(), (String)"all") : null;
                    TitleSearchResult titleSearchResult = new TitleSearchResult();
                    titleSearchResult.setTitle(searchResult.getTitle());
                    titleSearchResult.setId(page.getId());
                    titleSearchResult.setActivityId(page.getActivityId());
                    titleSearchResult.setPoster(posterIdentity);
                    titleSearchResult.setWikiOwner(wikiOwnerIdentity);
                    titleSearchResult.setExcerpt(searchResult.getExcerpt());
                    titleSearchResult.setCreatedDate(searchResult.getCreatedDate().getTimeInMillis());
                    titleSearchResult.setType(searchResult.getType());
                    titleSearchResult.setUrl(page.getUrl());
                    titleSearchResult.setMetadatas(page.getMetadatas());
                    titleSearchResults.add(titleSearchResult);
                    continue;
                }
                log.warn((Object)("Cannot get page of search result " + searchResult.getWikiType() + ":" + searchResult.getWikiOwner() + ":" + searchResult.getPageName()));
            }
            return Response.ok(new BeanToJsons(titleSearchResults), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    private List<JsonNodeData> getJsonTree(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(params.getType(), params.getOwner());
        WikiTreeNode noteBookNode = new WikiTreeNode(noteBook);
        noteBookNode.pushDescendants(context, ConversationState.getCurrent().getIdentity().getUserId());
        return TreeUtils.tranformToJson(noteBookNode, context);
    }

    private List<JsonNodeData> getJsonDescendants(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        TreeNode treeNode = TreeUtils.getDescendants(params, context, ConversationState.getCurrent().getIdentity().getUserId());
        return TreeUtils.tranformToJson(treeNode, context);
    }

    private void encodeWikiTree(List<JsonNodeData> responseData, Locale locale) throws Exception {
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.wiki.service.WikiService", locale);
        String untitledLabel = "";
        if (resourceBundle == null) {
            log.warn("Cannot find resource bundle '{}'", new Object[]{"locale.wiki.service.WikiService"});
        } else {
            untitledLabel = resourceBundle.getString("Page.Untitled");
        }
        for (JsonNodeData data : responseData) {
            if (StringUtils.isBlank((CharSequence)data.getName())) {
                data.setName(untitledLabel);
            }
            if (!CollectionUtils.isNotEmpty(data.getChildren())) continue;
            this.encodeWikiTree(data.getChildren(), locale);
        }
    }

    private Page updateChildrenContainer(Page note) throws WikiException {
        String content = note.getContent();
        String oldChildrenContainer = "<div class=\"wiki-children-pages ck-widget\" contenteditable=\"false\"><exo-wiki-children-pages>&nbsp;</exo-wiki-children-pages></div>";
        String childrenContainer = "<div class=\"navigation-img-wrapper\" contenteditable=\"false\" id=\"note-children-container\">\n<figure class=\"image-navigation\" contenteditable=\"false\"><img alt=\"\" data-plugin-name=\"selectImage\" referrerpolicy=\"no-referrer\" role=\"presentation\" src=\"/notes/images/children.png\" /><img alt=\"remove treeview\" data-plugin-name=\"selectImage\" id=\"remove-treeview\" referrerpolicy=\"no-referrer\" src=\"/notes/images/trash.png\" />\n<figcaption class=\"note-navigation-label\">Navigation</figcaption>\n</figure>\n</div>\n\n<p>&nbsp;</p>\n";
        content = content.replace(oldChildrenContainer, childrenContainer);
        note.setContent(content);
        return this.noteService.updateNote(note);
    }

    private String formatWikiOwnerToGroupId(String wikiOwner) {
        if (wikiOwner == null || ((String)wikiOwner).length() == 0) {
            return null;
        }
        if (!((String)wikiOwner).startsWith("/")) {
            wikiOwner = "/" + (String)wikiOwner;
        }
        if (((String)wikiOwner).endsWith("/")) {
            wikiOwner = ((String)wikiOwner).substring(0, ((String)wikiOwner).length() - 1);
        }
        return wikiOwner;
    }
}

