/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;

@Entity(name="WikiDraftPageEntity")
@ExoEntity
@Table(name="WIKI_DRAFT_PAGES")
@NamedQueries(value={@NamedQuery(name="wikiDraftPage.findDraftPagesByUser", query="SELECT d FROM WikiDraftPageEntity d WHERE d.author = :username ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.findDraftPageByUserAndName", query="SELECT d FROM WikiDraftPageEntity d WHERE d.author = :username AND d.name = :draftPageName ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.findLatestDraftPageByUserAndTargetPage", query="SELECT d FROM WikiDraftPageEntity d WHERE d.author = :username AND d.targetPage.id = :targetPageId ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.findDraftPageByUserAndTargetPage", query="SELECT d FROM WikiDraftPageEntity d WHERE d.author = :username AND d.targetPage.id = :targetPageId"), @NamedQuery(name="wikiDraftPage.findDraftPagesByUserAndParentPage", query="SELECT d FROM WikiDraftPageEntity d WHERE d.author = :username AND d.parentPage.id = :parentPageId"), @NamedQuery(name="wikiDraftPage.findLatestDraftPageByUserAndTargetPageAndLang", query="SELECT d FROM WikiDraftPageEntity d WHERE d.author = :username AND d.targetPage.id = :targetPageId AND ((:lang IS NULL AND d.lang IS NULL) OR (:lang IS NOT NULL AND d.lang = :lang)) ORDER BY d.updatedDate DESC")})
public class DraftPageEntity
extends BasePageEntity {
    @Id
    @SequenceGenerator(name="SEQ_WIKI_DRAFT_PAGES_DRAFT_ID", sequenceName="SEQ_WIKI_DRAFT_PAGES_DRAFT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_DRAFT_PAGES_DRAFT_ID")
    @Column(name="DRAFT_PAGE_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="TARGET_PAGE_ID")
    private PageEntity targetPage;
    @ManyToOne
    @JoinColumn(name="PARENT_PAGE_ID")
    private PageEntity parentPage;
    @Column(name="TARGET_PAGE_REVISION")
    private String targetRevision;
    @Column(name="NEW_PAGE")
    private boolean newPage;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="draftPage")
    private List<DraftPageAttachmentEntity> attachments;
    @Column(name="LANG")
    private String lang;

    public PageEntity getTargetPage() {
        return this.targetPage;
    }

    public void setTargetPage(PageEntity targetPage) {
        this.targetPage = targetPage;
    }

    public PageEntity getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(PageEntity parentPage) {
        this.parentPage = parentPage;
    }

    public String getTargetRevision() {
        return this.targetRevision;
    }

    public void setTargetRevision(String targetRevision) {
        this.targetRevision = targetRevision;
    }

    public boolean isNewPage() {
        return this.newPage;
    }

    public void setNewPage(boolean newPage) {
        this.newPage = newPage;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<DraftPageAttachmentEntity> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<DraftPageAttachmentEntity> attachments) {
        this.attachments = attachments;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

