/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.JPADataStorage;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.junit.Test;
import org.mockito.Mockito;

public class JPADataStorageTest
extends BaseWikiJPAIntegrationTest {
    protected JPADataStorage storage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.storage = (JPADataStorage)PortalContainer.getInstance().getComponentInstanceOfType(JPADataStorage.class);
    }

    @Test
    public void testCreateWiki() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        this.storage.createWiki(wiki);
        Wiki createdWiki = this.storage.getWikiByTypeAndOwner("portal", "wiki1");
        Page wikiHomePage = createdWiki.getWikiHome();
        JPADataStorageTest.assertNotNull((Object)createdWiki);
        JPADataStorageTest.assertEquals((String)"portal", (String)createdWiki.getType());
        JPADataStorageTest.assertEquals((String)"wiki1", (String)createdWiki.getOwner());
        JPADataStorageTest.assertNotNull((Object)wikiHomePage);
        JPADataStorageTest.assertEquals((String)"Home", (String)wikiHomePage.getName());
        JPADataStorageTest.assertEquals((String)"Home", (String)wikiHomePage.getTitle());
        JPADataStorageTest.assertNotNull((Object)wikiHomePage.getCreatedDate());
        JPADataStorageTest.assertNotNull((Object)wikiHomePage.getUpdatedDate());
        JPADataStorageTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)wikiHomePage.getContent()));
    }

    @Test
    public void testWikiPermissions() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        Identity userIdentity = new Identity("user", Arrays.asList(new MembershipEntry("/platform/users", "*")));
        Identity adminIdentity = new Identity("admin", Arrays.asList(new MembershipEntry("/platform/users", "*"), new MembershipEntry("/platform/administrators", "*")));
        ArrayList<PermissionEntry> wikiPermissions = new ArrayList<PermissionEntry>();
        wikiPermissions.add(new PermissionEntry("user", null, IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)}));
        wikiPermissions.add(new PermissionEntry("admin", null, IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true), new Permission(PermissionType.ADMINPAGE, true), new Permission(PermissionType.ADMINSPACE, true)}));
        wiki.setPermissions(wikiPermissions);
        this.storage.createWiki(wiki);
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnWiki(wiki, PermissionType.VIEWPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnWiki(wiki, PermissionType.VIEWPAGE, adminIdentity));
        JPADataStorageTest.assertFalse((boolean)this.storage.hasPermissionOnWiki(wiki, PermissionType.EDITPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnWiki(wiki, PermissionType.EDITPAGE, adminIdentity));
        JPADataStorageTest.assertFalse((boolean)this.storage.hasAdminPagePermission(wiki.getType(), wiki.getOwner(), userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasAdminPagePermission(wiki.getType(), wiki.getOwner(), adminIdentity));
        JPADataStorageTest.assertFalse((boolean)this.storage.hasAdminSpacePermission(wiki.getType(), wiki.getOwner(), userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasAdminSpacePermission(wiki.getType(), wiki.getOwner(), adminIdentity));
    }

    @Test
    public void testUpdateWikiPermissions() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        ArrayList<PermissionEntry> initialPermissions = new ArrayList<PermissionEntry>();
        initialPermissions.add(new PermissionEntry("user", null, IDType.USER, new Permission[]{new Permission(PermissionType.ADMINPAGE, true)}));
        ArrayList<PermissionEntry> updatedPermissions = new ArrayList<PermissionEntry>();
        updatedPermissions.add(new PermissionEntry("admin", null, IDType.USER, new Permission[]{new Permission(PermissionType.ADMINPAGE, true), new Permission(PermissionType.ADMINSPACE, true)}));
        this.storage.createWiki(wiki);
        this.storage.updateWikiPermission("portal", "wiki1", initialPermissions);
        List fetchedInitialPermissions = this.storage.getWikiPermission("portal", "wiki1");
        this.storage.updateWikiPermission("portal", "wiki1", updatedPermissions);
        List fetchedUpdatedPermissions = this.storage.getWikiPermission("portal", "wiki1");
        JPADataStorageTest.assertNotNull((Object)fetchedInitialPermissions);
        JPADataStorageTest.assertEquals((int)1, (int)fetchedInitialPermissions.size());
        JPADataStorageTest.assertTrue((boolean)ArrayUtils.contains((Object[])((PermissionEntry)fetchedInitialPermissions.get(0)).getPermissions(), (Object)new Permission(PermissionType.ADMINPAGE, true)));
        JPADataStorageTest.assertTrue((boolean)ArrayUtils.contains((Object[])((PermissionEntry)fetchedInitialPermissions.get(0)).getPermissions(), (Object)new Permission(PermissionType.ADMINSPACE, false)));
        JPADataStorageTest.assertNotNull((Object)fetchedUpdatedPermissions);
        JPADataStorageTest.assertEquals((int)1, (int)fetchedUpdatedPermissions.size());
        JPADataStorageTest.assertTrue((boolean)ArrayUtils.contains((Object[])((PermissionEntry)fetchedUpdatedPermissions.get(0)).getPermissions(), (Object)new Permission(PermissionType.ADMINPAGE, true)));
        JPADataStorageTest.assertTrue((boolean)ArrayUtils.contains((Object[])((PermissionEntry)fetchedUpdatedPermissions.get(0)).getPermissions(), (Object)new Permission(PermissionType.ADMINSPACE, true)));
    }

    @Test
    public void testParentPageOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page parentPage = new Page();
        parentPage.setWikiId(wiki.getId());
        parentPage.setWikiType(wiki.getType());
        parentPage.setWikiOwner(wiki.getOwner());
        parentPage.setName("page0");
        parentPage.setTitle("Page 0");
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        this.storage.createPage(wiki, wiki.getWikiHome(), parentPage);
        this.storage.createPage(wiki, parentPage, page);
        Page pageOfWikiByName = this.storage.getPageOfWikiByName("portal", "wiki1", "page1");
        JPADataStorageTest.assertEquals((int)3, (int)this.pageDAO.findAll().size());
        JPADataStorageTest.assertNotNull((Object)pageOfWikiByName);
        JPADataStorageTest.assertEquals((String)"portal", (String)pageOfWikiByName.getWikiType());
        JPADataStorageTest.assertEquals((String)"wiki1", (String)pageOfWikiByName.getWikiOwner());
        JPADataStorageTest.assertEquals((String)"page1", (String)pageOfWikiByName.getName());
        JPADataStorageTest.assertEquals((String)"Page 1", (String)pageOfWikiByName.getTitle());
    }

    @Test
    public void testGetAllWikiPages() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wikiTest4");
        wiki = this.storage.createWiki(wiki);
        Page parentPage = new Page();
        parentPage.setWikiId(wiki.getId());
        parentPage.setWikiType(wiki.getType());
        parentPage.setWikiOwner(wiki.getType());
        parentPage.setName("page0");
        parentPage.setTitle("Page 0");
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        this.storage.createPage(wiki, wiki.getWikiHome(), parentPage);
        this.storage.createPage(wiki, parentPage, page);
        List pagesOfWiki = this.storage.getPagesOfWiki(wiki.getType(), wiki.getOwner());
        JPADataStorageTest.assertNotNull((Object)pagesOfWiki);
        JPADataStorageTest.assertEquals((int)3, (int)pagesOfWiki.size());
    }

    @Test
    public void testChildrenPagesOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page parentPage = new Page();
        parentPage.setWikiId(wiki.getId());
        parentPage.setWikiType(wiki.getType());
        parentPage.setWikiOwner(wiki.getOwner());
        parentPage.setName("page0");
        parentPage.setTitle("Page 0");
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setName("page2");
        page2.setTitle("Page 2");
        this.storage.createPage(wiki, wiki.getWikiHome(), parentPage);
        this.storage.createPage(wiki, parentPage, page1);
        this.storage.createPage(wiki, parentPage, page2);
        List childrenPages = this.storage.getChildrenPageOf(parentPage, true);
        JPADataStorageTest.assertEquals((int)4, (int)this.pageDAO.findAll().size());
        JPADataStorageTest.assertNotNull((Object)childrenPages);
        JPADataStorageTest.assertEquals((int)2, (int)childrenPages.size());
    }

    @Test
    public void testDeletePage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        JPADataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.storage.deletePage(wiki.getType(), wiki.getOwner(), page1.getName());
        JPADataStorageTest.assertEquals((int)1, (int)this.pageDAO.findAllIds(0, 0).size());
        List pages = this.pageDAO.getAllPagesOfWiki(wiki.getType(), wiki.getOwner());
        JPADataStorageTest.assertEquals((int)2, (int)pages.size());
        pages = this.pageDAO.getPagesOfWiki(wiki.getType(), wiki.getOwner(), false);
        JPADataStorageTest.assertEquals((int)1, (int)pages.size());
        JPADataStorageTest.assertEquals((String)"Home", (String)((PageEntity)pages.get(0)).getName());
        pages = this.pageDAO.getPagesOfWiki(wiki.getType(), wiki.getOwner(), true);
        JPADataStorageTest.assertEquals((int)1, (int)pages.size());
        JPADataStorageTest.assertEquals((String)"page1", (String)((PageEntity)pages.get(0)).getName());
    }

    @Test
    public void testDeletePageTree() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setName("page2");
        page2.setTitle("Page 2");
        this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        this.storage.createPage(wiki, page1, page2);
        JPADataStorageTest.assertEquals((int)3, (int)this.pageDAO.findAll().size());
        this.storage.deletePage(wiki.getType(), wiki.getOwner(), page1.getName());
        JPADataStorageTest.assertEquals((int)1, (int)this.pageDAO.findAllIds(0, 0).size());
    }

    @Test
    public void testMovePage() throws WikiException {
        Wiki wiki1 = new Wiki();
        wiki1.setType("portal");
        wiki1.setOwner("wiki1");
        wiki1 = this.storage.createWiki(wiki1);
        Wiki wiki2 = new Wiki();
        wiki2.setType("portal");
        wiki2.setOwner("wiki2");
        wiki2 = this.storage.createWiki(wiki2);
        Page page1 = new Page();
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page11 = new Page();
        page11.setName("page11");
        page11.setTitle("Page 11");
        Page page2 = new Page();
        page2.setName("page2");
        page2.setTitle("Page 2");
        this.storage.createPage(wiki1, wiki1.getWikiHome(), page1);
        this.storage.createPage(wiki1, page1, page11);
        this.storage.createPage(wiki1, wiki1.getWikiHome(), page2);
        JPADataStorageTest.assertEquals((int)5, (int)this.pageDAO.findAll().size());
        JPADataStorageTest.assertEquals((int)2, (int)this.storage.getChildrenPageOf(wiki1.getWikiHome(), true).size());
        this.storage.movePage(new WikiPageParams(wiki1.getType(), wiki1.getOwner(), page1.getName()), new WikiPageParams(wiki2.getType(), wiki2.getOwner(), wiki2.getWikiHome().getName()));
        JPADataStorageTest.assertEquals((int)5, (int)this.pageDAO.findAll().size());
        JPADataStorageTest.assertEquals((int)1, (int)this.storage.getChildrenPageOf(wiki1.getWikiHome(), true).size());
        List wiki2HomeChildrenPages = this.storage.getChildrenPageOf(wiki2.getWikiHome(), true);
        JPADataStorageTest.assertEquals((int)1, (int)wiki2HomeChildrenPages.size());
        Page movedPage1 = (Page)wiki2HomeChildrenPages.get(0);
        JPADataStorageTest.assertEquals((String)"page1", (String)movedPage1.getName());
        JPADataStorageTest.assertEquals((String)"Page 1", (String)movedPage1.getTitle());
        JPADataStorageTest.assertEquals((int)1, (int)this.storage.getChildrenPageOf(movedPage1, true).size());
        Page fetchedPage11 = this.storage.getPageOfWikiByName(PortalConfig.PORTAL_TYPE, "wiki2", "page11");
        JPADataStorageTest.assertNotNull((Object)fetchedPage11);
        JPADataStorageTest.assertEquals((String)"page11", (String)fetchedPage11.getName());
    }

    @Test
    public void testUpdatePage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        JPADataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        createdPage.setTitle("Page 1 updated");
        this.storage.updatePage(createdPage);
        JPADataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        Page updatedPage = this.storage.getPageById(createdPage.getId());
        JPADataStorageTest.assertNotNull((Object)updatedPage);
        JPADataStorageTest.assertEquals((String)"page1", (String)updatedPage.getName());
        JPADataStorageTest.assertEquals((String)"Page 1 updated", (String)updatedPage.getTitle());
    }

    @Test
    public void testRenamePage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        JPADataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.storage.renamePage(wiki.getType(), wiki.getOwner(), page1.getName(), "newName", "New Title");
        JPADataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        Page renamedPage = this.storage.getPageById(createdPage.getId());
        JPADataStorageTest.assertNotNull((Object)renamedPage);
        JPADataStorageTest.assertEquals((String)"newName", (String)renamedPage.getName());
        JPADataStorageTest.assertEquals((String)"New Title", (String)renamedPage.getTitle());
    }

    @Test
    public void testPermissionsOnPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Identity userIdentity = new Identity("user", Arrays.asList(new MembershipEntry("/platform/users", "*")));
        Identity adminIdentity = new Identity("admin", Arrays.asList(new MembershipEntry("/platform/users", "*"), new MembershipEntry("/platform/administrators", "*")));
        Page noPermissionPage = new Page();
        noPermissionPage.setWikiId(wiki.getId());
        noPermissionPage.setWikiType(wiki.getType());
        noPermissionPage.setWikiOwner(wiki.getOwner());
        noPermissionPage.setName("page1");
        noPermissionPage.setTitle("Page 1");
        noPermissionPage.setPermissions(new ArrayList());
        noPermissionPage = this.storage.createPage(wiki, wiki.getWikiHome(), noPermissionPage);
        Page publicPage = new Page();
        publicPage.setWikiId(wiki.getId());
        publicPage.setWikiType(wiki.getType());
        publicPage.setWikiOwner(wiki.getOwner());
        publicPage.setName("page1");
        publicPage.setTitle("Page 1");
        publicPage.setPermissions(Arrays.asList(new PermissionEntry(IdentityConstants.ANY, null, IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)})));
        publicPage = this.storage.createPage(wiki, wiki.getWikiHome(), publicPage);
        Page authenticatedPage = new Page();
        authenticatedPage.setWikiId(wiki.getId());
        authenticatedPage.setWikiType(wiki.getType());
        authenticatedPage.setWikiOwner(wiki.getOwner());
        authenticatedPage.setName("page2");
        authenticatedPage.setTitle("Page 2");
        authenticatedPage.setPermissions(Arrays.asList(new PermissionEntry("/platform/users", null, IDType.GROUP, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)}), new PermissionEntry("/platform/administrators", null, IDType.GROUP, new Permission[]{new Permission(PermissionType.EDITPAGE, true)})));
        authenticatedPage = this.storage.createPage(wiki, wiki.getWikiHome(), authenticatedPage);
        Page adminPage = new Page();
        adminPage.setWikiId(wiki.getId());
        adminPage.setWikiType(wiki.getType());
        adminPage.setWikiOwner(wiki.getOwner());
        adminPage.setName("page3");
        adminPage.setTitle("Page 3");
        adminPage.setPermissions(Arrays.asList(new PermissionEntry("*:/platform/administrators", null, IDType.MEMBERSHIP, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)})));
        adminPage = this.storage.createPage(wiki, wiki.getWikiHome(), adminPage);
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(noPermissionPage, PermissionType.VIEWPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(noPermissionPage, PermissionType.VIEWPAGE, adminIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(publicPage, PermissionType.VIEWPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(publicPage, PermissionType.VIEWPAGE, adminIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(authenticatedPage, PermissionType.VIEWPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(authenticatedPage, PermissionType.VIEWPAGE, adminIdentity));
        JPADataStorageTest.assertFalse((boolean)this.storage.hasPermissionOnPage(authenticatedPage, PermissionType.EDITPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(authenticatedPage, PermissionType.EDITPAGE, adminIdentity));
        JPADataStorageTest.assertFalse((boolean)this.storage.hasPermissionOnPage(adminPage, PermissionType.VIEWPAGE, userIdentity));
        JPADataStorageTest.assertTrue((boolean)this.storage.hasPermissionOnPage(adminPage, PermissionType.VIEWPAGE, adminIdentity));
    }

    @Test
    public void testRelatedPagesOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page0");
        page.setTitle("Page 0");
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setCreatedDate(new Date());
        page1.setUpdatedDate(new Date());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setCreatedDate(new Date());
        page2.setUpdatedDate(new Date());
        page2.setName("page2");
        page2.setTitle("Page 2");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Page createdPage1 = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        Page createdPage2 = this.storage.createPage(wiki, wiki.getWikiHome(), page2);
        this.storage.addRelatedPage(createdPage, page1);
        this.storage.addRelatedPage(createdPage, page2);
        JPADataStorageTest.assertEquals((int)4, (int)this.pageDAO.findAll().size());
        JPADataStorageTest.assertNotNull((Object)createdPage);
        JPADataStorageTest.assertNotNull((Object)this.storage.getRelatedPagesOfPage(createdPage));
        JPADataStorageTest.assertEquals((int)2, (int)this.storage.getRelatedPagesOfPage(createdPage).size());
    }

    @Test
    public void testRemoveRelatedPagesOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page0");
        page.setTitle("Page 0");
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setCreatedDate(new Date());
        page1.setUpdatedDate(new Date());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setCreatedDate(new Date());
        page2.setUpdatedDate(new Date());
        page2.setName("page2");
        page2.setTitle("Page 2");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Page createdPage1 = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        Page createdPage2 = this.storage.createPage(wiki, wiki.getWikiHome(), page2);
        this.storage.addRelatedPage(createdPage, page1);
        this.storage.addRelatedPage(createdPage, page2);
        List relatedPagesBeforeDeletion = this.storage.getRelatedPagesOfPage(page);
        this.storage.removeRelatedPage(createdPage, createdPage1);
        List relatedPagesAfterDeletion = this.storage.getRelatedPagesOfPage(page);
        JPADataStorageTest.assertNotNull((Object)relatedPagesBeforeDeletion);
        JPADataStorageTest.assertEquals((int)2, (int)relatedPagesBeforeDeletion.size());
        JPADataStorageTest.assertNotNull((Object)relatedPagesAfterDeletion);
        JPADataStorageTest.assertEquals((int)1, (int)relatedPagesAfterDeletion.size());
    }

    @Test
    public void testGetDraftsOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 Updated");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user1");
        draftPage2.setName("DraftPage1");
        draftPage2.setTitle("DraftPage 1");
        draftPage2.setContent("Content Page 1 Updated Again");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("2");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user1");
        List fetchedDrafts = this.storage.getDraftsOfPage(Long.valueOf(createdPage.getId()));
        JPADataStorageTest.assertNotNull((Object)fetchedDrafts);
        JPADataStorageTest.assertEquals((int)2, (int)fetchedDrafts.size());
    }

    @Test
    public void testGetLatestDraftOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 Updated");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user1");
        draftPage2.setName("DraftPage1");
        draftPage2.setTitle("DraftPage 1");
        draftPage2.setContent("Content Page 1 Updated Again");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("2");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user1");
        DraftPage latestDraft = this.storage.getLatestDraftOfPage(createdPage);
        JPADataStorageTest.assertNotNull((Object)latestDraft);
        JPADataStorageTest.assertEquals((String)draftPage2.getName(), (String)latestDraft.getName());
    }

    @Test
    public void testDraftPageByNameAndTargetPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 Updated");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user1");
        draftPage2.setName("DraftPage2");
        draftPage2.setTitle("DraftPage 2");
        draftPage2.setContent("Content Page 2 Updated");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("1");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user1");
        DraftPage fetchedDraftPage = this.storage.getDraft(new WikiPageParams("portal", "wiki1", "page1"));
        JPADataStorageTest.assertNotNull((Object)fetchedDraftPage);
        JPADataStorageTest.assertEquals((String)"DraftPage2", (String)fetchedDraftPage.getName());
    }

    @Test
    public void testGetExistingOrNewDraftPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Page page1 = this.storage.getExsitedOrNewDraftPageById("portal", "wiki1", "page1", "user1");
        JPADataStorageTest.assertNotNull((Object)page1);
        JPADataStorageTest.assertTrue((boolean)(page1 instanceof DraftPage));
        JPADataStorageTest.assertEquals((String)PortalConfig.USER_TYPE, (String)page1.getWikiType());
        JPADataStorageTest.assertEquals((String)"user1", (String)page1.getWikiOwner());
        JPADataStorageTest.assertEquals((String)"page1", (String)page1.getName());
    }

    @Test
    public void testDeleteDraftPageByNameAndTargetPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 User1");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setCreatedDate(oneYearAgo);
        draftPage1.setUpdatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user2");
        draftPage2.setName("DraftPage2");
        draftPage2.setTitle("DraftPage 2");
        draftPage2.setContent("Content Page 1 User 2");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("1");
        draftPage2.setCreatedDate(now);
        draftPage2.setUpdatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user2");
        this.storage.deleteDraftOfPage(createdPage);
        DraftPage initialDraftPage = this.storage.getDraft(new WikiPageParams("portal", "wiki1", "page1"));
        JPADataStorageTest.assertNull((Object)initialDraftPage);
    }

    @Test
    public void testDeleteDraftPageByName() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 User1");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user2");
        draftPage2.setName("DraftPage2");
        draftPage2.setTitle("DraftPage 2");
        draftPage2.setContent("Content Page 1 User 2");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("1");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user2");
        this.storage.deleteDraftByName("DraftPage1");
        DraftPage initialDraftPage = this.storage.getDraft(new WikiPageParams("portal", "wiki1", "page1"));
        JPADataStorageTest.assertNotNull((Object)initialDraftPage);
        this.storage.deleteDraftByName("DraftPage2");
        initialDraftPage = this.storage.getDraft(new WikiPageParams("portal", "wiki1", "page1"));
        JPADataStorageTest.assertNull((Object)initialDraftPage);
    }

    @Test
    public void testPageVersions() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions1 = this.storage.getVersionsOfPage(createdPage);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions2 = this.storage.getVersionsOfPage(createdPage);
        JPADataStorageTest.assertNotNull((Object)pageVersions1);
        JPADataStorageTest.assertEquals((int)1, (int)pageVersions1.size());
        JPADataStorageTest.assertEquals((String)"1", (String)((PageVersion)pageVersions1.get(0)).getName());
        JPADataStorageTest.assertNotNull((Object)pageVersions2);
        JPADataStorageTest.assertEquals((int)2, (int)pageVersions2.size());
        JPADataStorageTest.assertEquals((String)"2", (String)((PageVersion)pageVersions2.get(0)).getName());
        JPADataStorageTest.assertEquals((String)"1", (String)((PageVersion)pageVersions2.get(1)).getName());
    }

    @Test
    public void testPageVersionsHistory() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions1 = this.storage.getHistoryOfPage(createdPage);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions2 = this.storage.getHistoryOfPage(createdPage);
        JPADataStorageTest.assertNotNull((Object)pageVersions1);
        JPADataStorageTest.assertEquals((int)1, (int)pageVersions1.size());
        JPADataStorageTest.assertEquals((String)"1", (String)Long.toString(((PageHistory)pageVersions1.get(0)).getVersionNumber()));
        JPADataStorageTest.assertNotNull((Object)pageVersions2);
        JPADataStorageTest.assertEquals((int)2, (int)pageVersions2.size());
        JPADataStorageTest.assertEquals((String)"1", (String)Long.toString(((PageHistory)pageVersions2.get(0)).getVersionNumber()));
        JPADataStorageTest.assertEquals((String)"2", (String)Long.toString(((PageHistory)pageVersions2.get(1)).getVersionNumber()));
    }

    @Test
    public void testRestorePageVersions() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page Version 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        this.storage.addPageVersion(createdPage, identity.getId());
        createdPage.setContent("Content Page Version 2");
        this.storage.updatePage(createdPage);
        this.storage.addPageVersion(createdPage, identity.getId());
        Page pageBeforeRestore = this.storage.getPageById(createdPage.getId());
        this.storage.restoreVersionOfPage("1", createdPage);
        Page pageAfterRestore = this.storage.getPageById(createdPage.getId());
        JPADataStorageTest.assertNotNull((Object)pageBeforeRestore);
        JPADataStorageTest.assertEquals((String)"Content Page Version 2", (String)pageBeforeRestore.getContent());
        JPADataStorageTest.assertNotNull((Object)pageAfterRestore);
        JPADataStorageTest.assertEquals((String)"Content Page Version 1", (String)pageAfterRestore.getContent());
    }

    @Test
    public void testPageNames() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setName("page1");
        page.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        this.storage.renamePage(wiki.getType(), wiki.getOwner(), createdPage.getName(), "page2", "Page 1");
        this.storage.renamePage(wiki.getType(), wiki.getOwner(), "page2", "page3", "Page 1");
        List previousNames = this.storage.getPreviousNamesOfPage(createdPage);
        JPADataStorageTest.assertNotNull((Object)previousNames);
        JPADataStorageTest.assertEquals((int)2, (int)previousNames.size());
        JPADataStorageTest.assertTrue((boolean)previousNames.contains("page1"));
        JPADataStorageTest.assertTrue((boolean)previousNames.contains("page2"));
    }

    @Test
    public void testPageMoves() throws WikiException {
        Wiki wiki1 = new Wiki();
        wiki1.setType("portal");
        wiki1.setOwner("wiki1");
        wiki1 = this.storage.createWiki(wiki1);
        Wiki wiki2 = new Wiki();
        wiki2.setType("portal");
        wiki2.setOwner("wiki2");
        wiki2 = this.storage.createWiki(wiki2);
        Page page1 = new Page();
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage1 = this.storage.createPage(wiki1, wiki1.getWikiHome(), page1);
        this.storage.renamePage(wiki1.getType(), wiki1.getOwner(), createdPage1.getName(), "page2", "Page 1");
        this.storage.movePage(new WikiPageParams(wiki1.getType(), wiki1.getOwner(), "page2"), new WikiPageParams(wiki2.getType(), wiki2.getOwner(), wiki2.getWikiHome().getName()));
        Page relatedPage1 = this.storage.getRelatedPage(wiki1.getType(), wiki1.getOwner(), "page1");
        Page relatedPage2 = this.storage.getRelatedPage(wiki1.getType(), wiki1.getOwner(), "page2");
        Page relatedPage3 = this.storage.getRelatedPage(wiki1.getType(), wiki1.getOwner(), "page3");
        JPADataStorageTest.assertNotNull((Object)relatedPage1);
        JPADataStorageTest.assertEquals((String)"portal", (String)relatedPage1.getWikiType());
        JPADataStorageTest.assertEquals((String)"wiki2", (String)relatedPage1.getWikiOwner());
        JPADataStorageTest.assertEquals((String)"page2", (String)relatedPage1.getName());
        JPADataStorageTest.assertNotNull((Object)relatedPage2);
        JPADataStorageTest.assertEquals((String)"portal", (String)relatedPage2.getWikiType());
        JPADataStorageTest.assertEquals((String)"wiki2", (String)relatedPage2.getWikiOwner());
        JPADataStorageTest.assertEquals((String)"page2", (String)relatedPage2.getName());
        JPADataStorageTest.assertNull((Object)relatedPage3);
    }

    @Test
    public void testGetWatchers() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        List initialWatchers = this.storage.getWatchersOfPage(page1);
        this.storage.addWatcherToPage("user1", page1);
        List step1Watchers = this.storage.getWatchersOfPage(page1);
        this.storage.addWatcherToPage("user2", page1);
        List step2Watchers = this.storage.getWatchersOfPage(page1);
        this.storage.deleteWatcherOfPage("user1", page1);
        List step3Watchers = this.storage.getWatchersOfPage(page1);
        JPADataStorageTest.assertNotNull((Object)initialWatchers);
        JPADataStorageTest.assertEquals((int)0, (int)initialWatchers.size());
        JPADataStorageTest.assertNotNull((Object)step1Watchers);
        JPADataStorageTest.assertEquals((int)1, (int)step1Watchers.size());
        JPADataStorageTest.assertTrue((boolean)step1Watchers.contains("user1"));
        JPADataStorageTest.assertNotNull((Object)step2Watchers);
        JPADataStorageTest.assertEquals((int)2, (int)step2Watchers.size());
        JPADataStorageTest.assertTrue((boolean)step2Watchers.contains("user1"));
        JPADataStorageTest.assertTrue((boolean)step2Watchers.contains("user2"));
        JPADataStorageTest.assertEquals((int)1, (int)step3Watchers.size());
        JPADataStorageTest.assertTrue((boolean)step3Watchers.contains("user2"));
    }

    public void testDeleteOrphanDraftPagesByParentPage() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("root");
        wiki = this.storage.createWiki(wiki);
        PageEntity homePage = (PageEntity)this.pageDAO.find((Serializable)Long.valueOf(wiki.getWikiHome().getId()));
        DraftPageEntity draft = new DraftPageEntity();
        draft.setParentPage(homePage);
        draft.setName("orphanDraft");
        draft.setTargetPage(null);
        draft.setCreatedDate(new Date());
        draft.setUpdatedDate(new Date());
        draft = (DraftPageEntity)this.draftPageDAO.create((Object)draft);
        JPADataStorageTest.assertNotNull((Object)draft);
        this.storage.deleteOrphanDraftPagesByParentPage(Long.parseLong(wiki.getWikiHome().getId()));
        AbstractCoreTest.persist();
        JPADataStorageTest.assertNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(draft.getId())));
    }

    @Override
    protected void startSessionAs(String user) {
        this.startSessionAs(user, new HashSet<MembershipEntry>());
    }

    protected void startSessionAs(String user, Collection<MembershipEntry> memberships) {
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }
}

