/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.nps.entity.ScoreEntryEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreEntryDAO
extends GenericDAOJPAImpl<ScoreEntryEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ScoreEntryDAO.class);

    public List<ScoreEntryEntity> getScoreEntries(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderBy", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.findAll();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getScoreEntriesCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getPromotersCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countPromoters", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getDetractorsCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countDetractors", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getScoreEntriesByUserId(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findByUserId", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findByUserId", ScoreEntryEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getScoreEntrybyId(long id) {
        try {
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findById", ScoreEntryEntity.class).setParameter("id", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }
}

