/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.services;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class Utils {
    private static Log log = ExoLogger.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar getFirstLoginDate(String userId) throws Exception {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", repositoryService.getCurrentRepository());
            String path = "exo:LoginHistoryHome/" + userId;
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(path)) {
                Node att = rootNode.getNode(path);
                Calendar calendar = att.getProperty("exo:dateCreated").getDate();
                return calendar;
            }
            Calendar calendar = null;
            return calendar;
        }
        return null;
    }

    public static int getDiffinDays(Calendar startCal, Calendar stopCal) throws Exception {
        long startMillis = startCal.getTimeInMillis();
        DateTime startDateTime = new DateTime(startMillis);
        long stopMillis = stopCal.getTimeInMillis();
        DateTime stopDateTime = new DateTime(stopMillis);
        LocalDate start = startDateTime.toLocalDate();
        LocalDate stop = stopDateTime.toLocalDate();
        return Days.daysBetween((ReadablePartial)start, (ReadablePartial)stop).getDays();
    }
}

