/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsForm;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import juzu.Action;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.SessionScoped;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.JSON;
import juzu.impl.request.Request;
import juzu.plugin.jackson.Jackson;
import juzu.request.RequestContext;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

@SessionScoped
public class NPSFormController {
    private static Log log = ExoLogger.getLogger(NPSFormController.class);
    ResourceBundle bundle;
    @Inject
    NpsService npsService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    @Inject
    @Path(value="edit.gtmpl")
    Template editTmpl;
    private String bundleString;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
    private static String RESP_COOKIES_EXP = "exo.nps.addon.respondedCookiesExpiration";
    private static String RESP_COOKIES_EXP_DEFAULT_VALUE = "30";
    private static String REPORTED_COOKIES_EXP_DEFAULT_VALUE = "10";
    private static String REPORTED_COOKIES_EXP = "exo.nps.addon.reportedCookiesExpiration";

    @View
    public Response.Content index(RequestContext requestContext) {
        PortletMode mode = (PortletMode)requestContext.getProperty(JuzuPortlet.PORTLET_MODE);
        if (PortletMode.EDIT.equals((Object)mode)) {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String respondedCookiesExpiration = prefs.getValue(RESP_COOKIES_EXP, RESP_COOKIES_EXP_DEFAULT_VALUE);
            String reportedCookiesExpiration = prefs.getValue(REPORTED_COOKIES_EXP, REPORTED_COOKIES_EXP_DEFAULT_VALUE);
            if (respondedCookiesExpiration == null || respondedCookiesExpiration.equals("")) {
                respondedCookiesExpiration = RESP_COOKIES_EXP_DEFAULT_VALUE;
            }
            if (reportedCookiesExpiration == null || reportedCookiesExpiration.equals("")) {
                reportedCookiesExpiration = REPORTED_COOKIES_EXP_DEFAULT_VALUE;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("respondedCookiesExpiration", respondedCookiesExpiration);
            parameters.put("reportedCookiesExpiration", reportedCookiesExpiration);
            return this.editTmpl.with(parameters).ok();
        }
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveScore(@Jackson ScoreEntryDTO obj) {
        obj.setEnabled(Boolean.valueOf(true));
        obj.setUserId(this.currentUser);
        this.npsService.save(obj, true);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getContext() {
        try {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String respondedCookiesExpiration = prefs.getValue(RESP_COOKIES_EXP, RESP_COOKIES_EXP_DEFAULT_VALUE);
            String reportedCookiesExpiration = prefs.getValue(REPORTED_COOKIES_EXP, REPORTED_COOKIES_EXP_DEFAULT_VALUE);
            if (respondedCookiesExpiration == null || respondedCookiesExpiration.equals("")) {
                respondedCookiesExpiration = RESP_COOKIES_EXP_DEFAULT_VALUE;
            }
            if (reportedCookiesExpiration == null || reportedCookiesExpiration.equals("")) {
                reportedCookiesExpiration = REPORTED_COOKIES_EXP_DEFAULT_VALUE;
            }
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            data.set("currentUser", (Object)this.currentUser);
            data.set("fullName", (Object)profile.getFullName());
            data.set("respondedCookiesExpiration", (Object)respondedCookiesExpiration);
            data.set("reportedCookiesExpiration", (Object)reportedCookiesExpiration);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            log.error((Object)"error while getting bundele", e);
            return Response.status((int)500);
        }
    }

    @Action
    @Route(value="updateSettings")
    public Response.Content updateSettings(String respondedCookiesExpiration, String reportedCookiesExpiration) throws Exception {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        prefs.setValue(RESP_COOKIES_EXP, respondedCookiesExpiration);
        prefs.setValue(REPORTED_COOKIES_EXP, reportedCookiesExpiration);
        prefs.store();
        return this.indexTmpl.ok();
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

