/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsForm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import juzu.Action;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.SessionScoped;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.JSON;
import juzu.impl.request.Request;
import juzu.plugin.jackson.Jackson;
import juzu.request.RequestContext;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

@SessionScoped
public class NPSFormController {
    private static Log log = ExoLogger.getLogger(NPSFormController.class);
    ResourceBundle bundle;
    @Inject
    NpsService npsService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    @Inject
    @Path(value="edit.gtmpl")
    Template editTmpl;
    private String bundleString;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
    private static String RESP_COOKIES_EXP = "exo.nps.addon.respondedCookiesExpiration";
    private static String RESP_COOKIES_EXP_DEFAULT_VALUE = "30";
    private static String REPORTED_COOKIES_EXP_DEFAULT_VALUE = "10";
    private static String REPORTED_COOKIES_EXP = "exo.nps.addon.reportedCookiesExpiration";
    private String mktToken;
    private String mktLead;

    @View
    public Response.Content index(RequestContext requestContext) {
        PortletMode mode = (PortletMode)requestContext.getProperty(JuzuPortlet.PORTLET_MODE);
        if (PortletMode.EDIT.equals((Object)mode)) {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String respondedCookiesExpiration = prefs.getValue(RESP_COOKIES_EXP, RESP_COOKIES_EXP_DEFAULT_VALUE);
            String reportedCookiesExpiration = prefs.getValue(REPORTED_COOKIES_EXP, REPORTED_COOKIES_EXP_DEFAULT_VALUE);
            if (respondedCookiesExpiration == null || respondedCookiesExpiration.equals("")) {
                respondedCookiesExpiration = RESP_COOKIES_EXP_DEFAULT_VALUE;
            }
            if (reportedCookiesExpiration == null || reportedCookiesExpiration.equals("")) {
                reportedCookiesExpiration = REPORTED_COOKIES_EXP_DEFAULT_VALUE;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("respondedCookiesExpiration", respondedCookiesExpiration);
            parameters.put("reportedCookiesExpiration", reportedCookiesExpiration);
            return this.editTmpl.with(parameters).ok();
        }
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveScore(@Jackson ScoreEntryDTO obj) {
        obj.setEnabled(Boolean.valueOf(true));
        obj.setUserId(this.currentUser);
        this.npsService.save(obj, true);
        String result = null;
        try {
            URL url = new URL("https://577-PCT-880.mktorest.com/rest/v1/leads.json?access_token=" + this.mktToken);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            try {
                JSONArray inputArray = new JSONArray();
                JSONObject inputObject = new JSONObject();
                inputObject.put("id", (Object)this.mktLead);
                inputObject.put("NPS_Note__c", obj.getScore());
                inputArray.put((Object)inputObject);
                JSONObject requestBody = new JSONObject();
                requestBody.put("action", (Object)"updateOnly");
                requestBody.put("lookupField", (Object)"id");
                requestBody.put("input", (Object)inputArray);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(requestBody.toString());
                wr.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                InputStream inStream = conn.getInputStream();
                result = this.convertStreamToString(inStream);
            } else {
                result = "Status Code: " + responseCode;
            }
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getToken() {
        String[] token = new String[5];
        String output = null;
        try {
            URL url = new URL("https://577-pct-880.mktorest.com/identity/oauth/token?client_id=d6668084-2fb7-46c9-ac39-179674816bb2&client_secret=rouGwDNRYCypqM56NhSYuetjhs0KAJ4m&grant_type=client_credentials");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                token = output.split("\"");
            }
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return token[3];
    }

    public String getMktLead(String cookie) {
        String output = null;
        String[] leadID = new String[5];
        try {
            URL url = new URL("https://577-pct-880.mktorest.com/rest/v1/leads.json?access_token=" + this.mktToken + "&filterType=cookie&filterValues=" + cookie + "&fields=id,email");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((output = br.readLine()) != null) {
                leadID = output.split("\"");
            }
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return leadID[8].substring(1, leadID[8].length() - 1);
    }

    private String convertStreamToString(InputStream inputStream) {
        try {
            return new Scanner(inputStream).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getContext(String mktCookie) {
        try {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String respondedCookiesExpiration = prefs.getValue(RESP_COOKIES_EXP, RESP_COOKIES_EXP_DEFAULT_VALUE);
            String reportedCookiesExpiration = prefs.getValue(REPORTED_COOKIES_EXP, REPORTED_COOKIES_EXP_DEFAULT_VALUE);
            if (respondedCookiesExpiration == null || respondedCookiesExpiration.equals("")) {
                respondedCookiesExpiration = RESP_COOKIES_EXP_DEFAULT_VALUE;
            }
            if (reportedCookiesExpiration == null || reportedCookiesExpiration.equals("")) {
                reportedCookiesExpiration = REPORTED_COOKIES_EXP_DEFAULT_VALUE;
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            data.set("currentUser", (Object)this.currentUser);
            data.set("fullName", (Object)profile.getFullName());
            data.set("respondedCookiesExpiration", (Object)respondedCookiesExpiration);
            data.set("reportedCookiesExpiration", (Object)reportedCookiesExpiration);
            data.set("firstLogDiff", (Object)Utils.getDiffinDays((Calendar)Utils.getFirstLoginDate((String)this.currentUser), (Calendar)Calendar.getInstance()));
            this.bundleString = data.toString();
            this.mktToken = this.getToken();
            this.mktLead = this.getMktLead(mktCookie);
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            log.error((Object)"error while getting bundele", e);
            return Response.status((int)500);
        }
    }

    @Action
    @Route(value="updateSettings")
    public Response.Content updateSettings(String respondedCookiesExpiration, String reportedCookiesExpiration) throws Exception {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        prefs.setValue(RESP_COOKIES_EXP, respondedCookiesExpiration);
        prefs.setValue(REPORTED_COOKIES_EXP, reportedCookiesExpiration);
        prefs.store();
        return this.indexTmpl.ok();
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

