/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsCharts;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import juzu.Action;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.JSON;
import juzu.impl.request.Request;
import juzu.plugin.jackson.Jackson;
import juzu.request.RequestContext;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.nps.dto.NPSDetailsDTO;
import org.exoplatform.nps.dto.ScoreTypeDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.NpsTypeService;
import org.exoplatform.nps.services.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class NPSChartsController {
    private static Log LOG = ExoLogger.getLogger(NPSChartsController.class);
    private String bundleString;
    ResourceBundle bundle;
    private static String SCORE_TYPE = "exo.nps.addon.selectedType";
    @Inject
    NpsService npsService;
    @Inject
    NpsTypeService npsTypeService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    @Inject
    @Path(value="edit.gtmpl")
    Template editTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index(RequestContext requestContext) {
        PortletMode mode = (PortletMode)requestContext.getProperty(JuzuPortlet.PORTLET_MODE);
        if (PortletMode.EDIT.equals((Object)mode)) {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String selectedType = prefs.getValue(SCORE_TYPE, "");
            List scoreTypes = this.npsTypeService.getScoreTypes(0, 0);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("scoreTypes", scoreTypes);
            parameters.put("selectedType", selectedType);
            return this.editTmpl.with(parameters).ok();
        }
        return this.indexTmpl.ok();
    }

    @Action
    @Route(value="updateSettings")
    public Response.Content updateSettings(String respondedCookiesExpiration, String reportedCookiesExpiration, String typeId, String firstDisplayDelay, String displayPopup) throws Exception {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        prefs.setValue(SCORE_TYPE, typeId);
        prefs.store();
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData() {
        try {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String scoreTypeId = prefs.getValue(SCORE_TYPE, "");
            JSON data = new JSON();
            ScoreTypeDTO sType = this.npsTypeService.getScoreType(Long.parseLong(scoreTypeId));
            long typeId = sType.getId();
            data.set("typeId", (Object)typeId);
            long scorsnbr = this.npsService.getScoreCount(typeId, true);
            long detractorsNbr = this.npsService.getDetractorsCount(typeId);
            long promotersNbr = this.npsService.getPromotersCount(typeId);
            long passivesNbr = scorsnbr - (promotersNbr + detractorsNbr);
            float detractorsPrc = (float)detractorsNbr / (float)scorsnbr * 100.0f;
            float promotersPrc = (float)promotersNbr / (float)scorsnbr * 100.0f;
            float passivesPrc = (float)passivesNbr / (float)scorsnbr * 100.0f;
            float npScore = promotersPrc - detractorsPrc;
            data.set("scorsnbr", (Object)this.npsService.getScoreCount(typeId, false));
            data.set("detractorsNbr", (Object)detractorsNbr);
            data.set("promotersNbr", (Object)promotersNbr);
            data.set("passivesNbr", (Object)passivesNbr);
            data.set("detractorsPrc", (Object)String.format("%.2f", Float.valueOf(detractorsPrc)));
            data.set("promotersPrc", (Object)String.format("%.2f", Float.valueOf(promotersPrc)));
            data.set("passivesPrc", (Object)String.format("%.2f", Float.valueOf(passivesPrc)));
            data.set("npScore", (Object)String.format("%.2f", Float.valueOf(npScore)));
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSLineChart(Long typeId, String chartType) {
        if (chartType.equals("global")) {
            return this.getWeeklyNPS(typeId);
        }
        if (chartType.equals("weeklyOver")) {
            return this.getNPSByWeek(typeId);
        }
        if (chartType.equals("monthlyOver")) {
            return this.getNPSByMonth(typeId);
        }
        if (chartType.equals("rolling30")) {
            return this.getRollingAvg(typeId, 30);
        }
        if (chartType.equals("rolling7")) {
            return this.getRollingAvg(typeId, 7);
        }
        return Response.notFound();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getWeeklyNPS(Long typeId) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getWeeklyNPS((long)typeId);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(nps.getNpsToDate());
                nps_.put("npsDetails", (Object)(String.format("%.2f", Float.valueOf(nps.getNpScore())) + " ( Week: " + c.get(3) + "-" + c.get(1) + " Detractors: " + nps.getDetractorsNbr() + ", Passives: " + nps.getPassivesNb() + ", Promoters: " + nps.getPromotersNbr() + ")"));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSByWeek(Long typeId) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getNPSByWeek((long)typeId);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSByMonth(Long typeId) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getNPSByMonth((long)typeId);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getRollingAvg(Long typeId, int period) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getRollingAvg((long)typeId, (int)period);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

