/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsView;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import juzu.Action;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.SessionScoped;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.JSON;
import juzu.impl.request.Request;
import juzu.plugin.jackson.Jackson;
import juzu.request.RequestContext;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.nps.dto.ScoreTypeDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.NpsTypeService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@SessionScoped
public class NPSViewController {
    private static Log log = ExoLogger.getLogger(NPSViewController.class);
    ResourceBundle bundle;
    @Inject
    NpsService npsService;
    @Inject
    NpsTypeService npsTypeService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    @Inject
    @Path(value="edit.gtmpl")
    Template editTmpl;
    private String bundleString;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
    private static String SCORE_TYPE = "exo.nps.addon.selectedType";

    @View
    public Response.Content index(RequestContext requestContext) {
        PortletMode mode = (PortletMode)requestContext.getProperty(JuzuPortlet.PORTLET_MODE);
        if (PortletMode.EDIT.equals((Object)mode)) {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String selectedType = prefs.getValue(SCORE_TYPE, "");
            List scoreTypes = this.npsTypeService.getScoreTypes(0, 0);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("scoreTypes", scoreTypes);
            parameters.put("selectedType", selectedType);
            return this.editTmpl.with(parameters).ok();
        }
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            log.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData() {
        try {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String scoreTypeId = prefs.getValue(SCORE_TYPE, "");
            JSON data = new JSON();
            try {
                ScoreTypeDTO sType = this.npsTypeService.getScoreType(Long.parseLong(scoreTypeId));
                long typeId = sType.getId();
                long firstScoreDate = this.npsService.getFirstScoreEntries(typeId).getPostedTime();
                long today = new Date().getTime();
                long scorsnbr = this.npsService.getScoreCount(typeId, true, firstScoreDate, today);
                long detractorsNbr = this.npsService.getDetractorsCount(typeId, true, firstScoreDate, today);
                long promotersNbr = this.npsService.getPromotersCount(typeId, true, firstScoreDate, today);
                long passivesNbr = scorsnbr - (promotersNbr + detractorsNbr);
                float detractorsPrc = (float)detractorsNbr / (float)scorsnbr * 100.0f;
                float promotersPrc = (float)promotersNbr / (float)scorsnbr * 100.0f;
                float passivesPrc = (float)passivesNbr / (float)scorsnbr * 100.0f;
                float npScore = promotersPrc - detractorsPrc;
                float dashoffset = 300.0f - 3.0f * npScore;
                data.set("scorsnbr", (Object)this.npsService.getScoreCount(typeId, false, firstScoreDate, today));
                data.set("detractorsNbr", (Object)detractorsNbr);
                data.set("promotersNbr", (Object)promotersNbr);
                data.set("passivesNbr", (Object)passivesNbr);
                data.set("detractorsPrc", (Object)String.format("%.2f", Float.valueOf(detractorsPrc)));
                data.set("promotersPrc", (Object)String.format("%.2f", Float.valueOf(promotersPrc)));
                data.set("passivesPrc", (Object)String.format("%.2f", Float.valueOf(passivesPrc)));
                data.set("npScore", (Object)String.format("%.2f", Float.valueOf(npScore)));
                data.set("dashoffset", (Object)String.format("%.2f", Float.valueOf(dashoffset)));
                data.set("scoreTypeName", (Object)sType.getTypeName());
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Cannot get the NPS type");
                data.set("npScore", (Object)0);
            }
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            log.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Action
    @Route(value="updateSettings")
    public Response.Content updateSettings(String typeId) throws Exception {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        prefs.setValue(SCORE_TYPE, typeId);
        prefs.store();
        return this.indexTmpl.ok();
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

