/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.util.Arrays;
import org.exoplatform.officeonline.AbstractOfficeOnlineService;
import org.exoplatform.officeonline.AccessToken;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.Permissions;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.IdentityRegistry;

public class EditorService
extends AbstractOfficeOnlineService {
    protected static final Log LOG = ExoLogger.getLogger(EditorService.class);

    public EditorService(SessionProviderService sessionProviders, RepositoryService jcrService, OrganizationService organization, DocumentService documentService, CacheService cacheService, UserACL userACL, IdentityRegistry identityRegistry, Authenticator authenticator, NodeFinder nodeFinder) {
        super(sessionProviders, jcrService, organization, documentService, cacheService, userACL, identityRegistry, authenticator, nodeFinder);
    }

    public String createToken(String userId, String fileId) throws OfficeOnlineException {
        EditorConfig.Builder configBuilder = new EditorConfig.Builder().userId(userId).fileId(fileId).workspace("collaboration").permissions(Arrays.asList(Permissions.USER_CAN_WRITE, Permissions.USER_CAN_RENAME));
        return this.generateAccessToken(configBuilder).getToken();
    }

    public void start() {
        LOG.info((Object)"Editor Service started");
        EditorConfig.Builder configBuilder = new EditorConfig.Builder().userId("peter").fileId("6514eb3d7f00010146ee6a373b04aa64").workspace("collaboration").permissions(Arrays.asList(Permissions.USER_CAN_WRITE, Permissions.USER_CAN_RENAME));
        try {
            AccessToken accessToken = this.generateAccessToken(configBuilder);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Access token #1: " + accessToken.getToken()));
            }
            EditorConfig.Builder configBuilder2 = new EditorConfig.Builder().userId("peter").fileId("463c327d7f0001012d305152520ad938").workspace("collaboration").permissions(Arrays.asList(Permissions.USER_CAN_WRITE));
            AccessToken accessToken2 = this.generateAccessToken(configBuilder2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Access token #2: " + accessToken2.getToken()));
            }
            EditorConfig decrypted1 = this.buildEditorConfig(accessToken.getToken());
            EditorConfig decrypted2 = this.buildEditorConfig(accessToken2.getToken());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DECRYPTED 1: " + decrypted1.getWorkspace() + " " + decrypted1.getUserId() + " " + decrypted1.getFileId() + " " + decrypted1.getAccessToken().getExpires()));
                decrypted1.getPermissions().forEach(arg_0 -> ((Log)LOG).debug(arg_0));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DECRYPTED 2: " + decrypted2.getWorkspace() + " " + decrypted2.getUserId() + " " + decrypted2.getFileId() + " " + decrypted1.getAccessToken().getExpires()));
            }
            decrypted2.getPermissions().forEach(arg_0 -> ((Log)LOG).debug(arg_0));
        }
        catch (OfficeOnlineException e) {
            LOG.error((Object)e);
        }
    }

    public void stop() {
    }
}

