/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.officeonline.ProofKeyHelper;
import org.exoplatform.officeonline.WOPIDiscovery;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WOPIDiscoveryPlugin
extends BaseComponentPlugin {
    protected static final Log LOG = ExoLogger.getLogger(WOPIDiscoveryPlugin.class);
    protected static final String DISCOVERY_URL = "discovery-url";
    protected static final String PLACEHOLDER_IS_LICENSED_USER = "IsLicensedUser";
    protected static final String PLACEHOLDER_IS_LICENSED_USER_VALUE = "1";
    protected static final String CACHE_NAME = "officeonline.discovery.Cache".intern();
    protected final List<String> supportedAppNames = Arrays.asList("Word", "Excel", "PowerPoint", "WopiTest");
    protected PublicKey proofKey;
    protected PublicKey oldProofKey;
    protected String discoveryUrl;
    protected ExoCache<String, Map<String, String>> extensionActionURLs;
    protected ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(1);

    public WOPIDiscoveryPlugin(CacheService cacheService, InitParams params) {
        String val;
        ValueParam discoveryURLParam = params.getValueParam(DISCOVERY_URL);
        String string = val = discoveryURLParam != null ? discoveryURLParam.getValue() : null;
        if (val == null || (val = val.trim()).isEmpty()) {
            throw new RuntimeException("discovery-url parameter is required.");
        }
        this.discoveryUrl = val;
        this.extensionActionURLs = cacheService.getCacheInstance(CACHE_NAME);
    }

    public String getActionUrl(String extension, String action) {
        Map map;
        if (this.extensionActionURLs.getCacheSize() == 0) {
            this.loadDiscovery();
        }
        if ((map = (Map)this.extensionActionURLs.get((Serializable)((Object)extension))) != null && !map.isEmpty()) {
            return (String)map.get(action);
        }
        LOG.warn("Cannot find action url for {} extension and {} action", new Object[]{extension, action});
        return null;
    }

    public PublicKey getProofKey() {
        return this.proofKey;
    }

    public PublicKey getOldProofKey() {
        return this.oldProofKey;
    }

    public void start() {
        this.loadDiscovery();
        this.refreshExecutor.scheduleAtFixedRate(() -> this.loadDiscovery(), 12L, 12L, TimeUnit.HOURS);
    }

    public void stop() {
        this.refreshExecutor.shutdown();
    }

    protected void loadDiscovery() {
        WOPIDiscovery discovery;
        byte[] discoveryBytes = this.fetchDiscovery();
        try {
            discovery = WOPIDiscovery.read(discoveryBytes);
        }
        catch (IOException e) {
            LOG.error("Error while reading WOPI discovery {}", new Object[]{e.getMessage()});
            return;
        }
        WOPIDiscovery.NetZone netZone = discovery.getNetZone();
        if (netZone == null) {
            LOG.error((Object)"Invalid WOPI discovery, no net-zone element");
            return;
        }
        this.registerApps(netZone.getApps());
        WOPIDiscovery.ProofKey pk = discovery.getProofKey();
        this.proofKey = ProofKeyHelper.getPublicKey(pk.getModulus(), pk.getExponent());
        this.oldProofKey = ProofKeyHelper.getPublicKey(pk.getOldModulus(), pk.getOldExponent());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully loaded WOPI discovery: WOPI enabled");
            LOG.debug("Registered proof key: {}", new Object[]{this.proofKey});
            LOG.debug("Registered old proof key: {}", new Object[]{this.oldProofKey});
        }
    }

    /*
     * Exception decompiling
     */
    protected byte[] fetchDiscovery() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void registerApps(List<WOPIDiscovery.App> apps) {
        HashMap<String, Map> actionURLs = new HashMap<String, Map>();
        apps.stream().filter(app -> this.supportedAppNames.contains(app.getName())).forEach(app -> app.getActions().forEach(action -> actionURLs.computeIfAbsent(action.getExt(), k -> new HashMap()).put(action.getName(), String.format("%s%s=%s", action.getUrl().replaceFirst("<.*$", ""), PLACEHOLDER_IS_LICENSED_USER, PLACEHOLDER_IS_LICENSED_USER_VALUE))));
        this.extensionActionURLs.clearCache();
        actionURLs.forEach((key, value) -> {
            if (key != null) {
                this.extensionActionURLs.put((Serializable)((Object)key), value);
            }
        });
    }
}

