/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline.cometd;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.annotation.Service;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.OfficeOnlineListener;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdOfficeOnlineService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CometdOfficeOnlineService.class);
    public static final String CHANNEL_NAME = "/eXo/Application/OfficeOnline/editor/";
    public static final String CHANNEL_NAME_PARAMS = "/eXo/Application/OfficeOnline/editor/{fileId}";
    public static final String DOCUMENT_SAVED_EVENT = "DOCUMENT_SAVED";
    protected final WOPIService wopiService;
    protected final EXoContinuationBayeux exoBayeux;
    protected final CometdService service;

    public CometdOfficeOnlineService(EXoContinuationBayeux exoBayeux, WOPIService wopiService) {
        this.exoBayeux = exoBayeux;
        this.wopiService = wopiService;
        this.service = new CometdService();
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdOfficeOnlineService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdOfficeOnlineService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdOfficeOnlineService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        if (PropertyManager.isDevelopping()) {
            this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

                public void sessionRemoved(ServerSession session, boolean timedout) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdOfficeOnlineService.this.channelsAsString(session.getSubscriptions())));
                    }
                }

                public void sessionAdded(ServerSession session, ServerMessage message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdOfficeOnlineService.this.channelsAsString(session.getSubscriptions())));
                    }
                }
            });
        }
    }

    protected String channelsAsString(Set<ServerChannel> channels) {
        return channels.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    @Service(value="officeonline")
    public class CometdService {
        @Inject
        private BayeuxServer bayeux;
        @org.cometd.annotation.Session
        private LocalSession localSession;
        @org.cometd.annotation.Session
        private ServerSession serverSession;

        @PostConstruct
        public void postConstruct() {
            CometdOfficeOnlineService.this.wopiService.addListener(new OfficeOnlineListener(){

                @Override
                public void onSaved(EditorConfig config) {
                    CometdService.this.publishSavedEvent(config.getFileId(), config.getUserId());
                }
            });
        }

        protected void publishSavedEvent(String fileId, String userId) {
            ServerChannel channel = this.bayeux.getChannel(CometdOfficeOnlineService.CHANNEL_NAME + fileId);
            if (channel != null) {
                StringBuilder data = new StringBuilder();
                data.append('{');
                data.append("\"type\": \"");
                data.append(CometdOfficeOnlineService.DOCUMENT_SAVED_EVENT);
                data.append("\", ");
                data.append("\"fileId\": \"");
                data.append(fileId);
                data.append("\", ");
                data.append("\"userId\": \"");
                data.append(userId);
                data.append("\"");
                data.append('}');
                channel.publish((Session)this.localSession, (Object)data.toString());
            }
        }
    }
}

