/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.services.cms.documents.DocumentUpdateActivityHandler;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.ext.component.activity.listener.FileUpdateActivityListener;

public class OfficeOnlineDocumentUpdateActivityHandler
extends FileUpdateActivityListener
implements DocumentUpdateActivityHandler {
    protected final WOPIService wopiService;
    protected static final Log LOG = ExoLogger.getLogger(OfficeOnlineDocumentUpdateActivityHandler.class);

    public OfficeOnlineDocumentUpdateActivityHandler(WOPIService wopiService) {
        this.wopiService = wopiService;
    }

    public boolean handleDocumentUpdateEvent(Event<Context, String> event) throws Exception {
        Node frozen;
        Context context = (Context)event.getSource();
        Property currentProperty = (Property)context.get((Object)InvocationContext.CURRENT_ITEM);
        Node node = currentProperty.getParent().getParent();
        boolean isVersionable = node.isNodeType("mix:versionable");
        Node node2 = frozen = isVersionable ? this.wopiService.getFrozen(node) : node;
        if (this.wopiService.isEditorVersion(frozen).booleanValue()) {
            Calendar versionDate = frozen.getProperty("exo:lastModifiedDate").getDate();
            String modifier = node.getProperty("exo:lastModifier").getString();
            long timeout = System.currentTimeMillis() - versionDate.getTimeInMillis();
            String versioningUser = this.wopiService.getVersioningUser(frozen);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[Comments] Frozen modifier: {}, versioning user: {}", new Object[]{modifier, versioningUser});
            }
            if (!modifier.equals(versioningUser) || timeout >= 600000L) {
                super.onEvent(event);
            }
            return true;
        }
        return false;
    }
}

