/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.EditorService;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.web.filter.Filter;

public class TokenAuthenticationFilter
extends AbstractFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(TokenAuthenticationFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletContext context = request.getServletContext();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = this.getContainer();
        SessionProviderService sessionProviders = (SessionProviderService)this.getContainer().getComponentInstanceOfType(SessionProviderService.class);
        try {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            EditorConfig config = this.buildConfig(httpRequest);
            if (config != null) {
                ConversationState state = this.createState(config.getUserId());
                ConversationState.setCurrent((ConversationState)state);
                SessionProvider userProvider = new SessionProvider(state);
                sessionProviders.setSessionProvider(null, userProvider);
                context.setAttribute("editorConfig", (Object)config);
            } else {
                context.setAttribute("wrong_token", (Object)true);
            }
            chain.doFilter(request, response);
        }
        finally {
            context.removeAttribute("editorConfig");
            context.removeAttribute("wrong_token");
            try {
                ConversationState.setCurrent(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private ConversationState createState(String userId) {
        Identity userIdentity = this.userIdentity(userId);
        if (userIdentity != null) {
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            return state;
        }
        LOG.warn((Object)("User identity not found " + userId + " for setting conversation state"));
        return null;
    }

    private EditorConfig buildConfig(HttpServletRequest httpRequest) {
        EditorService editorService = (EditorService)this.getContainer().getComponentInstanceOfType(EditorService.class);
        String token = httpRequest.getParameter("access_token");
        if (token != null) {
            try {
                return editorService.buildEditorConfig(token);
            }
            catch (OfficeOnlineException e) {
                LOG.warn("Cannot build editor config from access token {}", new Object[]{e.getMessage()});
                return null;
            }
        }
        LOG.warn((Object)"Cannot build editor config from access token. Access token is empty");
        return null;
    }

    protected Identity userIdentity(String userId) {
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
        Identity userIdentity = identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                userIdentity = authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
            }
        }
        return userIdentity;
    }

    public void destroy() {
    }
}

