/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.officeonline.AbstractOfficeOnlineService;
import org.exoplatform.officeonline.DocumentTypePlugin;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.FileLock;
import org.exoplatform.officeonline.OfficeOnlineListener;
import org.exoplatform.officeonline.Permissions;
import org.exoplatform.officeonline.ProofKeyHelper;
import org.exoplatform.officeonline.RequestInfo;
import org.exoplatform.officeonline.WOPIAvailabilityCheckerPlugin;
import org.exoplatform.officeonline.WOPIDiscoveryPlugin;
import org.exoplatform.officeonline.WOPILockManagerPlugin;
import org.exoplatform.officeonline.exception.ActionNotFoundException;
import org.exoplatform.officeonline.exception.EditorLinkNotFoundException;
import org.exoplatform.officeonline.exception.FileExtensionNotFoundException;
import org.exoplatform.officeonline.exception.FileLockedException;
import org.exoplatform.officeonline.exception.FileNotFoundException;
import org.exoplatform.officeonline.exception.IllegalFileNameException;
import org.exoplatform.officeonline.exception.InvalidFileNameException;
import org.exoplatform.officeonline.exception.LockMismatchException;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.officeonline.exception.PermissionDeniedException;
import org.exoplatform.officeonline.exception.SizeMismatchException;
import org.exoplatform.officeonline.exception.UpdateConflictException;
import org.exoplatform.officeonline.exception.WopiDiscoveryNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WOPIService
extends AbstractOfficeOnlineService {
    protected static final Log LOG = ExoLogger.getLogger(WOPIService.class);
    protected static final String MSOFFICE_VERSION_OWNER = "msoffice:versionOwner";
    protected static final String JCR_FROZEN_NODE = "jcr:frozenNode";
    protected static final String NT_RESOURCE = "nt:resource";
    protected static final String NT_FILE = "nt:file";
    protected static final String MSOFFICE_IS_EDITOR_VERSION = "msoffice:isEditorVersion";
    protected static final String BASE_FILE_NAME = "BaseFileName";
    protected static final String DEFAULT_FILENAME = "Untitled";
    protected static final String OWNER_ID = "OwnerId";
    protected static final String FILES_ENDPOINT = "/wopi/files/";
    protected static final String SIZE = "Size";
    protected static final String USER_ID = "UserId";
    protected static final String VERSION = "Version";
    protected static final String BREADCRUMB_BRAND_NAME = "BreadcrumbBrandName";
    protected static final String BREADCRUMB_BRAND_URL = "BreadcrumbBrandUrl";
    protected static final String BREADCRUMB_FOLDER_NAME = "BreadcrumbFolderName";
    protected static final String BREADCRUMB_FOLDER_URL = "BreadcrumbFolderUrl";
    protected static final String CLOSE_URL = "CloseUrl";
    protected static final String DOWNLOAD_URL = "DownloadUrl";
    protected static final String FILE_URL = "FileUrl";
    protected static final String FILE_VERSION_URL = "FileVersionUrl";
    protected static final String HOST_EDIT_URL = "HostEditUrl";
    protected static final String HOST_VIEW_URL = "HostViewUrl";
    protected static final String SIGNOUT_URL = "SignoutUrl";
    protected static final String SUPPORTS_EXTENDED_LOCK_LENGTH = "SupportsExtendedLockLength";
    protected static final String SUPPORTS_GET_LOCK = "SupportsGetLock";
    protected static final String SUPPORTS_LOCKS = "SupportsLocks";
    protected static final String SUPPORTS_RENAME = "SupportsRename";
    protected static final String SUPPORTS_UPDATE = "SupportsUpdate";
    protected static final String SUPPORTS_DELETE_FILE = "SupportsDeleteFile";
    protected static final String SUPPORTS_USER_INFO = "SupportsUserInfo";
    protected static final String SUPPORTED_SHARE_URL_TYPES = "SupportedShareUrlTypes";
    protected static final String POST_MESSAGE_ORIGIN = "PostMessageOrigin";
    protected static final String FILE_VERSION_POST_MESSAGE = "FileVersionPostMessage";
    protected static final String EDIT_NOTIFICATION_POST_MESSAGE = "EditNotificationPostMessage";
    protected static final String IS_ANONYMOUS_USER = "IsAnonymousUser";
    protected static final String USER_INFO = "UserInfo";
    protected static final String LICENSE_CHECK_FOR_EDIT_IS_ENABLED = "LicenseCheckForEditIsEnabled";
    protected static final String USER_FRIENDLY_NAME = "UserFriendlyName";
    protected static final String PLACEHOLDER_WOPISRC = "&wopisrc=";
    protected static final String PLACEHOLDER_DC_LLCC = "&DC_LLCC=";
    protected static final String PLACEHOLDER_UI_LLCC = "&UI_LLCC=";
    protected static final String SHARE_URL = "ShareUrl";
    protected static final String SHARE_URL_READ_ONLY = "ReadOnly";
    protected static final String SHARE_URL_READ_WRITE = "ReadWrite";
    protected static final String TOKEN_CONFIGURATION_PROPERTIES = "token-configuration";
    protected static final String BREADCRUMB_CONFIGURATION_PROPERTIES = "breadcrumb-configuration";
    protected static final String WOPI_CONFIGURATION_PROPERTIES = "wopi-configuration";
    protected static final String VERSION_ACCUMULATION_PROPERTIES = "version-accumulation-configuration";
    protected static final String VERSION_ACCUMULATION = "version-accumulation";
    protected static final String WOPI_URL = "wopi-url";
    protected static final String BRAND_NAME = "brand-name";
    protected static final int MAX_FILENAME_LENGHT = 510;
    public static final String USERINFO_CACHE_NAME = "officeonline.userinfo.Cache".intern();
    public static final String EDIT_ACTION = "edit";
    public static final String EDITNEW_ACTION = "editnew";
    public static final String VIEW_ACTION = "view";
    protected static final String VIEW_PARAM = "&action=view";
    protected static final String EDIT_PARAM = "&action=edit";
    protected static final String EDITNEW_PARAM = "&action=editnew";
    protected static final long VERSION_TIMEOUT = 600000L;
    protected final String usersPath;
    protected final TrashService trashService;
    protected WOPIDiscoveryPlugin discoveryPlugin;
    protected WOPIAvailabilityCheckerPlugin wopiAvailabilityChecker;
    protected WOPILockManagerPlugin lockManager;
    protected String brandName;
    protected String wopiUrl;
    protected boolean versionAccumulation;
    protected String platformScheme;
    protected String platformHost;
    protected int platformPort;
    protected ExoCache<String, String> userInfoCache;
    protected DocumentTypePlugin documentTypePlugin;
    protected final ConcurrentLinkedQueue<OfficeOnlineListener> listeners = new ConcurrentLinkedQueue();

    public WOPIService(SessionProviderService sessionProviders, RepositoryService jcrService, OrganizationService organization, DocumentService documentService, CacheService cacheService, UserACL userACL, TrashService trashService, IdentityRegistry identityRegistry, NodeHierarchyCreator hierarchyCreator, Authenticator authenticator, NodeFinder nodeFinder, InitParams initParams) {
        super(sessionProviders, jcrService, organization, documentService, cacheService, userACL, identityRegistry, authenticator, nodeFinder);
        this.trashService = trashService;
        PropertiesParam tokenParam = initParams.getPropertiesParam(TOKEN_CONFIGURATION_PROPERTIES);
        String secretKey = tokenParam.getProperty("secret-key");
        if (secretKey != null && !secretKey.trim().isEmpty()) {
            byte[] decodedKey = Base64.getDecoder().decode(secretKey);
            SecretKeySpec key = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
            this.keyCache.put((Serializable)((Object)"secret-key"), (Object)key);
        } else {
            this.keyCache.put((Serializable)((Object)"secret-key"), (Object)this.generateSecretKey());
        }
        this.userInfoCache = cacheService.getCacheInstance(USERINFO_CACHE_NAME);
        PropertiesParam breadcrumbParam = initParams.getPropertiesParam(BREADCRUMB_CONFIGURATION_PROPERTIES);
        this.brandName = breadcrumbParam.getProperty(BRAND_NAME);
        PropertiesParam wopiFilesUrlParam = initParams.getPropertiesParam(WOPI_CONFIGURATION_PROPERTIES);
        this.wopiUrl = wopiFilesUrlParam.getProperty(WOPI_URL);
        PropertiesParam versionAccumulationParam = initParams.getPropertiesParam(VERSION_ACCUMULATION_PROPERTIES);
        this.versionAccumulation = Boolean.valueOf(versionAccumulationParam.getProperty(VERSION_ACCUMULATION));
        this.usersPath = hierarchyCreator.getJcrPath("usersPath");
    }

    public void putFile(EditorConfig config, String lockId, InputStream data) throws Exception {
        block19: {
            Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
            try {
                if (this.canEdit(node) && config.permissions.contains((Object)Permissions.USER_CAN_WRITE)) {
                    Node content = node.getNode("jcr:content");
                    if (!node.isLocked()) {
                        long size = content.getProperty("jcr:data").getLength();
                        if (size != 0L) {
                            throw new SizeMismatchException("File is unlocked and size isn't equal to 0.", "");
                        }
                    } else {
                        this.checkNodeLock(node, lockId);
                    }
                    boolean versionable = node.isNodeType("mix:versionable");
                    Node frozen = versionable ? this.getFrozen(node) : node;
                    Boolean isEditorVersion = this.isEditorVersion(frozen);
                    Calendar lastModified = node.getProperty("exo:lastModifiedDate").getDate();
                    Calendar versionDate = frozen.getProperty("exo:lastModifiedDate").getDate();
                    if (versionDate.getTimeInMillis() <= lastModified.getTimeInMillis() && !isEditorVersion.booleanValue()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Creating version from draft");
                        }
                        this.createVersionOfDraft(node);
                    }
                    Calendar editedTime = Calendar.getInstance();
                    content.setProperty("jcr:lastModified", editedTime);
                    if (content.hasProperty("exo:dateModified")) {
                        content.setProperty("exo:dateModified", editedTime);
                    }
                    if (content.hasProperty("exo:lastModifiedDate")) {
                        content.setProperty("exo:lastModifiedDate", editedTime);
                    }
                    if (node.hasProperty("exo:lastModifiedDate")) {
                        node.setProperty("exo:lastModifiedDate", editedTime);
                    }
                    if (node.hasProperty("exo:dateModified")) {
                        node.setProperty("exo:dateModified", editedTime);
                    }
                    if (node.hasProperty("exo:lastModifier")) {
                        node.setProperty("exo:lastModifier", config.getUserId());
                    }
                    content.setProperty("jcr:data", data);
                    node.save();
                    String versioningUser = this.getVersioningUser(frozen);
                    long timeout = System.currentTimeMillis() - versionDate.getTimeInMillis();
                    if (this.versionAccumulation && versionable && config.getUserId().equals(versioningUser) && timeout < 600000L) {
                        String versionName = node.getBaseVersion().getName();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Version accumulation: removig version " + versionName + " from node " + node.getUUID()));
                        }
                        node.getVersionHistory().removeVersion(versionName);
                    }
                    node.setProperty(MSOFFICE_VERSION_OWNER, config.getUserId());
                    node.setProperty(MSOFFICE_IS_EDITOR_VERSION, true);
                    node.save();
                    if (this.checkout(node)) {
                        node.checkin();
                        node.checkout();
                    }
                    this.onSaved(config);
                    node.setProperty(MSOFFICE_VERSION_OWNER, "");
                    node.setProperty(MSOFFICE_IS_EDITOR_VERSION, false);
                    node.save();
                    if (data != null) {
                        try {
                            data.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Error closing data stream. FileID:" + config.getFileId()));
                        }
                    }
                    break block19;
                }
                throw new PermissionDeniedException("Cannnot update file. Permission denied");
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot save document content.", (Throwable)e);
                throw new OfficeOnlineException("Cannot perform putFile operation. FileId: " + config.getFileId() + ", workspace: " + config.getWorkspace());
            }
        }
    }

    protected String getVersioningUser(Node frozen) throws RepositoryException {
        if (frozen.hasProperty(MSOFFICE_VERSION_OWNER)) {
            return frozen.getProperty(MSOFFICE_VERSION_OWNER).getString();
        }
        return null;
    }

    protected Node getFrozen(Node node) throws RepositoryException {
        if (node.getBaseVersion().hasNode(JCR_FROZEN_NODE)) {
            return node.getBaseVersion().getNode(JCR_FROZEN_NODE);
        }
        return node;
    }

    protected Boolean isEditorVersion(Node frozen) throws RepositoryException {
        if (frozen.hasProperty(MSOFFICE_IS_EDITOR_VERSION)) {
            return frozen.getProperty(MSOFFICE_IS_EDITOR_VERSION).getBoolean();
        }
        return false;
    }

    protected void createVersionOfDraft(Node node) throws RepositoryException, OfficeOnlineException {
        ConversationState contextState = ConversationState.getCurrent();
        SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
        String userId = node.getProperty("exo:lastModifier").getString();
        if (this.setUserConvoState(userId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating a version from draft. Path: " + node.getPath() + " user: " + userId));
            }
            try {
                node.save();
                if (this.checkout(node)) {
                    node.checkin();
                    node.checkout();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Couldnl't create a version from draft for user: " + userId));
            }
        } else {
            throw new OfficeOnlineException("Cannot set conversation state " + userId);
        }
        this.restoreConvoState(contextState, contextProvider);
    }

    protected boolean checkout(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return true;
        }
        return false;
    }

    public Map<String, Serializable> checkFileInfo(EditorConfig config) throws RepositoryException, FileNotFoundException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        this.addRequiredProperties(map, node);
        this.addHostCapabilitiesProperties(map);
        this.addUserMetadataProperties(map);
        this.addUserPermissionsProperties(map, node);
        this.addFileURLProperties(map, node, config);
        this.addBreadcrumbProperties(map, node, config);
        return map;
    }

    public boolean verifyProofKey(String proofKeyHeader, String oldProofKeyHeader, String contextPath, String accessToken, String timestampHeader) {
        if (StringUtils.isBlank((String)proofKeyHeader)) {
            return true;
        }
        long timestamp = Long.parseLong(timestampHeader);
        if (!ProofKeyHelper.verifyTimestamp(timestamp)) {
            return false;
        }
        String url = this.wopiUrl + contextPath;
        byte[] expectedProofBytes = ProofKeyHelper.getExpectedProofBytes(url, accessToken, timestamp);
        boolean res = ProofKeyHelper.verifyProofKey(this.discoveryPlugin.getProofKey(), proofKeyHeader, expectedProofBytes);
        boolean successWithOldKey = false;
        if (!res && StringUtils.isNotBlank((String)oldProofKeyHeader) && !(res = ProofKeyHelper.verifyProofKey(this.discoveryPlugin.getProofKey(), oldProofKeyHeader, expectedProofBytes))) {
            successWithOldKey = res = ProofKeyHelper.verifyProofKey(this.discoveryPlugin.getOldProofKey(), proofKeyHeader, expectedProofBytes);
        }
        if (!res || successWithOldKey) {
            this.discoveryPlugin.loadDiscovery();
        }
        return res;
    }

    public void setWOPIDiscoveryPlugin(ComponentPlugin plugin) {
        Class<WOPIDiscoveryPlugin> pclass = WOPIDiscoveryPlugin.class;
        if (!pclass.isAssignableFrom(plugin.getClass())) {
            throw new WopiDiscoveryNotFoundException("WopiDiscoveryPlugin is not an instance of " + pclass.getName());
        }
        this.discoveryPlugin = (WOPIDiscoveryPlugin)((Object)pclass.cast(plugin));
        LOG.info((Object)("Set WopiDiscoveryPlugin instance of " + plugin.getClass().getName()));
    }

    public void setWOPIAvailabilityCheckerPlugin(ComponentPlugin plugin) {
        Class<WOPIAvailabilityCheckerPlugin> pclass = WOPIAvailabilityCheckerPlugin.class;
        if (!pclass.isAssignableFrom(plugin.getClass())) {
            throw new IllegalArgumentException("WOPIAvailabilityCheckerPlugin is not an instance of " + pclass.getName());
        }
        this.wopiAvailabilityChecker = (WOPIAvailabilityCheckerPlugin)((Object)pclass.cast(plugin));
        LOG.info((Object)("Set WOPIAvailabilityCheckerPlugin instance of " + plugin.getClass().getName()));
    }

    public void setWOPILockManagerPlugin(ComponentPlugin plugin) {
        Class<WOPILockManagerPlugin> pclass = WOPILockManagerPlugin.class;
        if (!pclass.isAssignableFrom(plugin.getClass())) {
            throw new WopiDiscoveryNotFoundException("WOPILockManagerPlugin is not an instance of " + pclass.getName());
        }
        this.lockManager = (WOPILockManagerPlugin)((Object)pclass.cast(plugin));
        LOG.info((Object)("Set WOPILockManagerPlugin instance of " + plugin.getClass().getName()));
    }

    public String getActionUrl(RequestInfo requestInfo, String fileId, String workspace, String action) throws RepositoryException, OfficeOnlineException {
        String actionURL;
        Node node = this.nodeByUUID(fileId, workspace);
        String extension = this.getFileExtension(node);
        if (extension.equals("wopitest")) {
            action = VIEW_ACTION;
        }
        if ((actionURL = this.discoveryPlugin.getActionUrl(extension, action)) != null) {
            return actionURL + PLACEHOLDER_WOPISRC + this.getWOPISrc(requestInfo, fileId) + PLACEHOLDER_DC_LLCC + requestInfo.getLocale().toString() + PLACEHOLDER_UI_LLCC + requestInfo.getLocale().toString();
        }
        throw new ActionNotFoundException("Cannot find actionURL for file extension " + extension + " and action: " + action);
    }

    public boolean isNewDocument(Node node) throws RepositoryException {
        Node content = node.getNode("jcr:content");
        return content.getProperty("jcr:data").getLength() == 0L;
    }

    public String renameFile(EditorConfig config, String newTitle, String lockId) throws RepositoryException, OfficeOnlineException, LockMismatchException {
        if (StringUtils.isBlank((String)(newTitle = Text.escapeIllegalJcrChars((String)newTitle)))) {
            throw new InvalidFileNameException("Requested title is not allowed due to using illegal JCR chars");
        }
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        if (this.trashService.isInTrash(node)) {
            throw new FileNotFoundException("File has been deleted. FileId: " + config.getFileId() + ", workspace: " + config.getWorkspace());
        }
        if (!this.canUpdate(node) || !config.getPermissions().contains((Object)Permissions.USER_CAN_RENAME)) {
            throw new PermissionDeniedException("Cannot rename document. Permission denied");
        }
        this.checkNodeLock(node, lockId);
        Node parentNode = node.getParent();
        if (parentNode.canAddMixin("mix:referenceable")) {
            parentNode.addMixin("mix:referenceable");
            parentNode.save();
        }
        String extension = null;
        try {
            extension = this.getFileExtension(node);
        }
        catch (FileExtensionNotFoundException e) {
            LOG.warn((Object)"Cannot get file extension.", (Throwable)e);
        }
        String name = newTitle;
        if (extension != null) {
            name = newTitle + "." + extension;
        }
        parentNode.getSession().move(node.getPath(), parentNode.getPath() + "/" + name);
        node.setProperty("exo:lastModifier", config.getUserId());
        node.setProperty("exo:name", name);
        node.setProperty("exo:title", name);
        node.refresh(true);
        parentNode.getSession().save();
        try {
            LockUtil.keepLock((Lock)node.getLock());
        }
        catch (Exception e) {
            LOG.warn("Cannot keep lock for renamed node {}. {}", new Object[]{node.getPath(), e.getMessage()});
        }
        return newTitle;
    }

    protected boolean canUpdate(Node node) throws RepositoryException {
        NodeImpl parent;
        try {
            parent = (NodeImpl)node.getParent();
        }
        catch (AccessDeniedException e) {
            LOG.warn("Cannot get access to the parent node {}", new Object[]{e.getMessage()});
            return false;
        }
        return parent.hasPermission("read") && parent.hasPermission("add_node") && parent.hasPermission("set_property");
    }

    protected String getFileExtension(Node node) throws RepositoryException, FileExtensionNotFoundException {
        String title = node.getProperty("exo:title").getString();
        if (title.contains(".")) {
            return title.substring(title.lastIndexOf(".") + 1);
        }
        String mimeType = node.isNodeType(NT_FILE) ? node.getNode("jcr:content").getProperty("jcr:mimeType").getString() : new MimeTypeResolver().getMimeType(node.getName());
        String extension = this.documentTypePlugin.getFileExtensions().get(mimeType);
        if (extension != null) {
            return extension;
        }
        throw new FileExtensionNotFoundException("Cannot get file extension. FileId: " + node.getUUID() + ". Title: " + title);
    }

    public String getEditorLink(String fileId, String workspace, String baseUrl, String action) throws RepositoryException, FileNotFoundException, EditorLinkNotFoundException {
        Node node = this.nodeByUUID(fileId, workspace);
        return this.getEditorLink(node, baseUrl, action);
    }

    public String getEditorLink(Node node, String scheme, String host, int port, String action) throws RepositoryException, EditorLinkNotFoundException {
        String baseUrl = this.platformUrl(scheme, host, port).toString();
        return this.getEditorLink(node, baseUrl, action);
    }

    public String getEditorLink(Node node, String baseUrl, String action) throws RepositoryException, EditorLinkNotFoundException {
        String portalName;
        try {
            portalName = WCMCoreUtils.getCurrentPortalName();
        }
        catch (Exception e) {
            LOG.error("Cannot get current portal owner {}", new Object[]{e.getMessage()});
            throw new EditorLinkNotFoundException("Editor link not found - cannot get current portal owner");
        }
        if (this.wopiAvailabilityChecker != null && !this.wopiAvailabilityChecker.isWOPIAvailable()) {
            throw new EditorLinkNotFoundException("Editor link not found - WOPI is not available");
        }
        if (this.isDocumentSupported(node)) {
            StringBuilder link = new StringBuilder(baseUrl).append('/').append(portalName).append("/mseditor?fileId=").append(node.getUUID());
            if (action.equals(VIEW_ACTION)) {
                link.append(VIEW_PARAM);
            } else if (action.equals(EDIT_ACTION)) {
                link.append(EDIT_PARAM);
            } else if (action.equals(EDITNEW_ACTION)) {
                link.append(EDITNEW_PARAM);
            }
            return link.toString();
        }
        throw new EditorLinkNotFoundException("Editor link not found - document is not supported");
    }

    public boolean isDocumentSupported(Node node) throws RepositoryException {
        if (node != null) {
            if (node.getName().endsWith("wopitest") || node.getName().endsWith("wopitestx")) {
                return true;
            }
            String mimeType = node.isNodeType(NT_FILE) ? node.getNode("jcr:content").getProperty("jcr:mimeType").getString() : new MimeTypeResolver().getMimeType(node.getName());
            return this.documentTypePlugin.fileExtensions.containsKey(mimeType);
        }
        return false;
    }

    public String getWOPISrc(RequestInfo requestInfo, String fileId) {
        return this.wopiUrl + "/files/" + fileId;
    }

    public void start() {
        if (this.discoveryPlugin == null) {
            throw new WopiDiscoveryNotFoundException("WopiDiscoveryPlugin is not configured");
        }
        this.discoveryPlugin.start();
        if (this.wopiAvailabilityChecker != null) {
            this.wopiAvailabilityChecker.start();
        }
        LOG.info((Object)"WOPI Service started");
        String excelEdit = this.discoveryPlugin.getActionUrl("xlsx", EDIT_ACTION);
        String excelView = this.discoveryPlugin.getActionUrl("xlsx", VIEW_ACTION);
        String wordEdit = this.discoveryPlugin.getActionUrl("docx", EDIT_ACTION);
        String wordView = this.discoveryPlugin.getActionUrl("docx", VIEW_ACTION);
        String powerPointEdit = this.discoveryPlugin.getActionUrl("pptx", EDIT_ACTION);
        String powerPointView = this.discoveryPlugin.getActionUrl("pptx", VIEW_ACTION);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Excel edit URL: " + excelEdit));
            LOG.debug((Object)("Excel view URL: " + excelView));
            LOG.debug((Object)("Word edit URL: " + wordEdit));
            LOG.debug((Object)("Excel view URL: " + wordView));
            LOG.debug((Object)("PowerPoint edit URL: " + powerPointEdit));
            LOG.debug((Object)("PowerPoint view URL: " + powerPointView));
        }
        this.updateNodetypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodetypes() {
        InputStream is = null;
        try {
            String workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Session session = this.jcrService.getCurrentRepository().getSystemSession(workspace);
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            is = WOPIService.class.getResourceAsStream("/conf/portal/jcr/officeonline-nodetypes.xml");
            nodeTypeManager.registerNodeTypes(is, 4, "text/xml");
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot update nodetypes.", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Cannot close InputStream", (Throwable)e);
                }
            }
        }
    }

    public void stop() {
        this.discoveryPlugin.stop();
        if (this.wopiAvailabilityChecker != null) {
            this.wopiAvailabilityChecker.stop();
        }
    }

    protected void addRequiredProperties(Map<String, Serializable> map, Node node) throws RepositoryException {
        String fileName = node.getProperty("exo:title").getString();
        try {
            fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Cannot decode filename. {}", new Object[]{e.getMessage()});
        }
        map.put(BASE_FILE_NAME, (Serializable)((Object)fileName));
        map.put(OWNER_ID, (Serializable)((Object)node.getProperty("exo:owner").getString()));
        map.put(SIZE, this.getSize(node));
        map.put(USER_ID, (Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (!node.isNodeType("mix:versionable")) {
            Session systemSession = this.jcrService.getCurrentRepository().getSystemSession(node.getSession().getWorkspace().getName());
            NodeImpl systemNode = (NodeImpl)systemSession.getNodeByUUID(node.getUUID());
            systemNode.addMixin("mix:versionable");
            systemNode.save();
            map.put(VERSION, (Serializable)((Object)systemNode.getBaseVersion().getName()));
        } else {
            map.put(VERSION, (Serializable)((Object)node.getBaseVersion().getName()));
        }
    }

    protected void addHostCapabilitiesProperties(Map<String, Serializable> map) {
        map.put(SUPPORTS_EXTENDED_LOCK_LENGTH, Boolean.valueOf(true));
        map.put(SUPPORTS_GET_LOCK, Boolean.valueOf(true));
        map.put(SUPPORTS_LOCKS, Boolean.valueOf(true));
        map.put(SUPPORTS_RENAME, Boolean.valueOf(true));
        map.put(SUPPORTS_UPDATE, Boolean.valueOf(true));
        map.put(SUPPORTS_DELETE_FILE, Boolean.valueOf(true));
        map.put(SUPPORTS_USER_INFO, Boolean.valueOf(true));
    }

    protected void addUserMetadataProperties(Map<String, Serializable> map) {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        User user = this.getUser(userId);
        String displayName = user != null ? user.getDisplayName() : userId;
        map.put(IS_ANONYMOUS_USER, Boolean.valueOf(false));
        map.put(LICENSE_CHECK_FOR_EDIT_IS_ENABLED, Boolean.valueOf(true));
        map.put(USER_FRIENDLY_NAME, (Serializable)((Object)displayName));
        String userInfo = (String)this.userInfoCache.get((Serializable)((Object)userId));
        if (userInfo != null) {
            map.put(USER_INFO, (Serializable)((Object)userInfo));
        }
    }

    protected void addUserPermissionsProperties(Map<String, Serializable> map, Node node) throws RepositoryException {
        boolean canEdit = this.canEdit(node);
        boolean canUpdate = this.canUpdate(node);
        map.put(Permissions.READ_ONLY.toString(), Boolean.valueOf(!canEdit));
        map.put(Permissions.USER_CAN_RENAME.toString(), Boolean.valueOf(canUpdate));
        map.put(Permissions.USER_CAN_WRITE.toString(), Boolean.valueOf(canEdit));
        map.put(Permissions.USER_CAN_NOT_WRITE_RELATIVE.toString(), Boolean.valueOf(!canUpdate));
    }

    public boolean canEdit(Node node) {
        block4: {
            try {
                if (!node.isNodeType(NT_FILE) || !this.isDocumentSupported(node) || !PermissionUtil.canSetProperty((Node)node)) break block4;
                String actionUrl = null;
                try {
                    String extension = this.getFileExtension(node);
                    actionUrl = this.discoveryPlugin.getActionUrl(extension, EDIT_ACTION);
                }
                catch (FileExtensionNotFoundException e) {
                    LOG.error((Object)("Cannot get file extension from node: " + node.getUUID()));
                }
                return actionUrl != null;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot check file edit permissions", (Throwable)e);
            }
        }
        return false;
    }

    public boolean canView(Node node) {
        block4: {
            try {
                if (!node.isNodeType(NT_FILE) || !this.isDocumentSupported(node)) break block4;
                String actionUrl = null;
                try {
                    String extension = this.getFileExtension(node);
                    actionUrl = this.discoveryPlugin.getActionUrl(extension, VIEW_ACTION);
                }
                catch (FileExtensionNotFoundException e) {
                    LOG.error((Object)("Cannot get file extension from node: " + node.getUUID()));
                }
                return actionUrl != null;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot check file view permissions", (Throwable)e);
            }
        }
        return false;
    }

    protected void addFileURLProperties(Map<String, Serializable> map, Node node, EditorConfig config) throws RepositoryException {
        Node explorerNode;
        StringBuilder explorerUrl;
        Node symlink = null;
        if (node.getPath().startsWith(this.usersPath) && !config.getUserId().equals(this.getUserId(node.getPath()))) {
            symlink = this.getSymlink(node, config.getUserId());
        }
        if ((explorerUrl = this.getExplorerURL(explorerNode = symlink != null ? symlink : node, config.getBaseUrl())) != null) {
            map.put(CLOSE_URL, (Serializable)((Object)explorerUrl.toString()));
            map.put(FILE_VERSION_URL, (Serializable)((Object)explorerUrl.append("&versions=true").toString()));
        }
        String platformRestURL = config.getBaseUrl() + '/' + PortalContainer.getCurrentRestContextName();
        String downloadURL = platformRestURL + "/officeonline/editor/content/" + node.getUUID() + "?access_token=" + config.getAccessToken().getToken();
        map.put(DOWNLOAD_URL, (Serializable)((Object)downloadURL));
        try {
            map.put(HOST_EDIT_URL, (Serializable)((Object)this.getEditorLink(node, config.getBaseUrl(), EDIT_ACTION)));
            map.put(HOST_VIEW_URL, (Serializable)((Object)this.getEditorLink(node, config.getBaseUrl(), VIEW_ACTION)));
        }
        catch (EditorLinkNotFoundException e) {
            LOG.error((Object)"Cannot get editor link", (Throwable)e);
        }
        map.put(FILE_URL, (Serializable)((Object)downloadURL));
    }

    public StringBuilder getExplorerURL(Node node, String baseUrl) throws RepositoryException {
        URI uri = this.explorerUri(baseUrl, this.explorerLink(node.getPath()));
        return uri != null ? new StringBuilder(uri.toString()) : null;
    }

    protected void addBreadcrumbProperties(Map<String, Serializable> map, Node node, EditorConfig config) {
        map.put(BREADCRUMB_BRAND_NAME, (Serializable)((Object)this.brandName));
        map.put(BREADCRUMB_BRAND_URL, (Serializable)((Object)config.getBaseUrl()));
        map.put(POST_MESSAGE_ORIGIN, (Serializable)((Object)config.getBaseUrl()));
        map.put(FILE_VERSION_POST_MESSAGE, Boolean.valueOf(true));
        map.put(EDIT_NOTIFICATION_POST_MESSAGE, Boolean.valueOf(true));
        try {
            Node symlink;
            Node parent = null;
            if (node.getPath().startsWith(this.usersPath) && !config.getUserId().equals(this.getUserId(node.getPath())) && (symlink = this.getSymlink(node, config.getUserId())) != null) {
                parent = symlink.getParent();
            }
            if (parent == null) {
                parent = node.getParent();
            }
            if (parent.hasProperty("exo:title")) {
                map.put(BREADCRUMB_FOLDER_NAME, (Serializable)((Object)parent.getProperty("exo:title").getString()));
            } else if (parent.hasProperty("exo:name")) {
                map.put(BREADCRUMB_FOLDER_NAME, (Serializable)((Object)parent.getProperty("exo:name").getString()));
            }
            String url = this.explorerUri(config.getBaseUrl(), this.explorerLink(parent.getPath())).toString();
            map.put(BREADCRUMB_FOLDER_URL, (Serializable)((Object)url));
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Couldn't add breadcrump properties:", (Throwable)e);
        }
    }

    protected Key generateSecretKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            SecretKey key = keyGen.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Cannot generate secret key {}", new Object[]{e.getMessage()});
            return null;
        }
    }

    public void lock(EditorConfig config, String lockId) throws LockMismatchException, RepositoryException, FileNotFoundException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        this.lockManager.lock(node, lockId);
        node.save();
    }

    public String getLockId(EditorConfig config) throws FileNotFoundException, RepositoryException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        FileLock lock = this.lockManager.getLock(node);
        return lock != null ? lock.getLockId() : null;
    }

    public void relock(EditorConfig config, String providedLock, String oldLock) throws LockMismatchException, RepositoryException, FileNotFoundException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        this.lockManager.unlock(node, oldLock, config.getWorkspace());
        this.lockManager.lock(node, providedLock);
    }

    public void unlock(EditorConfig config, String providedLock) throws LockMismatchException, RepositoryException, FileNotFoundException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        this.lockManager.unlock(node, providedLock, config.getWorkspace());
    }

    public void refreshLock(EditorConfig config, String lockId) throws LockMismatchException, RepositoryException, FileNotFoundException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        this.lockManager.refreshLock(node, lockId);
    }

    public String putSuggestedFile(EditorConfig config, String target, InputStream data) throws RepositoryException, FileNotFoundException, FileExtensionNotFoundException, PermissionDeniedException {
        if (config.getPermissions().contains((Object)Permissions.USER_CAN_NOT_WRITE_RELATIVE)) {
            throw new PermissionDeniedException("User " + config.getUserId() + " cannot write relative");
        }
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        String oldName = node.getName();
        String filename = target;
        if (target.startsWith(".")) {
            String name = oldName.substring(0, oldName.lastIndexOf("."));
            filename = name + target;
        }
        if (StringUtils.isBlank((String)(filename = Text.escapeIllegalJcrChars((String)filename)))) {
            filename = DEFAULT_FILENAME + oldName.substring(oldName.lastIndexOf("."));
        }
        if (filename.length() > 510) {
            String extension = filename.substring(filename.lastIndexOf("."));
            int length = filename.length() - 510 + extension.length();
            filename = filename.substring(0, length) + extension;
        }
        Node parent = node.getParent();
        return this.createFile(parent, filename, data);
    }

    public String putRelativeFile(EditorConfig config, String filename, boolean overwrite, InputStream data) throws IllegalFileNameException, FileNotFoundException, RepositoryException, FileLockedException, UpdateConflictException, FileExtensionNotFoundException, PermissionDeniedException {
        if (config.getPermissions().contains((Object)Permissions.USER_CAN_NOT_WRITE_RELATIVE)) {
            throw new PermissionDeniedException("User " + config.getUserId() + " cannot write relative");
        }
        if (StringUtils.isBlank((String)(filename = Text.escapeIllegalJcrChars((String)filename))) || filename.length() > 510) {
            throw new IllegalFileNameException("Provided filename is illegal", filename);
        }
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        Node parent = node.getParent();
        String path = parent.getPath() + "/" + filename;
        Session userSession = node.getSession();
        if (userSession.itemExists(path)) {
            if (!overwrite) {
                throw new UpdateConflictException("Overwrite is not allowed", null, filename);
            }
            Node targetNode = (Node)userSession.getItem(path);
            if (targetNode.isLocked()) {
                FileLock lock = this.lockManager.getLock(targetNode);
                throw new FileLockedException("File is locked", lock != null ? lock.getLockId() : null, filename);
            }
            long editedTime = System.currentTimeMillis();
            Node content = targetNode.getNode("jcr:content");
            content.setProperty("jcr:lastModified", editedTime);
            if (content.hasProperty("exo:dateModified")) {
                content.setProperty("exo:dateModified", editedTime);
            }
            if (content.hasProperty("exo:lastModifiedDate")) {
                content.setProperty("exo:lastModifiedDate", editedTime);
            }
            if (targetNode.hasProperty("exo:lastModifiedDate")) {
                targetNode.setProperty("exo:lastModifiedDate", editedTime);
            }
            if (targetNode.hasProperty("exo:dateModified")) {
                targetNode.setProperty("exo:dateModified", editedTime);
            }
            if (targetNode.hasProperty("exo:lastModifier")) {
                targetNode.setProperty("exo:lastModifier", config.getUserId());
            }
            content.setProperty("jcr:data", data);
            parent.save();
            try {
                data.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot close data input stream", (Throwable)e);
            }
            return targetNode.getUUID();
        }
        return this.createFile(parent, filename, data);
    }

    protected String createFile(Node parent, String filename, InputStream data) throws RepositoryException, FileExtensionNotFoundException {
        String nodeName = filename;
        boolean fileCreated = false;
        Node addedNode = null;
        int count = 0;
        do {
            try {
                addedNode = parent.addNode(nodeName, NT_FILE);
                fileCreated = true;
            }
            catch (ItemExistsException e) {
                nodeName = this.increaseName(filename, ++count);
            }
        } while (!fileCreated);
        if (!addedNode.hasProperty("exo:title")) {
            addedNode.addMixin("exo:rss-enable");
        }
        if (addedNode.canAddMixin("mix:versionable")) {
            addedNode.addMixin("mix:versionable");
        }
        if (addedNode.hasProperty("exo:name")) {
            addedNode.setProperty("exo:name", filename);
        }
        addedNode.setProperty("exo:title", filename);
        Node content = addedNode.addNode("jcr:content", NT_RESOURCE);
        content.setProperty("jcr:data", data);
        String extension = filename.substring(filename.lastIndexOf(".") + 1);
        content.setProperty("jcr:mimeType", this.getMimeTypeByExtension(extension));
        content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
        try {
            listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)addedNode);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast FILE_CREATED_ACTIVITY event", (Throwable)e);
        }
        parent.save();
        try {
            data.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot close data input stream", (Throwable)e);
        }
        return addedNode.getUUID();
    }

    public String getMimeTypeByExtension(String extension) throws FileExtensionNotFoundException {
        for (Map.Entry<String, String> entry : this.documentTypePlugin.getFileExtensions().entrySet()) {
            if (!entry.getValue().equals(extension)) continue;
            return entry.getKey();
        }
        if (extension.equals("wopitest") || extension.equals("wopitestx")) {
            return "application/octet-stream";
        }
        throw new FileExtensionNotFoundException("Cannot find file extension " + extension);
    }

    public String getFileVersion(String fileId, String workspace) throws FileNotFoundException, RepositoryException {
        Node node = this.nodeByUUID(fileId, workspace);
        if (node.isNodeType("mix:versionable")) {
            return node.getBaseVersion().getName();
        }
        return null;
    }

    public String getFileName(String fileId, String workspace) throws FileNotFoundException, RepositoryException {
        Node node = this.nodeByUUID(fileId, workspace);
        return node.getName();
    }

    public void delete(EditorConfig config, String lockId) throws RepositoryException, OfficeOnlineException, LockMismatchException {
        Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
        this.checkNodeLock(node, lockId);
        try {
            if (!this.trashService.isInTrash(node)) {
                this.trashService.moveToTrash(node, this.sessionProviders.getSessionProvider(null));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot move node to trash.", (Throwable)e);
            throw new OfficeOnlineException("Failed to delete file with fileId: " + config.getFileId());
        }
    }

    protected void checkNodeLock(Node node, String lockId) throws LockMismatchException, RepositoryException {
        if (node.isLocked()) {
            String currentLock;
            FileLock lock = this.lockManager.getLock(node);
            String string = currentLock = lock != null ? lock.getLockId() : "";
            if (!lockId.equals(currentLock)) {
                throw new LockMismatchException("Given lock is different from the file lock", currentLock);
            }
            node.getSession().addLockToken(lock.getLockToken());
        }
    }

    public void putUserInfo(String userId, String userInfo) {
        this.userInfoCache.put((Serializable)((Object)userId), (Object)userInfo);
    }

    public void addTypePlugin(ComponentPlugin plugin) {
        Class<DocumentTypePlugin> pclass = DocumentTypePlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            DocumentTypePlugin newPlugin = (DocumentTypePlugin)((Object)pclass.cast(plugin));
            if (this.documentTypePlugin != null) {
                LOG.info("Replace existing DocumentTypePlugin {} with new one {}", new Object[]{this.documentTypePlugin.getFileExtensions().keySet().stream().collect(Collectors.joining(",")), newPlugin.getFileExtensions().keySet().stream().collect(Collectors.joining(","))});
            } else {
                LOG.info("Use DocumentTypePlugin {}", new Object[]{newPlugin.getFileExtensions().keySet().stream().collect(Collectors.joining(","))});
            }
            this.documentTypePlugin = newPlugin;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set documentTypePlugin instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The documentTypePlugin plugin is not an instance of " + pclass.getName()));
        }
    }

    public boolean isVersionAccumulationEnabled() {
        return this.versionAccumulation;
    }

    public void setVersionAccumulation(boolean versionAccumulation) {
        this.versionAccumulation = versionAccumulation;
    }

    protected String getUserId(String path) {
        List<String> elems = Arrays.asList(path.split("/"));
        int position = 2;
        while (elems.get(position).endsWith("_")) {
            ++position;
        }
        return elems.get(position);
    }

    protected String increaseName(String origin, int count) {
        int index = origin.indexOf(46);
        if (index == -1) {
            return origin + count;
        }
        return origin.substring(0, index) + count + origin.substring(index);
    }

    public void addListener(OfficeOnlineListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OfficeOnlineListener listener) {
        this.listeners.remove(listener);
    }

    public void onSaved(EditorConfig config) {
        for (OfficeOnlineListener l : this.listeners) {
            try {
                l.onSaved(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Saving listener error", t);
            }
        }
    }

    public static class DocumentTypesConfig {
        protected Map<String, String> fileExtensions;

        public Map<String, String> getFileExtensions() {
            return this.fileExtensions;
        }

        public void setFileExtensions(Map<String, String> fileExtensions) {
            this.fileExtensions = fileExtensions;
        }
    }
}

