/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class OnlyofficeClientContext {
    protected static final String JAVASCRIPT = "OnlyofficeClientContext_Javascript".intern();
    protected static final String CLIENT_RESOURCE_PREFIX = "OnlyofficeEditorClient.";
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeClientContext.class);
    private final RequireJS require;

    private OnlyofficeClientContext(WebuiRequestContext requestContext) {
        String messagesJson;
        JavascriptManager js = requestContext.getJavascriptManager();
        this.require = js.require("SHARED/onlyoffice", "onlyoffice");
        try {
            ResourceBundleService i18nService = (ResourceBundleService)requestContext.getApplication().getApplicationServiceContainer().getComponentInstanceOfType(ResourceBundleService.class);
            ResourceBundle res = i18nService.getResourceBundle("locale.onlyoffice.OnlyofficeClient", requestContext.getLocale());
            HashMap<String, String> resMap = new HashMap<String, String>();
            Enumeration<String> keys = res.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String bundleKey = key.startsWith(CLIENT_RESOURCE_PREFIX) ? key.substring(CLIENT_RESOURCE_PREFIX.length()) : key;
                resMap.put(bundleKey, res.getString(key));
            }
            messagesJson = new JsonGeneratorImpl().createJsonObjectFromMap(resMap).toString();
        }
        catch (JsonException e) {
            LOG.warn((Object)"Cannot serialize messages bundle JSON", (Throwable)e);
            messagesJson = "{}";
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot build messages bundle", (Throwable)e);
            messagesJson = "{}";
        }
        this.callOnModule("initMessages(" + messagesJson + ");");
    }

    private RequireJS appRequireJS() {
        return this.require;
    }

    private void callOnModule(String code) {
        this.require.addScripts("onlyoffice." + code + "\n");
    }

    private void showClientError(String title, String message) {
        this.callOnModule("showError('" + title + ("', '" + message + "');"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OnlyofficeClientContext context() {
        OnlyofficeClientContext context;
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj == null || !OnlyofficeClientContext.class.isAssignableFrom(obj.getClass())) {
            WebuiRequestContext webuiRequestContext = requestContext;
            synchronized (webuiRequestContext) {
                obj = requestContext.getAttribute(JAVASCRIPT);
                if (obj == null || !OnlyofficeClientContext.class.isAssignableFrom(obj.getClass())) {
                    context = new OnlyofficeClientContext(requestContext);
                    requestContext.setAttribute(JAVASCRIPT, (Object)context);
                } else {
                    context = (OnlyofficeClientContext)OnlyofficeClientContext.class.cast(obj);
                }
            }
        } else {
            context = (OnlyofficeClientContext)OnlyofficeClientContext.class.cast(obj);
        }
        return context;
    }

    public static void callModule(String code) {
        OnlyofficeClientContext.context().callOnModule(code);
    }

    public static RequireJS requireJS() {
        return OnlyofficeClientContext.context().appRequireJS();
    }

    public static void showError(String title, String message) {
        OnlyofficeClientContext.context().showClientError(title, message);
    }
}

