/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.webui.AbstractOnlyofficeLifecycle;
import org.exoplatform.onlyoffice.webui.OnlyofficeContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class OnlyofficeDocumentsLifecycle
extends AbstractOnlyofficeLifecycle {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeDocumentsLifecycle.class);

    @Override
    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        RequestContext parentContext = context.getParentAppRequestContext();
        UIJCRExplorer explorer = (UIJCRExplorer)context.getUIApplication().findFirstComponentOfType(UIJCRExplorer.class);
        if (explorer != null && parentContext != null) {
            try {
                String userName = context.getRemoteUser();
                Node node = explorer.getCurrentNode();
                String nodeWs = node.getSession().getWorkspace().getName();
                String nodePath = node.getPath();
                if (this.isNotSameUserDocument(userName, nodeWs, nodePath, parentContext)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Init documents explorer for {}, node: {}:{}, context: {}", new Object[]{userName, nodeWs, nodePath, parentContext});
                    }
                    parentContext.setAttribute("OnlyofficeContext.userId", (Object)userName);
                    parentContext.setAttribute("OnlyofficeContext.document.workspace", (Object)nodeWs);
                    parentContext.setAttribute("OnlyofficeContext.document.path", (Object)nodePath);
                    OnlyofficeEditorService editorService = (OnlyofficeEditorService)context.getApplication().getApplicationServiceContainer().getComponentInstanceOfType(OnlyofficeEditorService.class);
                    String docId = editorService.getDocumentId(node);
                    if (docId != null && editorService.isDocumentMimeSupported(node)) {
                        OnlyofficeContext.callModule("initExplorer('" + docId + "');");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Already initialized documents explorer for {}, node: {}:{}, context: {}", new Object[]{userName, nodeWs, nodePath, parentContext});
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Couldn't read document of node", (Throwable)e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Explorer or portal context not found, explorer: {}, context: {}", new Object[]{explorer, parentContext});
        }
        super.onEndRequest(app, context);
    }

    private boolean isNotSameUserDocument(String userName, String nodeWs, String nodePath, RequestContext parentContext) {
        return !userName.equals(parentContext.getAttribute("OnlyofficeContext.userId")) || !nodeWs.equals(parentContext.getAttribute("OnlyofficeContext.document.workspace")) || !nodePath.equals(parentContext.getAttribute("OnlyofficeContext.document.path"));
    }
}

