/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.onlyoffice.webui.AbstractOnlyofficeLifecycle;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;

public class OnlyofficeEditorLifecycle
extends AbstractOnlyofficeLifecycle {
    public static final String[] EMPTY_PERMISSIONS = new String[0];
    private final Set<RenderedState> states = ConcurrentHashMap.newKeySet();

    @Override
    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        UIContainer leftnav;
        super.onStartRequest(app, context);
        UIApplication uiApp = context.getUIApplication();
        UIContainer toolbar = (UIContainer)uiApp.findComponentById("UIToolbarContainer");
        if (toolbar != null) {
            toolbar.setRendered(false);
            this.states.add(() -> toolbar.setRendered(true));
        }
        if ((leftnav = (UIContainer)uiApp.findComponentById("LeftNavigation")) != null) {
            leftnav.setRendered(false);
            if (UIPortalComponent.class.isAssignableFrom(leftnav.getClass())) {
                UIPortalComponent portalComp = (UIPortalComponent)UIPortalComponent.class.cast(leftnav);
                String[] origPermissions = portalComp.getAccessPermissions();
                portalComp.setAccessPermissions(EMPTY_PERMISSIONS);
                this.states.add(() -> {
                    leftnav.setRendered(true);
                    portalComp.setAccessPermissions(origPermissions);
                });
            } else {
                this.states.add(() -> leftnav.setRendered(true));
            }
        }
    }

    @Override
    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        this.restore();
        super.onEndRequest(app, context);
    }

    void restore() {
        Iterator<RenderedState> siter = this.states.iterator();
        while (siter.hasNext()) {
            try {
                siter.next().restore();
            }
            finally {
                siter.remove();
            }
        }
    }

    static interface RenderedState {
        public void restore();
    }
}

