/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.webui.OnlyofficeContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/plugin/space/FileUIActivity.gtmpl", events={@EventConfig(listeners={FileUIActivity.ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={FileUIActivity.OpenFileActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditCommentActionListener.class})})})
public class FileUIActivity
extends org.exoplatform.wcm.ext.component.activity.FileUIActivity {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivity.class);
    protected final OnlyofficeEditorService editorService;
    protected final Map<Node, String> editorLinks = new ConcurrentHashMap<Node, String>();

    public FileUIActivity() throws Exception {
        this.editorService = (OnlyofficeEditorService)this.getApplicationComponent(OnlyofficeEditorService.class);
    }

    public void end() throws Exception {
        Node node;
        String activityId = this.getActivity().getId();
        if (this.getFilesCount() == 1 && (node = this.getContentNode(0)) != null && (node = this.editorService.getDocument(node.getSession().getWorkspace().getName(), node.getPath())) != null) {
            OnlyofficeContext.callModule("initActivity('" + this.editorService.initDocument(node) + "', " + this.contextEditorLink(node, "stream") + ",'" + activityId + "');");
        }
        for (int index = 0; index < this.getFilesCount(); ++index) {
            Node node2 = this.getContentNode(index);
            if ((node2 = this.editorService.getDocument(node2.getSession().getWorkspace().getName(), node2.getPath())) == null) continue;
            OnlyofficeContext.callModule("initPreview('" + this.editorService.initDocument(node2) + "', " + this.contextEditorLink(node2, "preview") + ",'" + ("#Preview" + activityId + '-' + index) + "');");
        }
        super.end();
    }

    protected String getEditorLink(Node docNode) {
        try {
            return this.editorService.getEditorLink(docNode);
        }
        catch (RepositoryException | OnlyofficeEditorException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    private String contextEditorLink(Node node, String context) {
        String link = this.editorLinks.computeIfAbsent(node, n -> this.getEditorLink((Node)n));
        if (link == null || link.isEmpty()) {
            return "null".intern();
        }
        return '\'' + OnlyofficeContext.editorLink(link, context) + '\'';
    }
}

