/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.wcm.ext.component.activity.listener.FileUpdateActivityListener;

public class DocumentUpdateActivityListener
extends FileUpdateActivityListener {
    protected static final long EVENT_DELAY = 10L;
    private OnlyofficeEditorService editorService = (OnlyofficeEditorService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OnlyofficeEditorService.class);

    public void onEvent(Event<Context, String> event) throws Exception {
        String path;
        String workspace;
        Context context = (Context)event.getSource();
        Property currentProperty = (Property)context.get((Object)InvocationContext.CURRENT_ITEM);
        Node currentNode = currentProperty.getParent().getParent();
        String lastModifier = currentNode.getProperty("exo:lastModifier").getString();
        Config config = this.editorService.getEditor(lastModifier, workspace = currentNode.getSession().getWorkspace().getName(), path = currentNode.getPath());
        if (config != null && config.getSameModifier() != null && config.getPreviousModified() != null) {
            boolean sameModifier = config.getSameModifier();
            Calendar previousModified = config.getPreviousModified();
            long difference = Calendar.getInstance().getTimeInMillis() - previousModified.getTimeInMillis();
            if (!sameModifier || TimeUnit.MILLISECONDS.toMinutes(difference) > 10L) {
                super.onEvent(event);
            }
        } else {
            super.onEvent(event);
        }
    }
}

