/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.webui.FileFilter;
import org.exoplatform.onlyoffice.webui.OnlyofficeContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={OnlyofficeOpenActionListener.class})})
public class OnlyofficeOpenManageComponent
extends UIAbstractManagerComponent {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeOpenManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new FileFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        if (name.equals("OnlyofficeOpen")) {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            if (uiExplorer != null) {
                String editorLink;
                OnlyofficeEditorService editorService = (OnlyofficeEditorService)this.getApplicationComponent(OnlyofficeEditorService.class);
                Node node = uiExplorer.getCurrentNode();
                node = editorService.getDocument(node.getSession().getWorkspace().getName(), node.getPath());
                Node symlink = (Node)uiExplorer.getSession().getItem(uiExplorer.getCurrentPath());
                if (symlink.isNodeType("exo:symlink")) {
                    editorService.addFilePreferences(node, WebuiRequestContext.getCurrentInstance().getRemoteUser(), symlink.getPath());
                }
                if ((editorLink = editorService.getEditorLink(node)) != null && !editorLink.isEmpty()) {
                    return "javascript:window.open('" + OnlyofficeContext.editorLink(editorLink, "documents") + "');";
                }
            } else {
                LOG.warn((Object)("Cannot find ancestor of type UIJCRExplorer in component " + (Object)((Object)this) + ", parent: " + this.getParent()));
            }
        }
        return super.renderEventURL(ajax, name, beanId, params);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class OnlyofficeOpenActionListener
    extends UIActionBarActionListener<OnlyofficeOpenManageComponent> {
        public void processEvent(Event<OnlyofficeOpenManageComponent> event) throws Exception {
        }
    }
}

