/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui.explorer;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.documents.NewDocumentService;
import org.exoplatform.onlyoffice.webui.OnlyofficeContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/templates/UINewDocument.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UINewDocumentForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TITLE_TEXT_BOX = "titleTextBox";
    public static final String FIELD_TYPE_SELECT_BOX = "typeSelectBox";
    protected static final Log LOG = ExoLogger.getLogger((String)UINewDocumentForm.class.getName());
    protected NewDocumentService documentService = (NewDocumentService)this.getApplicationComponent(NewDocumentService.class);

    public UINewDocumentForm() {
        UIFormStringInput titleTextBox = new UIFormStringInput(FIELD_TITLE_TEXT_BOX, FIELD_TITLE_TEXT_BOX, null);
        this.addUIFormInput((UIFormInput)titleTextBox);
        ArrayList options = new ArrayList();
        this.documentService.getTypes().forEach(elem -> options.add(new SelectItemOption(elem.getLabel(), (Object)elem.getLabel())));
        UIFormSelectBox typeSelectBox = new UIFormSelectBox(FIELD_TYPE_SELECT_BOX, FIELD_TYPE_SELECT_BOX, options);
        typeSelectBox.setRendered(true);
        this.addUIFormInput((UIFormInput)typeSelectBox);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager js = requestContext.getJavascriptManager();
        js.require("SHARED/onlyoffice", "onlyoffice").addScripts("onlyoffice.initNewDocument();");
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UINewDocumentForm> {
        public void execute(Event<UINewDocumentForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UINewDocumentForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UINewDocumentForm> {
        public void execute(Event<UINewDocumentForm> event) throws Exception {
            UINewDocumentForm uiDocumentForm = (UINewDocumentForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiDocumentForm.getAncestorOfType(UIApplication.class);
            UIFormSelectBox typeSelectBox = uiDocumentForm.getUIFormSelectBox(UINewDocumentForm.FIELD_TYPE_SELECT_BOX);
            String title = (String)uiDocumentForm.getUIStringInput(UINewDocumentForm.FIELD_TITLE_TEXT_BOX).getValue();
            Node currentNode = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
                return;
            }
            if (StringUtils.isBlank((String)title)) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.name-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
                return;
            }
            title = uiDocumentForm.documentService.getFileName(title, (String)typeSelectBox.getValue());
            Node createdDocument = null;
            try {
                createdDocument = uiDocumentForm.documentService.createDocument(currentNode, title, (String)typeSelectBox.getValue());
            }
            catch (ConstraintViolationException cve) {
                Object[] arg = new Object[]{typeSelectBox.getValue()};
                throw new MessageException(new ApplicationMessage("UINewDocumentForm.msg.constraint-violation", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.repository-exception-permission", null, 1));
            }
            catch (ItemExistsException re) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.not-allow-sameNameSibling", null, 1));
            }
            catch (RepositoryException re) {
                String key = "UINewDocumentForm.msg.repository-exception";
                NodeDefinition[] definitions = currentNode.getPrimaryNodeType().getChildNodeDefinitions();
                boolean isSameNameSiblingsAllowed = false;
                for (NodeDefinition def : definitions) {
                    if (!def.allowsSameNameSiblings()) continue;
                    isSameNameSiblingsAllowed = true;
                    break;
                }
                if (currentNode.hasNode(title) && !isSameNameSiblingsAllowed) {
                    key = "UINewDocumentForm.msg.not-allow-sameNameSibling";
                }
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
            }
            catch (NumberFormatException nume) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.numberformat-exception", null, 1));
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            OnlyofficeEditorService editorService = (OnlyofficeEditorService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OnlyofficeEditorService.class);
            String link = editorService.getEditorLink(createdDocument);
            link = link != null ? "'" + OnlyofficeContext.editorLink(link, "documents") + "'" : "null";
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            JavascriptManager js = requestContext.getJavascriptManager();
            js.require("SHARED/onlyoffice", "onlyoffice").addScripts("onlyoffice.initEditorPage(" + link + ");");
            uiExplorer.updateAjax(event);
        }
    }
}

