/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.exoplatform.onlyoffice.webui.AbstractOnlyofficeLifecycle;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;

public class OnlyofficeEditorLifecycle
extends AbstractOnlyofficeLifecycle {
    public static final String[] EMPTY_PERMISSIONS = new String[0];
    public static final String EDITOR_STATES_ATTR_NAME = "OnlyofficeContext.editor.states";
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorLifecycle.class);

    @Override
    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        super.onStartRequest(app, context);
        ServletRequest servletRequest = this.getServletRequest(context);
        Set states = (Set)servletRequest.getAttribute(EDITOR_STATES_ATTR_NAME);
        if (states != null) {
            if (servletRequest != null) {
                UIContainer leftnav;
                UIApplication uiApp = context.getUIApplication();
                UIContainer toolbar = (UIContainer)uiApp.findComponentById("UIToolbarContainer");
                if (toolbar != null) {
                    toolbar.setRendered(false);
                    states.add(() -> toolbar.setRendered(true));
                }
                if ((leftnav = (UIContainer)uiApp.findComponentById("LeftNavigation")) != null) {
                    leftnav.setRendered(false);
                    if (UIPortalComponent.class.isAssignableFrom(leftnav.getClass())) {
                        UIPortalComponent portalComp = (UIPortalComponent)UIPortalComponent.class.cast(leftnav);
                        String[] origPermissions = portalComp.getAccessPermissions();
                        portalComp.setAccessPermissions(EMPTY_PERMISSIONS);
                        states.add(() -> {
                            leftnav.setRendered(true);
                            portalComp.setAccessPermissions(origPermissions);
                        });
                    } else {
                        states.add(() -> leftnav.setRendered(true));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Initialized context with servlet request {}", new Object[]{servletRequest});
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot initialize context without servlet request");
            }
        }
    }

    @Override
    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        ServletRequest servletRequest = this.getServletRequest(context);
        if (servletRequest != null) {
            this.restore(servletRequest);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cannot uninitialize context without servlet request");
        }
        super.onEndRequest(app, context);
    }

    void restore(ServletRequest servletRequest) {
        Set states = (Set)servletRequest.getAttribute(EDITOR_STATES_ATTR_NAME);
        if (states != null && states.size() > 0) {
            Iterator siter = states.iterator();
            while (siter.hasNext()) {
                ((RenderedState)siter.next()).restore();
                siter.remove();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uninitialized context with servlet request {}", new Object[]{servletRequest});
            }
        }
    }

    static interface RenderedState {
        public void restore();
    }
}

