/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.ConflictException;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentNotFoundException;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.DocumentTypePlugin;
import org.exoplatform.onlyoffice.EditorLinkNotFoundException;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.Userdata;
import org.exoplatform.onlyoffice.Version;
import org.exoplatform.onlyoffice.jcr.NodeFinder;
import org.exoplatform.onlyoffice.jpa.storage.cache.CachedEditorConfigStorage;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class OnlyofficeEditorServiceImpl
implements OnlyofficeEditorService,
Startable {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorServiceImpl.class);
    private static final String UTF_8 = "utf-8";
    protected static final Random RANDOM = new Random();
    public static final String CONFIG_DS_HOST = "documentserver-host";
    public static final String CONFIG_DS_SCHEMA = "documentserver-schema";
    public static final String CONFIG_DS_ACCESS_ONLY = "documentserver-access-only";
    public static final String CONFIG_DS_SECRET = "documentserver-secret";
    public static final String CONFIG_DS_ALLOWEDHOSTS = "documentserver-allowedhosts";
    protected static final char HTTP_PORT_DELIMITER = ':';
    protected static final String HIDDEN_FOLDER = "...";
    protected static final String LAST_EDITED_DATE_FORMAT = "dd.MM.yyyy HH:mm";
    protected static final String TYPE_TEXT = "word";
    protected static final String TYPE_SPREADSHEET = "cell";
    protected static final String TYPE_PRESENTATION = "slide";
    protected static final String DEFAULT_NAME = "untitled";
    protected static final String RELATION_PROP = "exo:relation";
    protected static final Pattern FILE_EXPLORER_URL_SYNTAX = Pattern.compile("([^:/]+):(/.*)");
    protected static final int LOCK_WAIT_ATTEMTS = 20;
    protected static final long LOCK_WAIT_TIMEOUT = 250L;
    protected static final String EMPTY_TEXT = "".intern();
    public static final String CACHE_NAME = "onlyoffice.EditorCache".intern();
    public static final String VIEWER_CACHE_NAME = "onlyoffice.ViewerCache".intern();
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final IdentityRegistry identityRegistry;
    protected final NodeFinder finder;
    protected final OrganizationService organization;
    protected final Authenticator authenticator;
    protected final DocumentService documentService;
    protected final LockService lockService;
    protected final ListenerService listenerService;
    protected final TrashService trashService;
    protected final SpaceService spaceService;
    protected final ActivityManager activityManager;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final ManageDriveService manageDriveService;
    protected final CachedEditorConfigStorage cachedEditorConfigStorage;
    protected final ExoCache<String, ConcurrentMap<String, Config>> viewerCache;
    protected final ReentrantLock activeLock = new ReentrantLock();
    protected final Map<String, String> config;
    protected final String uploadUrl;
    protected final String documentserverHostName;
    protected final String documentserverUrl;
    protected final String commandServiceUrl;
    protected final String documentserverSecret;
    protected final boolean documentserverAccessOnly;
    protected final String groupsPath;
    protected final String usersPath;
    protected final Set<String> documentserverAllowedhosts;
    protected final Map<String, String> fileTypes = new ConcurrentHashMap<String, String>();
    protected final ConcurrentLinkedQueue<OnlyofficeEditorListener> listeners = new ConcurrentLinkedQueue();
    protected DocumentTypePlugin documentTypePlugin;

    public OnlyofficeEditorServiceImpl(RepositoryService jcrService, SessionProviderService sessionProviders, IdentityRegistry identityRegistry, NodeFinder finder, OrganizationService organization, Authenticator authenticator, CacheService cacheService, DocumentService documentService, LockService lockService, ListenerService listenerService, TrashService trashService, SpaceService spaceService, ActivityManager activityManager, ManageDriveService manageDriveService, NodeHierarchyCreator hierarchyCreator, CachedEditorConfigStorage cachedEditorConfigStorage, InitParams params) throws ConfigurationException {
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.identityRegistry = identityRegistry;
        this.finder = finder;
        this.organization = organization;
        this.authenticator = authenticator;
        this.documentService = documentService;
        this.lockService = lockService;
        this.listenerService = listenerService;
        this.trashService = trashService;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.cachedEditorConfigStorage = cachedEditorConfigStorage;
        this.viewerCache = cacheService.getCacheInstance(VIEWER_CACHE_NAME);
        this.hierarchyCreator = hierarchyCreator;
        this.manageDriveService = manageDriveService;
        this.initFileTypes();
        PropertiesParam param = params.getPropertiesParam("editor-configuration");
        if (param == null) {
            throw new ConfigurationException("Property parameters editor-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
        String dsSchema = this.config.get(CONFIG_DS_SCHEMA);
        String dsHost = this.config.get(CONFIG_DS_HOST);
        this.documentserverHostName = this.getDocumentserverHost(dsSchema, dsHost);
        StringBuilder documentserverUrl = new StringBuilder();
        documentserverUrl.append(dsSchema);
        documentserverUrl.append("://");
        documentserverUrl.append(dsHost);
        this.uploadUrl = new StringBuilder(documentserverUrl).append("/FileUploader.ashx").toString();
        this.documentserverUrl = new StringBuilder(documentserverUrl).append("/web-apps/").toString();
        this.commandServiceUrl = new StringBuilder(documentserverUrl).append("/coauthoring/CommandService.ashx").toString();
        this.documentserverAccessOnly = Boolean.parseBoolean(this.config.get(CONFIG_DS_ACCESS_ONLY));
        this.documentserverSecret = this.config.get(CONFIG_DS_SECRET);
        this.documentserverAllowedhosts = this.getDocumentserverAllowedHosts(this.config.get(CONFIG_DS_ALLOWEDHOSTS));
        this.usersPath = hierarchyCreator.getJcrPath("usersPath");
        this.groupsPath = hierarchyCreator.getJcrPath("groupsPath");
    }

    @Override
    public void addListener(OnlyofficeEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OnlyofficeEditorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Config getEditor(String userId, String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        Node node = this.getDocument(workspace, path);
        if (node != null && node.isNodeType("mix:referenceable")) {
            return this.getEditor(userId, node.getUUID(), false);
        }
        return null;
    }

    @Override
    public Config getEditorByKey(String userId, String key) throws OnlyofficeEditorException, RepositoryException {
        Config config;
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs != null && !configs.isEmpty() && (config = configs.get(userId)) != null) {
            this.validateUser(userId, config);
            return config;
        }
        return null;
    }

    protected Config getEditor(String userId, String docId, boolean createCoEditing) throws OnlyofficeEditorException, RepositoryException {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByDocId(docId);
        if (configs != null && !configs.isEmpty()) {
            Config config = configs.get(userId);
            DocumentStatus.Builder statusBuilder = new DocumentStatus.Builder();
            statusBuilder.users(new String[]{userId});
            if (config == null && createCoEditing) {
                try {
                    Config another = configs.values().iterator().next();
                    User user = this.getUser(userId);
                    if (user != null) {
                        config = another.forUser(user.getUserName(), user.getDisplayName(), OnlyofficeEditorServiceImpl.getUserLanguage(userId), this.documentserverSecret);
                        Config existing = configs.putIfAbsent(userId, config);
                        if (existing == null) {
                            this.cachedEditorConfigStorage.saveConfig(List.of(config.getDocument().getKey(), config.getDocId()), config, true);
                        } else {
                            config = existing;
                        }
                    } else {
                        LOG.warn((Object)("Attempt to obtain document editor (" + this.nodePath(another) + ") under not existing user " + userId));
                        throw new BadParameterException("User not found for " + another.getDocument().getTitle());
                    }
                    statusBuilder.config(config);
                    statusBuilder.url(config.getEditorUrl());
                    statusBuilder.key(config.getDocument().getKey());
                    this.fireGet(statusBuilder.build());
                }
                catch (NoSuchElementException e) {
                    config = null;
                }
            } else if (createCoEditing) {
                statusBuilder.config(config);
                statusBuilder.url(config.getEditorUrl());
                statusBuilder.key(config.getDocument().getKey());
                this.fireGet(statusBuilder.build());
            }
            return config;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config createEditor(String schema, String host, int port, String userId, String workspace, String docId) throws OnlyofficeEditorException, RepositoryException {
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        if (docId.startsWith("/")) {
            docId = this.initDocument(workspace, docId);
        }
        Node node = this.getDocumentById(workspace, docId);
        String path = node.getPath();
        if (!node.isNodeType("nt:file")) {
            throw new OnlyofficeEditorException("Document should be a nt:file node: " + this.nodePath(workspace, path));
        }
        if (!this.canEditDocument(node)) {
            throw new OnlyofficeEditorException("Cannot edit document: " + this.nodePath(workspace, path));
        }
        Config config = this.getEditor(userId, docId, true);
        if (config == null) {
            block15: {
                this.activeLock.lock();
                try {
                    Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByDocId(docId);
                    if (configs != null && !configs.isEmpty()) {
                        config = this.getEditor(userId, docId, true);
                        if (config == null) {
                            throw new ConflictException("Cannot obtain configuration for already existing editor");
                        }
                        break block15;
                    }
                    User user = this.getUser(userId);
                    String fileType = this.fileType(node);
                    String docType = this.documentType(fileType);
                    Config.Builder builder = Config.editor(this.documentserverUrl, docType, workspace, path, docId);
                    builder.owner(userId);
                    builder.fileType(fileType);
                    builder.uploaded(this.nodeCreated(node));
                    builder.displayPath(this.getDisplayPath(node, userId));
                    builder.comment(this.nodeComment(node));
                    builder.drive(this.getDrive(node));
                    builder.renameAllowed(this.canRenameDocument(node));
                    builder.isActivity(ActivityTypeUtils.getActivityId((Node)node) != null);
                    try {
                        builder.folder(node.getParent().getName());
                    }
                    catch (AccessDeniedException e) {
                        String owner;
                        try {
                            owner = node.getProperty("exo:owner").getString();
                        }
                        catch (PathNotFoundException oe) {
                            owner = "?";
                        }
                        LOG.warn((Object)("Cannot read document parent node: " + this.nodePath(workspace, node.getPath() + ". Owner: " + owner + ". Error: " + e.getMessage())));
                        builder.folder(EMPTY_TEXT);
                    }
                    builder.lang(OnlyofficeEditorServiceImpl.getUserLanguage(userId));
                    builder.mode("edit");
                    builder.title(this.nodeTitle(node));
                    builder.userId(user.getUserName());
                    builder.userName(user.getDisplayName());
                    builder.lastModifier(this.getLastModifier(node));
                    builder.lastModified(this.getLastModified(node));
                    String key = this.generateId(workspace, path).toString();
                    builder.key(key);
                    StringBuilder platformUrl = this.platformUrl(schema, host, port);
                    builder.generateUrls(new StringBuilder(platformUrl).append('/').append(PortalContainer.getCurrentRestContextName()).toString());
                    builder.editorUrl(new StringBuilder(platformUrl).append(this.editorURLPath(docId)).toString());
                    String ecmsPageLink = this.explorerLink(path);
                    builder.explorerUri(this.explorerUri(schema, host, port, ecmsPageLink));
                    builder.secret(this.documentserverSecret);
                    config = builder.build();
                    this.cachedEditorConfigStorage.saveConfig(List.of(key, docId), config, true);
                }
                finally {
                    this.activeLock.unlock();
                }
            }
            DocumentStatus status = new DocumentStatus.Builder().config(config).users(new String[]{userId}).url(config.getEditorUrl()).key(config.getDocument().getKey()).build();
            this.fireCreated(status);
        } else {
            config.getEditorPage().setDisplayPath(this.getDisplayPath(node, userId));
            config.getEditorPage().setRenameAllowed(this.canRenameDocument(node));
            config.getEditorPage().setComment(this.nodeComment(node));
            config.getEditorPage().setLastModifier(this.getLastModifier(node));
            config.getEditorPage().setLastModified(this.getLastModified(node));
            this.cachedEditorConfigStorage.saveConfig(config.getDocument().getKey(), config, false);
            this.cachedEditorConfigStorage.saveConfig(config.getDocId(), config, false);
        }
        return config;
    }

    @Override
    public Config createViewer(String schema, String host, int port, String userId, String workspace, String docId) throws OnlyofficeEditorException, RepositoryException {
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        if (docId.startsWith("/")) {
            docId = this.initDocument(workspace, docId);
        }
        Node node = this.getDocumentById(workspace, docId);
        String path = node.getPath();
        if (!WCMCoreUtils.isNodeTypeOrFrozenType((Node)node, (String)"nt:file")) {
            throw new OnlyofficeEditorException("Document should be a nt:file node or FrozenType node: " + this.nodePath(workspace, path));
        }
        User user = this.getUser(userId);
        String fileType = this.fileType(node);
        String docType = this.documentType(fileType);
        Config.Builder builder = Config.editor(this.documentserverUrl, docType, workspace, path, docId);
        builder.owner(userId);
        builder.fileType(fileType);
        builder.lang(OnlyofficeEditorServiceImpl.getUserLanguage(userId));
        builder.mode("view");
        builder.title(this.nodeTitle(node));
        builder.userId(user.getUserName());
        builder.userName(user.getDisplayName());
        String key = this.generateId(workspace, path).toString();
        builder.key(key);
        StringBuilder platformUrl = this.platformUrl(schema, host, port);
        builder.generateUrls(new StringBuilder(platformUrl).append('/').append(PortalContainer.getCurrentRestContextName()).toString());
        String ecmsPageLink = this.explorerLink(path);
        builder.explorerUri(this.explorerUri(schema, host, port, ecmsPageLink));
        builder.secret(this.documentserverSecret);
        if (!this.isSuspendDownloadDocument()) {
            builder.editorUrl(new StringBuilder(platformUrl).append(this.editorURLPath(docId)).append("&mode=").append("view").toString());
            try {
                String downloadUrl = Utils.getDownloadRestServiceLink((Node)node);
                builder.downloadUrl(new StringBuilder(platformUrl).append(downloadUrl).toString());
            }
            catch (Exception e) {
                LOG.warn("Cannot get download link for node " + docId, new Object[]{e.getMessage()});
            }
        } else {
            builder.setAllowEdition(false);
        }
        Config config = builder.build();
        ConcurrentHashMap<String, Config> configs = new ConcurrentHashMap<String, Config>();
        configs.put(userId, config);
        this.viewerCache.put((Serializable)((Object)key), configs);
        this.viewerCache.put((Serializable)((Object)docId), configs);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContent getContent(String userId, String key) throws OnlyofficeEditorException, RepositoryException {
        Map configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        boolean viewMode = false;
        if (configs == null || configs.isEmpty()) {
            configs = (Map)this.viewerCache.get((Serializable)((Object)key));
            viewMode = true;
        }
        if (configs != null && !configs.isEmpty()) {
            Config config = (Config)configs.get(userId);
            if (config != null) {
                this.validateUser(userId, config);
                ConversationState contextState = ConversationState.getCurrent();
                SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
                try {
                    if (!this.setUserConvoState(userId)) {
                        this.logError(userId, config.getPath(), config.getDocId(), config.getDocument().getKey(), "Cannot set conversation state");
                        throw new OnlyofficeEditorException("Cannot set conversation state " + userId);
                    }
                    Node node = this.nodeByUUID(config.getWorkspace(), config.getDocId());
                    if (viewMode) {
                        this.viewerCache.remove((Serializable)((Object)key));
                        if (config.getDocId() != null) {
                            this.viewerCache.remove((Serializable)((Object)config.getDocId()));
                        }
                    }
                    Node content = this.nodeContent(node);
                    final String mimeType = content.getProperty("jcr:mimeType").getString();
                    AutoCloseInputStream data = new AutoCloseInputStream(content.getProperty("jcr:data").getStream());
                    DocumentContent documentContent = new DocumentContent((InputStream)data){
                        final /* synthetic */ InputStream val$data;
                        {
                            this.val$data = inputStream;
                        }

                        @Override
                        public String getType() {
                            return mimeType;
                        }

                        @Override
                        public InputStream getData() {
                            return this.val$data;
                        }
                    };
                    return documentContent;
                }
                finally {
                    this.restoreConvoState(contextState, contextProvider);
                }
            }
            throw new BadParameterException("User editor not found or already closed " + userId);
        }
        throw new BadParameterException("File key not found " + key);
    }

    @Override
    public boolean canDownloadBy(String hostName) {
        if (this.documentserverAccessOnly) {
            return this.documentserverHostName.equalsIgnoreCase(hostName) || this.documentserverAllowedhosts.contains(this.lowerCase(hostName));
        }
        return true;
    }

    @Override
    public ChangeState getState(String userId, String key) throws OnlyofficeEditorException {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs != null && !configs.isEmpty()) {
            Config config = configs.get(userId);
            if (config != null) {
                this.validateUser(userId, config);
                String[] users = this.getActiveUsers(configs);
                return new ChangeState(false, config.getError(), users);
            }
            throw new BadParameterException("User editor not found " + userId);
        }
        return new ChangeState(true, null, new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDocument(DocumentStatus status) throws OnlyofficeEditorException, RepositoryException {
        String key = status.getKey();
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs == null || configs.isEmpty()) throw new BadParameterException("File key not found " + key);
        Config config = configs.get(status.getUserId());
        if (config == null) throw new BadParameterException("User editor not found " + status.getUserId());
        status.setConfig(config);
        this.validateUser(status.getUserId(), config);
        String nodePath = this.nodePath(config.getWorkspace(), config.getPath());
        long statusCode = status.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> Onlyoffice status " + statusCode + " for " + key + ". URL: " + status.getUrl() + ". Users: " + Arrays.toString(status.getUsers()) + " << Local file: " + nodePath));
        }
        if (statusCode == 0L) {
            this.cachedEditorConfigStorage.deleteConfig(List.of(key, config.getDocId()), config);
            LOG.warn((Object)("Received Onlyoffice status: no document with the key identifier could be found. Key: " + key + ". Document: " + nodePath));
            throw new OnlyofficeEditorException("Error editing document: document ID not found");
        }
        if (statusCode == 1L) {
            this.syncUsers(configs, status.getUsers());
            return;
        } else if (statusCode == 2L) {
            Config.Editor.User lastUser = this.getUser(key, status.getLastUser());
            Config.Editor.User lastModifier = this.getLastModifier(key);
            if (!lastModifier.getId().equals(lastUser.getId()) || lastModifier.getId().equals(lastUser.getId()) && lastUser.getLastModified() > lastUser.getLastSaved()) {
                this.downloadClosed(status);
            } else {
                config.closed();
                this.broadcastEvent(status, "exo.onlyoffice.editor.closed");
            }
            configs.values().forEach(c -> this.cachedEditorConfigStorage.deleteConfig(List.of(key, c.getDocId()), (Config)c));
            return;
        } else if (statusCode == 3L) {
            this.syncUsers(configs, status.getUsers());
            if (configs.size() <= 1) {
                String url = status.getUrl();
                if (url != null && url.length() > 0) {
                    this.downloadClosed(status);
                    this.cachedEditorConfigStorage.deleteConfig(List.of(key, config.getDocId()), config);
                    config.setError("Error in editor (" + status.getError() + "). Last change was successfully saved");
                    this.fireError(status);
                    this.broadcastEvent(status, "exo.onlyoffice.editor.error");
                    LOG.warn((Object)("Received Onlyoffice error of saving document. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Error: " + status.getError() + ". Last change was successfully saved for " + nodePath));
                    return;
                } else {
                    LOG.warn((Object)("Received Onlyoffice error of saving document without changes URL. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document: " + nodePath + ". Error: " + status.getError()));
                    config.setError("Error in editor (" + status.getError() + "). No changes saved");
                    this.cachedEditorConfigStorage.saveConfig(List.of(key, config.getDocId()), config, false);
                    this.fireError(status);
                    this.broadcastEvent(status, "exo.onlyoffice.editor.error");
                }
                return;
            } else {
                LOG.warn((Object)("Received Onlyoffice error of saving document with several editors. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document: " + nodePath));
                config.setError("Error in editor. Document still in editing state");
                this.cachedEditorConfigStorage.saveConfig(List.of(key, config.getDocId()), config, false);
                this.fireError(status);
                this.broadcastEvent(status, "exo.onlyoffice.editor.error");
            }
            return;
        } else if (statusCode == 4L) {
            this.syncUsers(configs, status.getUsers());
            configs.values().forEach(c -> this.cachedEditorConfigStorage.deleteConfig(List.of(key, c.getDocId()), (Config)c));
            return;
        } else if (statusCode == 6L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received Onlyoffice forced saved document. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document " + nodePath + ". URL: " + status.getUrl() + ". Download: " + status.isSaved()));
            }
            if (status.isSaved().booleanValue()) {
                if (status.isSaved().booleanValue()) {
                    status.setConfig(this.getEditorByKey(status.getUserId(), key));
                    LOG.debug("Document is save, and we need to download it (Node (id={}), userId={})", new Object[]{status.getConfig().getDocId(), status.getUserId()});
                }
                status.setConfig(this.getEditorByKey(status.getUserId(), key));
                this.downloadVersion(status);
                return;
            } else {
                this.saveLink(status.getUserId(), key, status.getUrl());
            }
            return;
        } else if (statusCode == 7L) {
            LOG.error((Object)("Received Onlyoffice error of forced saving of document. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document: " + nodePath + ". Error: " + status.getError() + ". URL: " + status.getUrl() + ". Download: " + status.isSaved()));
            return;
        } else {
            LOG.warn((Object)("Received Onlyoffice unexpected status. Key: " + key + ". URL: " + status.getUrl() + ". Users: " + status.getUsers() + ". Document: " + nodePath));
        }
    }

    @Override
    public String initDocument(Node node) throws RepositoryException {
        if (node.getPrimaryNodeType().getName().equals("exo:symlink")) {
            node = (Node)this.finder.findItem(node.getSession(), node.getPath());
        }
        if (node.canAddMixin("mix:referenceable") && this.canEditDocument(node)) {
            node.addMixin("mix:referenceable");
            node.save();
        }
        return node.getUUID();
    }

    @Override
    public String initDocument(String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        Node node = this.node(workspace, path);
        return this.initDocument(node);
    }

    @Override
    public String getEditorLink(Node node, String scheme, String host, int port) throws RepositoryException, EditorLinkNotFoundException {
        String path;
        if (this.canEditDocument(node)) {
            String docId = this.initDocument(node);
            String link = this.platformUrl(scheme, host, port).append(this.editorURLPath(docId)).toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Editor link {}: {}", new Object[]{node.getPath(), link});
            }
            return link;
        }
        String string = path = node != null ? node.getPath() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Editor link not found for {} node", new Object[]{path});
        }
        throw new EditorLinkNotFoundException("Cannot get editor link for " + path + " node.");
    }

    @Override
    public String getDocumentId(Node node) throws DocumentNotFoundException, RepositoryException {
        if (node.isNodeType("mix:referenceable")) {
            return node.getUUID();
        }
        throw new DocumentNotFoundException("The document not found with path: " + node.getPath());
    }

    @Override
    public Node getDocumentById(String workspace, String uuid) throws RepositoryException, DocumentNotFoundException {
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        try {
            return this.nodeByUUID(workspace, uuid);
        }
        catch (ItemNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The node is not found. Workspace: {}, UUID: {}", new Object[]{workspace, uuid});
            }
            throw new DocumentNotFoundException("The document not found with uuid: " + uuid + ", and workspace: " + workspace);
        }
    }

    @Override
    public List<Version> getVersions(String workspace, String docId, int itemParPage, int pageNum) throws Exception {
        ArrayList<Version> versions = new ArrayList<Version>();
        Node currentNode = this.getDocumentById(workspace, docId);
        if (itemParPage == 0) {
            return versions;
        }
        VersionNode rootVersion = new VersionNode(currentNode, currentNode.getSession());
        List<VersionNode> versionNodes = this.getNodeVersions(rootVersion.getChildren(), new ArrayList<VersionNode>());
        int pageNbrs = (int)Math.ceil((double)versionNodes.size() / (double)itemParPage);
        for (int i = 0; i < versionNodes.size(); ++i) {
            VersionNode versionNode = versionNodes.get(i);
            Version version = new Version();
            version.setAuthor(versionNode.getAuthor());
            version.setName(versionNode.getName());
            version.setDisplayName(versionNode.getDisplayName());
            String displayName = versionNode.getAuthor();
            User versionAuthor = this.getUser(versionNode.getAuthor());
            if (versionAuthor != null) {
                displayName = versionAuthor.getDisplayName();
            }
            version.setFullName(displayName);
            version.setVersionLabels(versionNode.getVersionLabels());
            version.setCreatedTime(versionNode.getCreatedTime().getTimeInMillis());
            version.setVersionPageNumber(pageNbrs);
            versions.add(version);
        }
        return this.getPages(versions, itemParPage, pageNum);
    }

    private <T> List<T> getPages(List<T> c, Integer pageSize, int nb) {
        if (c == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(c);
        if (pageSize == null || pageSize <= 0 || pageSize > list.size()) {
            pageSize = list.size();
        }
        int numPages = (int)Math.ceil((double)list.size() / (double)pageSize.intValue());
        ArrayList pages = new ArrayList(numPages);
        int pageNum = 0;
        while (pageNum < numPages) {
            pages.add(list.subList(pageNum * pageSize, Math.min(++pageNum * pageSize, list.size())));
        }
        return (List)pages.get(nb);
    }

    private List<VersionNode> getNodeVersions(List<VersionNode> children, List<VersionNode> versionNodes) throws Exception {
        for (int i = 0; i < children.size(); ++i) {
            versionNodes.add(children.get(i));
            List child = children.get(i).getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child, versionNodes);
        }
        versionNodes.sort((v1, v2) -> {
            try {
                if (Integer.parseInt(v1.getName()) < Integer.parseInt(v2.getName())) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        });
        return versionNodes;
    }

    @Override
    public Node getDocument(String workspace, String path) throws RepositoryException, BadParameterException {
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        try {
            return this.node(workspace, path);
        }
        catch (ItemNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The node is not found. Workspace: {}, path: {}", new Object[]{workspace, path});
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        InputStream is = null;
        Session session = null;
        try {
            String workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            session = this.jcrService.getCurrentRepository().getSystemSession(workspace);
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            is = OnlyofficeEditorService.class.getResourceAsStream("/conf/portal/jcr/onlyoffice-nodetypes.xml");
            nodeTypeManager.registerNodeTypes(is, 4, "text/xml");
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot update nodetypes.", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Cannot close InputStream", (Throwable)e);
                }
            }
        }
        LOG.info((Object)"Onlyoffice Editor service successfuly started");
    }

    public void stop() {
        LOG.info((Object)"Onlyoffice  Editor service successfuly stopped");
    }

    @Override
    public void addTypePlugin(ComponentPlugin plugin) {
        Class<DocumentTypePlugin> pclass = DocumentTypePlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            DocumentTypePlugin newPlugin = (DocumentTypePlugin)((Object)pclass.cast(plugin));
            if (this.documentTypePlugin != null) {
                LOG.info("Replace existing DocumentTypePlugin {} with new one {}", new Object[]{this.documentTypePlugin.getMimeTypes().stream().collect(Collectors.joining(",")), newPlugin.getMimeTypes().stream().collect(Collectors.joining(","))});
            } else {
                LOG.info("Use DocumentTypePlugin {}", new Object[]{newPlugin.getMimeTypes().stream().collect(Collectors.joining(","))});
            }
            this.documentTypePlugin = newPlugin;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set documentTypePlugin instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The documentTypePlugin plugin is not an instance of " + pclass.getName()));
        }
    }

    @Override
    public boolean canEditDocument(Node node) throws RepositoryException {
        boolean res = false;
        if (node != null && this.isDocumentMimeSupported(node)) {
            String remoteUser = WCMCoreUtils.getRemoteUser();
            String superUser = WCMCoreUtils.getSuperUser();
            boolean locked = node.isLocked();
            if (locked && (remoteUser.equalsIgnoreCase(superUser) || node.getLock().getLockOwner().equals(remoteUser))) {
                locked = false;
            }
            boolean bl = res = !locked && PermissionUtil.canSetProperty((Node)node);
        }
        if (!res && LOG.isDebugEnabled()) {
            LOG.debug("Cannot edit: {}", new Object[]{node != null ? node.getPath() : null});
        }
        return res;
    }

    @Override
    public boolean isDocumentMimeSupported(Node node) throws RepositoryException {
        if (this.documentTypePlugin != null) {
            if (node != null) {
                String mimeType = node.isNodeType("nt:file") ? node.getNode("jcr:content").getProperty("jcr:mimeType").getString() : new MimeTypeResolver().getMimeType(node.getName());
                return this.documentTypePlugin.getMimeTypes().contains(mimeType);
            }
            return false;
        }
        return true;
    }

    @Override
    public void downloadVersion(String userId, String key, boolean coEdited, boolean forcesaved, String comment, String contentUrl) {
        String docId = null;
        Config config = null;
        try {
            config = this.getEditorByKey(userId, key);
            docId = config.getDocId();
        }
        catch (RepositoryException | OnlyofficeEditorException e) {
            LOG.error((Object)("Cannot obtain config. docId: " + docId), e);
        }
        DocumentStatus status = new DocumentStatus.Builder().config(config).key(key).url(contentUrl).comment(comment).userId(userId).coEdited(coEdited).forcesaved(forcesaved).build();
        this.downloadVersion(status);
    }

    @Override
    public Config.Editor.User getLastModifier(String key) {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        Config.Editor.User lastUser = null;
        if (configs != null && !configs.isEmpty()) {
            long maxLastModified = 0L;
            for (Map.Entry<String, Config> entry : configs.entrySet()) {
                Config.Editor.User user = entry.getValue().getEditorConfig().getUser();
                long lastModified = user.getLastModified();
                if (lastModified <= maxLastModified) continue;
                maxLastModified = lastModified;
                lastUser = user;
            }
        }
        return lastUser;
    }

    @Override
    public void setLastModifier(String key, String userId) {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs != null && !configs.isEmpty()) {
            Config config = configs.get(userId);
            config.getEditorConfig().getUser().setLastModified(System.currentTimeMillis());
            this.cachedEditorConfigStorage.saveConfig(List.of(key, config.getDocId()), config, false);
        }
    }

    @Override
    public Config.Editor.User getUser(String key, String userId) {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs != null && configs.containsKey(userId)) {
            return configs.get(userId).getEditorConfig().getUser();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceSave(String userId, String key, boolean download, boolean coEdit, boolean forcesaved, String comment) {
        HttpURLConnection connection = null;
        try {
            Userdata userdata = new Userdata(userId, download, coEdit, forcesaved, comment);
            String json = new JSONObject().put("c", (Object)"forcesave").put("key", (Object)key).put("userdata", (Object)userdata.toJSON()).toString();
            byte[] postDataBytes = json.toString().getBytes("UTF-8");
            URL url = new URL(this.commandServiceUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (this.documentserverSecret != null && !this.documentserverSecret.trim().isEmpty()) {
                String jwtToken = Jwts.builder().setSubject("exo-onlyoffice").claim("c", (Object)"forcesave").claim("key", (Object)key).claim("userdata", (Object)userdata.toJSON()).signWith((Key)Keys.hmacShaKeyFor((byte[])this.documentserverSecret.getBytes())).compact();
                connection.setRequestProperty("Authorization", "Bearer " + jwtToken);
            }
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(postDataBytes);
            }
            catch (Exception e) {
                LOG.error((Object)"Error occured while sending request to Document Server: ", (Throwable)e);
            }
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            String response = IOUtils.toString((InputStream)in, (String)"UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Command service responded on forcesave command: " + response));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error in sending forcesave command. UserId: " + userId + ". Key: " + key + ". Download: " + download), (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public boolean validateToken(String token, String key) {
        if (this.documentserverSecret == null || this.documentserverSecret.trim().isEmpty()) {
            return true;
        }
        if (token != null && key != null) {
            try {
                Jws jws = Jwts.parser().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])this.documentserverSecret.getBytes())).parseClaimsJws(token);
                Map claims = (Map)((Claims)jws.getBody()).get((Object)"payload");
                if (claims != null) {
                    if (claims.containsKey("key")) {
                        return String.valueOf(claims.get("key")).equals(key);
                    }
                    if (claims.containsKey("url")) {
                        return String.valueOf(claims.get("url")).endsWith(key);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Couldn't validate the token: {} key: {} :", new Object[]{token, key, e.getMessage()});
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTitle(String workspace, String docId, String newTitle, String userId) {
        ConversationState contextState = ConversationState.getCurrent();
        SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
        if (!this.setUserConvoState(userId)) {
            LOG.error("Cannot set user conversation state: {}", new Object[]{userId});
            return;
        }
        try {
            newTitle = Text.escapeIllegalJcrChars((String)newTitle);
            if (StringUtils.isBlank((String)newTitle)) {
                LOG.warn((Object)("Cannot rename document docId: " + docId + " - new title is empty"));
                return;
            }
            NodeImpl node = (NodeImpl)this.getDocumentById(workspace, docId);
            NodeImpl parentNode = node.getParent();
            if (parentNode.canAddMixin("mix:referenceable")) {
                parentNode.addMixin("mix:referenceable");
                parentNode.save();
            }
            if (!node.hasPermission("remove")) {
                Session systemSession = this.jcrService.getCurrentRepository().getSystemSession(workspace);
                NodeImpl systemNode = (NodeImpl)systemSession.getNodeByUUID(docId);
                systemNode.addMixin("exo:privilegeable");
                systemNode.setPermission(userId, new String[]{"remove", "read", "add_node", "set_property"});
                systemNode.save();
            }
            String destPath = parentNode.getPath().equals("/") ? parentNode.getPath() + newTitle : parentNode.getPath() + "/" + newTitle;
            parentNode.getSession().move(node.getPath(), destPath);
            node.setProperty("exo:lastModifier", userId);
            node.setProperty("exo:name", newTitle);
            node.setProperty("exo:title", newTitle);
            node.refresh(true);
            parentNode.getSession().save();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Rename is not successful!", (Throwable)e);
            }
        }
        finally {
            this.restoreConvoState(contextState, contextProvider);
        }
    }

    @Override
    public User getUser(String username) throws OnlyofficeEditorException {
        try {
            return this.organization.getUserHandler().findUserByName(username);
        }
        catch (Exception e) {
            throw new OnlyofficeEditorException("Error searching user " + username, e);
        }
    }

    @Override
    public void addFilePreferences(Node node, String userId, String path) throws RepositoryException {
        Node preferences;
        if (!node.hasNode("eoo:preferences")) {
            if (node.canAddMixin("eoo:onlyofficeFile")) {
                node.addMixin("eoo:onlyofficeFile");
            }
            preferences = node.addNode("eoo:preferences");
        } else {
            preferences = node.getNode("eoo:preferences");
        }
        Node userPreferences = !preferences.hasNode(userId) ? preferences.addNode(userId, "eoo:userPreferences") : preferences.getNode(userId);
        userPreferences.setProperty("path", path);
        node.save();
    }

    @Override
    public String getDocumentServiceSecret() {
        return this.documentserverSecret;
    }

    @Override
    public void closeWithoutModification(String userId, String key) {
        Config config;
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs.keySet().size() > 1 && (config = configs.get(userId)) != null && config.isClosed()) {
            this.cachedEditorConfigStorage.deleteConfig(key, config);
        }
    }

    @Override
    public boolean isDocumentCoedited(String key) {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        return configs != null && !configs.isEmpty() && configs.size() > 1;
    }

    protected void saveLink(String userId, String key, String url) {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(key);
        if (configs != null && !configs.isEmpty()) {
            Config config = configs.get(userId);
            config.getEditorConfig().getUser().setDownloadLink(url);
            config.getEditorConfig().getUser().setLinkSaved(System.currentTimeMillis());
            this.cachedEditorConfigStorage.saveConfig(List.of(key, config.getDocId()), config, false);
        }
    }

    protected void downloadClosed(DocumentStatus status) {
        Config config = status.getConfig();
        config.closing();
        this.broadcastEvent(status, "exo.onlyoffice.editor.closed");
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Document is closed, download it (Node (id={}), userId={})", new Object[]{status.getConfig().getDocId(), status.getUserId()});
            }
            this.download(status);
            config.getEditorConfig().getUser().setLastSaved(System.currentTimeMillis());
            config.closed();
            this.cachedEditorConfigStorage.deleteConfig(List.of(config.getDocument().getKey(), config.getDocId()), config);
        }
        catch (RepositoryException | OnlyofficeEditorException e) {
            LOG.error((Object)("Error occured while downloading document content [Closed]. docId: " + config.getDocId()), e);
        }
    }

    protected String nodeTitle(Node node) throws RepositoryException {
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getString();
        } else if (node.hasProperty("jcr:content/dc:title")) {
            Property dcTitle = node.getProperty("jcr:content/dc:title");
            if (dcTitle.getDefinition().isMultiple()) {
                Value[] dctValues = dcTitle.getValues();
                if (dctValues.length > 0) {
                    title = dctValues[0].getString();
                }
            } else {
                title = dcTitle.getString();
            }
        } else if (node.hasProperty("exo:name")) {
            title = node.getProperty("exo:name").getString();
        }
        if (title == null) {
            try {
                title = URLDecoder.decode(node.getName(), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Cannot decode node name using URLDecoder. {}", new Object[]{e.getMessage()});
            }
        }
        return title;
    }

    protected String fileType(Node node) throws RepositoryException {
        String title = this.nodeTitle(node);
        int dotIndex = title.lastIndexOf(46);
        if (dotIndex >= 0 && dotIndex < title.length()) {
            String fileExt = title.substring(dotIndex + 1).trim().toLowerCase();
            if (this.fileTypes.containsKey(fileExt)) {
                return fileExt;
            }
        } else {
            try {
                String mimeType = OnlyofficeEditorServiceImpl.getMimeType(node);
                if (StringUtils.isNotBlank((String)mimeType)) {
                    return DMSMimeTypeResolver.getInstance().getExtension(mimeType);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not instantiate DMSMimeTypeResolver ");
                return null;
            }
        }
        return null;
    }

    protected String documentType(String fileType) {
        String docType;
        if (StringUtils.isNotBlank((String)fileType) && (docType = this.fileTypes.get(fileType)) != null) {
            return docType;
        }
        return TYPE_TEXT;
    }

    public static String getMimeType(Node node) {
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") && node.hasNode("jcr:content")) {
                return node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return "";
    }

    protected Node nodeContent(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }

    protected Calendar nodeCreated(Node node) throws RepositoryException {
        return node.getProperty("jcr:created").getDate();
    }

    protected String mimeType(Node content) throws RepositoryException {
        return content.getProperty("jcr:mimeType").getString();
    }

    protected Property data(Node content) throws RepositoryException {
        return content.getProperty("jcr:data");
    }

    protected UUID generateId(String workspace, String path) {
        StringBuilder s = new StringBuilder();
        s.append(workspace);
        s.append(path);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(RANDOM.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    protected String nodePath(String workspace, String path) {
        return workspace + ":" + path;
    }

    protected String nodePath(Config config) {
        return this.nodePath(config.getWorkspace(), config.getPath());
    }

    protected boolean syncUsers(Map<String, Config> configs, String[] users) {
        HashSet<String> editors = new HashSet<String>(Arrays.asList(users));
        boolean updated = false;
        for (Map.Entry<String, Config> ce : configs.entrySet()) {
            String user = ce.getKey();
            Config config = ce.getValue();
            DocumentStatus status = new DocumentStatus.Builder().config(config).key(config.getDocument().getKey()).url(config.getEditorUrl()).users(users).build();
            if (editors.contains(user)) {
                if (!config.isCreated() && !config.isClosed()) continue;
                config.open();
                this.fireJoined(status);
                this.broadcastEvent(status, "exo.onlyoffice.editor.opened");
                updated = true;
                this.updateCache(config);
                continue;
            }
            if (!config.isClosing() && !config.isOpen()) continue;
            config.closed();
            this.fireLeaved(status);
            this.broadcastEvent(status, "exo.onlyoffice.editor.closed");
            updated = true;
            this.updateCache(config);
        }
        return updated;
    }

    protected String[] getActiveUsers(Map<String, Config> configs) {
        LinkedHashSet<String> userIds = new LinkedHashSet<String>(configs.keySet());
        Iterator uiter = userIds.iterator();
        while (uiter.hasNext()) {
            String userId = (String)uiter.next();
            Config config = configs.get(userId);
            if (config != null && !config.isCreated() && !config.isClosed()) continue;
            uiter.remove();
        }
        return userIds.toArray(new String[userIds.size()]);
    }

    protected void downloadVersion(DocumentStatus status) {
        try {
            this.download(status);
            Config config = status.getConfig();
            if (config.isClosed()) {
                this.cachedEditorConfigStorage.deleteConfig(List.of(config.getDocId(), config.getDocument().getKey()), config);
            } else {
                config.getEditorConfig().getUser().setLastSaved(System.currentTimeMillis());
                this.updateCache(config);
            }
        }
        catch (RepositoryException | OnlyofficeEditorException e) {
            LOG.error((Object)("Error occured while downloading document [Version]. docId: " + status.getConfig().getDocId()), e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void download(DocumentStatus status) throws OnlyofficeEditorException, RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateCache(Config config) {
        Map<String, Config> configs = this.cachedEditorConfigStorage.getConfigsByKey(config.getDocument().getKey());
        if (configs != null && !configs.isEmpty()) {
            this.cachedEditorConfigStorage.saveConfig(List.of(config.getDocument().getKey(), config.getDocId()), config, false);
        }
    }

    protected String addComment(String activityId, String commentText, String userId) {
        if (activityId != null && !activityId.isEmpty() && commentText != null && !commentText.trim().isEmpty()) {
            IdentityManager identityManager = (IdentityManager)WCMCoreUtils.getService(IdentityManager.class);
            org.exoplatform.social.core.identity.model.Identity identity = identityManager.getOrCreateIdentity("organization", userId, false);
            ExoSocialActivity activity = this.activityManager.getActivity(activityId);
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl(identity.getId(), "exosocial:spaces", commentText, null);
            this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
            return comment.getId();
        }
        LOG.warn("Cannot add comment. ActivityId and comment shouldn't be null or empty. activityId: {}, comment: {}", new Object[]{activityId, commentText});
        return null;
    }

    protected void createVersionOfDraft(Node node) throws RepositoryException, OnlyofficeEditorException {
        ConversationState contextState = ConversationState.getCurrent();
        SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
        String userId = node.getProperty("exo:lastModifier").getString();
        if (this.setUserConvoState(userId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating a version from draft. Path: " + node.getPath() + " user: " + userId));
            }
            try {
                node.save();
                if (this.checkout(node)) {
                    node.checkin();
                    node.checkout();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Couldnl't create a version from draft for user: " + userId));
            }
        } else {
            this.logError(userId, node.getPath(), node.getUUID(), null, "Cannot set conversation state");
            throw new OnlyofficeEditorException("Cannot set conversation state " + userId);
        }
        this.restoreConvoState(contextState, contextProvider);
    }

    protected Node node(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(userSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected Node systemNode(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSystemSessionProvider(null);
        Session sysSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(sysSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected Node nodeByUUID(String workspace, String uuid) throws RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        ExtendedSession userSession = (ExtendedSession)sp.getSession(workspace, this.jcrService.getCurrentRepository());
        return userSession.getNodeByIdentifier(uuid);
    }

    protected boolean checkout(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return true;
        }
        return false;
    }

    protected void unlock(Node node, LockState lock) throws OnlyofficeEditorException, RepositoryException {
        node.unlock();
        try {
            LockUtil.removeLock((Node)node);
        }
        catch (Exception e) {
            if (RepositoryException.class.isAssignableFrom(e.getClass())) {
                throw (RepositoryException)((Object)RepositoryException.class.cast(e));
            }
            this.logError(null, node.getPath(), node.getUUID(), null, "Error removing document lock");
            throw new OnlyofficeEditorException("Error removing document lock", e);
        }
    }

    protected LockState lock(Node node, Config config) throws OnlyofficeEditorException, RepositoryException {
        LockState lock;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to lock Node (id={},path={}). (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
        }
        if (!node.isNodeType("mix:lockable")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node (id={},path={}) is not mix:lockable, add mixin (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
            }
            if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node (id={},path={}) is not checkouted, checkout it (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                }
                node.checkout();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node (id={},path={}) is now checkout. (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                }
            }
            node.addMixin("mix:lockable");
            node.save();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node (id={},path={}) is now mix:lockable. (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
            }
        }
        Config.Editor.User user = config.getEditorConfig().getUser();
        int attempts = 0;
        try {
            do {
                ++attempts;
                if (node.isLocked()) {
                    String lockToken;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Node (id={},path={}) is already locked. (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                    }
                    try {
                        lockToken = LockUtil.getLockToken((Node)node);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Node (id={},path={}) is locked with token={}. (userId={})", new Object[]{node.getUUID(), node.getPath(), lockToken, config.getEditorConfig().getUser().getId()});
                        }
                    }
                    catch (Exception e) {
                        if (RepositoryException.class.isAssignableFrom(e.getClass())) {
                            throw (RepositoryException)((Object)RepositoryException.class.cast(e));
                        }
                        this.logError(config.getEditorConfig().getUser().getId(), node.getPath(), node.getUUID(), config.getDocument().getKey(), "Error reading document lock");
                        throw new OnlyofficeEditorException("Error reading document lock", e);
                    }
                    if (node.getLock().getLockOwner().equals(user.getId()) && lockToken != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Node (id={},path={}) is locked by currentUser : lockOwner={}, lockToken={}. (userId={})", new Object[]{node.getUUID(), node.getPath(), node.getLock().getLockOwner(), lockToken, config.getEditorConfig().getUser().getId()});
                        }
                        node.getSession().addLockToken(lockToken);
                        lock = new LockState(lockToken);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("New lock token ({}) added to node (id={},path={}). (userId={})", new Object[]{lockToken, node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Wait {} ms before retrying to take lock on node (id={},path={}). (userId={})", new Object[]{250L, node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                    }
                    Thread.sleep(250L);
                    lock = null;
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node (id={},path={}) is not locked, take the lock. (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                }
                Lock jcrLock = node.lock(true, false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node (id={},path={}) is now locked. (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                }
                try {
                    LockUtil.keepLock((Lock)jcrLock, (String)user.getId(), (String)jcrLock.getLockToken());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Node (id={},path={}) is now locked and accept other lock for user. (userId={})", new Object[]{node.getUUID(), node.getPath(), config.getEditorConfig().getUser().getId()});
                    }
                }
                catch (Exception e) {
                    if (RepositoryException.class.isAssignableFrom(e.getClass())) {
                        throw (RepositoryException)((Object)RepositoryException.class.cast(e));
                    }
                    this.logError(config.getEditorConfig().getUser().getId(), node.getPath(), node.getUUID(), config.getDocument().getKey(), "Error saving document lock");
                    throw new OnlyofficeEditorException("Error saving document lock", e);
                }
                lock = new LockState(jcrLock);
            } while (lock == null && attempts <= 20);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logError(config.getEditorConfig().getUser().getId(), node.getPath(), node.getUUID(), config.getDocument().getKey(), "Error waiting for a lock");
            throw new OnlyofficeEditorException("Error waiting for lock of " + this.nodePath(config.getWorkspace(), config.getPath()), e);
        }
        return lock == null ? new LockState() : lock;
    }

    protected void validateUser(String userId, Config config) throws BadParameterException, OnlyofficeEditorException {
        User user = this.getUser(userId);
        if (user == null) {
            LOG.warn((Object)("Attempt to access editor document (" + this.nodePath(config) + ") under not existing user " + userId));
            throw new BadParameterException("User not found for " + config.getDocument().getTitle());
        }
    }

    public static String getUserLanguage(String userId) {
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
        Object lang = Locale.getDefault().getLanguage();
        if (localePolicy != null) {
            Locale locale = localePolicy.determineLocale(localeCtx);
            lang = locale.getLanguage();
            if ("PT".equalsIgnoreCase(locale.getCountry()) || "TW".equalsIgnoreCase(locale.getCountry())) {
                lang = locale.getLanguage() + "-" + locale.getCountry();
            }
        }
        return lang;
    }

    protected StringBuilder platformUrl(String schema, String host, int port) {
        StringBuilder platformUrl = new StringBuilder();
        platformUrl.append(schema);
        platformUrl.append("://");
        platformUrl.append(host);
        if (port >= 0 && port != 80 && port != 443) {
            platformUrl.append(':');
            platformUrl.append(port);
        }
        platformUrl.append('/');
        platformUrl.append(PortalContainer.getCurrentPortalContainerName());
        return platformUrl;
    }

    @Deprecated
    protected StringBuilder explorerUrl(String schema, String host, int port, String ecmsURL) {
        StringBuilder explorerUrl = new StringBuilder();
        explorerUrl.append(schema);
        explorerUrl.append("://");
        explorerUrl.append(host);
        if (port >= 0 && port != 80 && port != 443) {
            explorerUrl.append(':');
            explorerUrl.append(port);
        }
        explorerUrl.append(ecmsURL);
        return explorerUrl;
    }

    protected URI explorerUri(String schema, String host, int port, String ecmsLink) {
        URI uri;
        try {
            ecmsLink = URLDecoder.decode(ecmsLink, StandardCharsets.UTF_8.name());
            String[] linkParts = ecmsLink.split("\\?");
            uri = linkParts.length >= 2 ? new URI(schema, null, host, port, linkParts[0], linkParts[1], null) : new URI(schema, null, host, port, ecmsLink, null, null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating document URI", (Throwable)e);
            try {
                uri = URI.create(ecmsLink);
            }
            catch (Exception e1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error creating document URI from ECMS link and after error: " + e.getMessage()), (Throwable)e1);
                }
                uri = null;
            }
        }
        return uri;
    }

    protected String explorerLink(String jcrPath) {
        try {
            return this.documentService.getLinkInDocumentsApp(jcrPath);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error creating document link for " + jcrPath), (Throwable)e);
            return '/' + PortalContainer.getCurrentPortalContainerName();
        }
    }

    protected StringBuilder platformRestUrl(CharSequence platformUrl) {
        StringBuilder restUrl = new StringBuilder(platformUrl);
        restUrl.append('/');
        restUrl.append(PortalContainer.getCurrentRestContextName());
        return restUrl;
    }

    protected void broadcastEvent(DocumentStatus status, String eventType) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fire {} event. DocumentStatus: {}", new Object[]{eventType, status.toJSON()});
            }
            this.listenerService.broadcast(eventType, (Object)this, (Object)status);
        }
        catch (Exception e) {
            LOG.error("Error firing listener with Onlyoffice {} event for user: {}, document: {}", new Object[]{eventType, status.getConfig().getEditorConfig().getUser().getId(), status.getConfig().getDocId(), e});
        }
    }

    protected void fireCreated(DocumentStatus status) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onCreate(status);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Creation listener error", t);
            }
        }
    }

    protected void fireGet(DocumentStatus status) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onGet(status);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Read (Get) listener error", t);
            }
        }
    }

    protected void fireJoined(DocumentStatus status) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onJoined(status);
            }
            catch (Throwable t) {
                LOG.warn((Object)"User joining listener error", t);
            }
        }
    }

    protected void fireLeaved(DocumentStatus status) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onLeaved(status);
            }
            catch (Throwable t) {
                LOG.warn((Object)"User leaving listener error", t);
            }
        }
    }

    protected void fireSaved(DocumentStatus status) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onSaved(status);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Saving listener error", t);
            }
        }
    }

    protected void fireError(DocumentStatus status) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onError(status);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Error listener error", t);
            }
        }
    }

    protected Identity userIdentity(String userId) {
        Identity userIdentity = this.identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                userIdentity = this.authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
            }
        }
        return userIdentity;
    }

    protected String lowerCase(String str) {
        return str.toUpperCase().toLowerCase();
    }

    protected String editorURLPath(String docId) throws EditorLinkNotFoundException {
        String portalName;
        try {
            portalName = this.getCurrentPortalName();
        }
        catch (Exception e) {
            LOG.error("Cannot get current portal owner {}", new Object[]{e.getMessage()});
            throw new EditorLinkNotFoundException("Editor link not found - cannot get current portal owner");
        }
        return '/' + portalName + "/oeditor?docId=" + docId;
    }

    protected void logError(String userId, String path, String docId, String key, String reason) {
        LOG.error((Object)("Editor error: " + reason + " [UserId: " + userId + ", docId: " + docId + ", path: " + path + ", key: " + key + "]"));
    }

    protected void logError(String userId, String path, String docId, String key, String reason, Throwable e) {
        LOG.error((Object)("Editor error: " + reason + " [UserId: " + userId + ", docId: " + docId + ", path: " + path + ", key: " + key + "]"), e);
    }

    protected boolean setUserConvoState(String userId) {
        Identity userIdentity = this.userIdentity(userId);
        if (userIdentity != null) {
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            ConversationState.setCurrent((ConversationState)state);
            SessionProvider userProvider = new SessionProvider(state);
            this.sessionProviders.setSessionProvider(null, userProvider);
            return true;
        }
        LOG.warn((Object)("User identity not found " + userId + " for setting conversation state"));
        return false;
    }

    protected void restoreConvoState(ConversationState contextState, SessionProvider contextProvider) {
        ConversationState.setCurrent((ConversationState)contextState);
        this.sessionProviders.setSessionProvider(null, contextProvider);
    }

    protected void initFileTypes() {
        this.fileTypes.put("docx", TYPE_TEXT);
        this.fileTypes.put("doc", TYPE_TEXT);
        this.fileTypes.put("odt", TYPE_TEXT);
        this.fileTypes.put("txt", TYPE_TEXT);
        this.fileTypes.put("rtf", TYPE_TEXT);
        this.fileTypes.put("mht", TYPE_TEXT);
        this.fileTypes.put("html", TYPE_TEXT);
        this.fileTypes.put("htm", TYPE_TEXT);
        this.fileTypes.put("epub", TYPE_TEXT);
        this.fileTypes.put("pdf", TYPE_TEXT);
        this.fileTypes.put("djvu", TYPE_TEXT);
        this.fileTypes.put("xps", TYPE_TEXT);
        this.fileTypes.put("docxf", TYPE_TEXT);
        this.fileTypes.put("oform", TYPE_TEXT);
        this.fileTypes.put("xlsx", TYPE_SPREADSHEET);
        this.fileTypes.put("xls", TYPE_SPREADSHEET);
        this.fileTypes.put("ods", TYPE_SPREADSHEET);
        this.fileTypes.put("pptx", TYPE_PRESENTATION);
        this.fileTypes.put("ppt", TYPE_PRESENTATION);
        this.fileTypes.put("ppsx", TYPE_PRESENTATION);
        this.fileTypes.put("pps", TYPE_PRESENTATION);
        this.fileTypes.put("odp", TYPE_PRESENTATION);
        this.fileTypes.put("potx", TYPE_PRESENTATION);
    }

    protected String getDocumentserverHost(String dsSchema, String dsHost) throws ConfigurationException {
        if (dsSchema == null || (dsSchema = dsSchema.trim()).length() == 0) {
            dsSchema = "http";
        }
        if (dsHost == null || (dsHost = dsHost.trim()).length() == 0) {
            throw new ConfigurationException("Configuration of documentserver-host required");
        }
        int portIndex = dsHost.indexOf(58);
        if (portIndex > 0) {
            return dsHost.substring(0, portIndex);
        }
        return dsHost;
    }

    protected Set<String> getDocumentserverAllowedHosts(String dsAllowedHost) {
        if (dsAllowedHost != null && !dsAllowedHost.isEmpty()) {
            HashSet<String> allowedhosts = new HashSet<String>();
            for (String ahost : dsAllowedHost.split(",")) {
                if ((ahost = ahost.trim()).isEmpty()) continue;
                allowedhosts.add(this.lowerCase(ahost));
            }
            return Collections.unmodifiableSet(allowedhosts);
        }
        return Collections.emptySet();
    }

    protected String getDrive(Node node) {
        try {
            DriveData driveData = this.documentService.getDriveOfNode(node.getPath());
            Object drive = "";
            if (driveData != null) {
                String driveName = driveData.getName();
                if (node.getPath().startsWith(this.usersPath)) {
                    drive = driveName;
                } else if (driveName.startsWith(".spaces.")) {
                    String spacePrettyName = driveName.substring(driveName.lastIndexOf(".") + 1);
                    Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
                    if (space != null) {
                        drive = "spaces/" + space.getPrettyName();
                    } else {
                        LOG.warn("Cannot find space by pretty name {}", new Object[]{spacePrettyName});
                        drive = spacePrettyName;
                    }
                } else if (driveName.startsWith(".platform.")) {
                    String groupId = driveName.replaceAll("\\.", "/");
                    Group group = this.organization.getGroupHandler().findGroupById(groupId);
                    if (group != null) {
                        drive = group.getLabel();
                    } else {
                        LOG.warn("Cannot find group by id {}", new Object[]{groupId});
                        drive = groupId;
                    }
                } else {
                    drive = driveData.getName();
                }
            }
            return drive;
        }
        catch (Exception e) {
            LOG.error((Object)"Error occured while getting drive", (Throwable)e);
            return null;
        }
    }

    protected String getDisplayPath(Node node, String userId) {
        try {
            String parentFolder;
            DriveData driveData = this.documentService.getDriveOfNode(node.getPath());
            List<String> elems = Arrays.asList(node.getPath().split("/"));
            try {
                parentFolder = node.getParent().getProperty("exo:title").getString();
            }
            catch (Exception e) {
                LOG.debug("Couldn't get exo:title from node parent. Node {}, message {}", new Object[]{node.getPath(), e.getMessage()});
                parentFolder = elems.get(elems.size() - 2);
            }
            String title = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : elems.get(elems.size() - 1);
            Object drive = "";
            if (driveData != null) {
                String driveName = driveData.getName();
                if (node.getPath().startsWith(this.usersPath)) {
                    drive = driveName;
                    if (!userId.equals(this.getUserId(node.getPath()))) {
                        Node symlink = this.getSymlink(node, userId);
                        if (symlink != null && !StringUtils.equals((String)symlink.getPath(), (String)node.getPath())) {
                            return this.getDisplayPath(symlink, userId);
                        }
                        if (symlink == null) {
                            parentFolder = HIDDEN_FOLDER;
                        }
                    }
                } else if (driveName.startsWith(".spaces.")) {
                    String spacePrettyName = driveName.substring(driveName.lastIndexOf(".") + 1);
                    Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
                    if (space != null) {
                        drive = "spaces/" + space.getDisplayName();
                    } else {
                        LOG.warn("Cannot find space by pretty name {}", new Object[]{spacePrettyName});
                        drive = spacePrettyName;
                    }
                } else if (driveName.startsWith(".platform.")) {
                    String groupId = driveName.replaceAll("\\.", "/");
                    Group group = this.organization.getGroupHandler().findGroupById(groupId);
                    if (group != null) {
                        drive = group.getLabel();
                    } else {
                        LOG.warn("Cannot find group by id {}", new Object[]{groupId});
                        drive = groupId;
                    }
                } else {
                    drive = driveData.getName();
                }
            }
            return (String)drive + ":" + parentFolder + "/" + title;
        }
        catch (Exception e) {
            LOG.error((Object)"Error occured while creating display path", (Throwable)e);
            return null;
        }
    }

    protected Node getSymlink(Node node, String userId) throws Exception {
        Node filePreferences;
        if (node.hasNode("eoo:preferences") && (filePreferences = node.getNode("eoo:preferences")).hasNode(userId)) {
            Node userPreferences = filePreferences.getNode(userId);
            String path = userPreferences.getProperty("path").getString();
            return (Node)node.getSession().getItem(path);
        }
        return null;
    }

    protected String getUserId(String path) {
        List<String> elems = Arrays.asList(path.split("/"));
        int position = 2;
        while (elems.get(position).endsWith("_")) {
            ++position;
        }
        return elems.get(position);
    }

    protected String nodeComment(Node node) {
        try {
            String commentId;
            if (node.hasProperty("eoo:commentId") && (commentId = node.getProperty("eoo:commentId").getString()) != null && !commentId.isEmpty()) {
                ExoSocialActivity comment = this.activityManager.getActivity(commentId);
                return comment != null ? comment.getTitle() : null;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot get eoo:commentId of node.", (Throwable)e);
        }
        return null;
    }

    protected boolean canRenameDocument(Node node) {
        try {
            NodeImpl parent = (NodeImpl)node.getParent();
            return parent.hasPermission("read") && parent.hasPermission("add_node") && parent.hasPermission("set_property");
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String getLastModified(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (node.hasProperty("exo:lastModifiedDate")) {
            Calendar date = node.getProperty("exo:lastModifiedDate").getDate();
            Locale locale = null;
            try {
                PortalRequestContext portalRequestContext = this.getPortalRequestContext();
                if (portalRequestContext != null) {
                    locale = portalRequestContext.getLocale();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Cannot get locale from portal request context", (Throwable)e);
            }
            if (locale == null) {
                locale = Locale.getDefault();
                LOG.debug("Not a WebUI context request, using default one: {}", new Object[]{locale.getDisplayLanguage()});
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(LAST_EDITED_DATE_FORMAT, locale);
            return dateFormat.format(date.getTimeInMillis());
        }
        return null;
    }

    protected String getLastModifier(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException, OnlyofficeEditorException {
        String lastModifierId;
        User modifier;
        if (node.hasProperty("exo:lastModifier") && (modifier = this.getUser(lastModifierId = node.getProperty("exo:lastModifier").getString())) != null) {
            return modifier.getDisplayName();
        }
        return null;
    }

    protected boolean isSuspendDownloadDocument() {
        SettingService settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        SettingValue settingValue = settingService.get(Context.GLOBAL.id("downloadDocumentStatus"), Scope.APPLICATION.id("downloadDocumentStatus"), "exo:downloadDocumentStatus");
        return settingValue != null && !settingValue.getValue().toString().isEmpty() ? Boolean.valueOf(settingValue.getValue().toString()) : false;
    }

    private String getCurrentPortalName() {
        List portalNames;
        PortalRequestContext portalRequestContext = this.getPortalRequestContext();
        if (portalRequestContext != null) {
            return portalRequestContext.getPortalOwner();
        }
        LayoutService layoutService = (LayoutService)WCMCoreUtils.getService(LayoutService.class);
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
        String defaultPortal = userPortalConfigService.getDefaultPortal();
        UserACL userACL = (UserACL)ExoContainerContext.getService(UserACL.class);
        PortalConfig portalConfig = layoutService.getPortalConfig(SiteType.PORTAL.key(defaultPortal));
        if (portalConfig != null && userACL.hasPermission(portalConfig)) {
            return defaultPortal;
        }
        int offset = 0;
        int limit = 20;
        do {
            String defaultUserPortalName;
            if ((defaultUserPortalName = (String)(portalNames = layoutService.getSiteNames(SiteType.PORTAL, offset, limit)).stream().filter(portalName -> {
                PortalConfig userPortalConfig = layoutService.getPortalConfig(SiteType.PORTAL.key(portalName));
                return userPortalConfig != null && userACL.hasPermission(userPortalConfig);
            }).findFirst().orElse(null)) != null) {
                return defaultUserPortalName;
            }
            offset += limit;
        } while (portalNames.size() == limit);
        return null;
    }

    private PortalRequestContext getPortalRequestContext() {
        RequestContext currentInstance;
        for (currentInstance = RequestContext.getCurrentInstance(); currentInstance != null && !(currentInstance instanceof PortalRequestContext); currentInstance = currentInstance.getParentAppRequestContext()) {
        }
        return (PortalRequestContext)currentInstance;
    }

    class LockState {
        final String lockToken;
        final Lock lock;

        LockState(String lockToken) {
            this.lockToken = lockToken;
            this.lock = null;
        }

        LockState(Lock lock) {
            this.lockToken = null;
            this.lock = lock;
        }

        LockState() {
            this.lockToken = null;
            this.lock = null;
        }

        boolean wasLocked() {
            return this.lock != null;
        }

        boolean canEdit() {
            return this.lock != null || this.lockToken != null;
        }
    }

    public static class DocumentTypesConfig {
        protected List<String> mimeTypes;

        public List<String> getMimeTypes() {
            return this.mimeTypes;
        }

        public void setMimeTypes(List<String> mimeTypes) {
            this.mimeTypes = mimeTypes;
        }
    }
}

