/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.documents;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.onlyoffice.DocumentNotFoundException;
import org.exoplatform.onlyoffice.EditorLinkNotFoundException;
import org.exoplatform.onlyoffice.OnlyOfficeDocumentUpdateActivityHandler;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.cometd.CometdConfig;
import org.exoplatform.onlyoffice.cometd.CometdOnlyofficeService;
import org.exoplatform.onlyoffice.webui.OnlyofficeContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.DocumentEditor;
import org.exoplatform.services.cms.documents.DocumentUpdateActivityHandler;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;

public class OnlyofficeDocumentEditorPlugin
extends BaseComponentPlugin
implements DocumentEditor {
    protected static final String PROVIDER_NAME = "onlyoffice";
    protected static final long EDITING_FINISHED_DELAY = 10000L;
    protected static final String PROVIDER_CONFIGURATION_PARAM = "provider-configuration";
    protected static final String EDITOR_LINK_NOT_FOUND_ERROR = "EditorLinkNotFoundError";
    protected static final String EDITOR_LINK_NOT_FOUND_ERROR_MESSAGE = "EditorLinkNotFoundErrorMessage";
    protected static final String STORAGE_ERROR = "StorageError";
    protected static final String STORAGE_ERROR_MESSAGE = "StorageErrorMessage";
    protected static final String INTERNAL_EDITOR_ERROR = "InternalEditorError";
    protected static final String INTERNAL_EDITOR_ERROR_MESSAGE = "InternalEditorErrorMessage";
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeDocumentEditorPlugin.class);
    protected static final String STREAM = "stream";
    protected static final String PREVIEW = "peview";
    protected static final String DRIVES = "drives";
    protected static final String CLIENT_RESOURCE_PREFIX = "OnlyofficeEditorClient.";
    protected final OnlyofficeEditorService editorService;
    protected final ResourceBundleService i18nService;
    protected final CometdOnlyofficeService cometdService;
    protected final LinkManager linkManager;
    protected final Map<Node, String> editorLinks = new ConcurrentHashMap<Node, String>();
    protected final DocumentUpdateActivityHandler updateHandler;

    public OnlyofficeDocumentEditorPlugin(OnlyofficeEditorService editorService, ResourceBundleService i18nService, CometdOnlyofficeService cometdService, LinkManager linkManager) {
        this.editorService = editorService;
        this.i18nService = i18nService;
        this.cometdService = cometdService;
        this.linkManager = linkManager;
        this.updateHandler = new OnlyOfficeDocumentUpdateActivityHandler();
    }

    public String getProviderName() {
        return PROVIDER_NAME;
    }

    public void onDocumentCreated(String workspace, String path) throws Exception {
        Node document = this.editorService.getDocument(workspace, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening editor page for document {}", new Object[]{document});
        }
        String link = "'" + this.contextEditorLink(document, DRIVES, null) + "'";
        OnlyofficeContext.callModule("initEditorPage(" + link + ");");
    }

    public void beforeDocumentCreate(NewDocumentTemplate template, String parentPath, String title) throws Exception {
        OnlyofficeContext.callModule("initNewDocument();");
    }

    public void initActivity(String uuid, String workspace, String activityId) throws Exception {
        Node symlink = this.editorService.getDocumentById(workspace, uuid);
        Node node = this.editorService.getDocument(symlink.getSession().getWorkspace().getName(), symlink.getPath());
        if (node != null && this.editorService.isDocumentMimeSupported(node)) {
            String fileId = this.editorService.initDocument(node);
            String link = "null";
            try {
                link = this.contextEditorLink(node, STREAM, null);
                link = "'" + link + "'";
            }
            catch (EditorLinkNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot get editor link for activity: ", new Object[]{e.getMessage()});
                }
            }
            catch (OnlyofficeEditorException e) {
                LOG.warn((Object)"Cannot get editor link for activity: ", (Throwable)e);
            }
            OnlyofficeContext.callModule("initActivity('" + fileId + "', " + link + ", '" + activityId + "');");
        }
    }

    public EditorSetting initPreview(String fileId, String workspace, URI requestUri, Locale locale) {
        block9: {
            try {
                String userId = ConversationState.getCurrent().getIdentity().getUserId();
                Node symlink = this.editorService.getDocumentById(workspace, fileId);
                Node node = this.editorService.getDocument(symlink.getSession().getWorkspace().getName(), symlink.getPath());
                if (node == null || !this.editorService.isDocumentMimeSupported(node)) break block9;
                if (symlink.isNodeType("exo:symlink")) {
                    this.editorService.addFilePreferences(node, userId, symlink.getPath());
                }
                String documentId = this.editorService.initDocument(node);
                String link = null;
                EditorError error = null;
                try {
                    link = this.contextEditorLink(node, PREVIEW, requestUri);
                }
                catch (EditorLinkNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot get editor link for preview: {}", new Object[]{e.getMessage()});
                    }
                    error = new EditorError(EDITOR_LINK_NOT_FOUND_ERROR, EDITOR_LINK_NOT_FOUND_ERROR_MESSAGE);
                }
                catch (OnlyofficeEditorException e) {
                    LOG.error((Object)"Cannot get editor link for preview: ", (Throwable)e);
                    error = new EditorError(INTERNAL_EDITOR_ERROR, INTERNAL_EDITOR_ERROR_MESSAGE);
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"Cannot get editor link for preview: ", (Throwable)e);
                    error = new EditorError(STORAGE_ERROR, STORAGE_ERROR_MESSAGE);
                }
                Map<String, String> messages = this.initMessages(locale);
                CometdConfig cometdConf = new CometdConfig(this.cometdService.getCometdServerPath(), this.cometdService.getUserToken(userId), PortalContainer.getCurrentPortalContainerName());
                return new EditorSetting(documentId, link, userId, cometdConf, messages, error);
            }
            catch (OnlyofficeEditorException e) {
                LOG.error("Cannot initialize preview for fileId: {}, workspace: {}. {}", new Object[]{fileId, workspace, e.getMessage()});
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot initialize preview", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isDocumentSupported(String fileId, String workspace) {
        try {
            Node node = this.editorService.getDocumentById(workspace, fileId);
            return this.editorService.canEditDocument(node);
        }
        catch (RepositoryException | DocumentNotFoundException e) {
            LOG.error((Object)"Cannot check if the file is supported", e);
            return false;
        }
    }

    public DocumentUpdateActivityHandler getDocumentUpdateHandler() {
        return this.updateHandler;
    }

    public void onLastEditorClosed(String fileId, String workspace) {
    }

    public long getEditingFinishedDelay() {
        return 10000L;
    }

    private String contextEditorLink(Node node, String context, URI requestURI) throws OnlyofficeEditorException, RepositoryException {
        String link;
        if (requestURI != null) {
            link = this.editorService.getEditorLink(node, requestURI.getScheme(), requestURI.getHost(), requestURI.getPort());
        } else {
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            if (pcontext != null) {
                link = this.editorService.getEditorLink(node, pcontext.getRequest().getScheme(), pcontext.getRequest().getServerName(), pcontext.getRequest().getServerPort());
            } else {
                throw new OnlyofficeEditorException("Cannot get editor link - request URI and PortalRequestContext are null");
            }
        }
        this.editorLinks.putIfAbsent(node, link);
        return this.editorLink(link, context);
    }

    private String editorLink(String link, String source) {
        StringBuilder linkBuilder = new StringBuilder(link).append("&source=").append(source);
        return linkBuilder.toString();
    }

    private Map<String, String> initMessages(Locale locale) {
        ResourceBundle res = this.i18nService.getResourceBundle("locale.onlyoffice.OnlyofficeClient", locale);
        HashMap<String, String> messages = new HashMap<String, String>();
        Enumeration<String> keys = res.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String bundleKey = key.startsWith(CLIENT_RESOURCE_PREFIX) ? key.substring(CLIENT_RESOURCE_PREFIX.length()) : key;
            messages.put(bundleKey, res.getString(key));
        }
        return messages;
    }

    public static class EditorError {
        private final String type;
        private final String message;

        public EditorError(String type, String message) {
            this.type = type;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getType() {
            return this.type;
        }
    }

    protected static class EditorSetting {
        private final String fileId;
        private final String link;
        private final String userId;
        private final CometdConfig cometdConf;
        private final Map<String, String> messages;
        private final EditorError error;

        public EditorSetting(String fileId, String link, String userId, CometdConfig cometdConf, Map<String, String> messages, EditorError error) {
            this.fileId = fileId;
            this.link = link;
            this.userId = userId;
            this.cometdConf = cometdConf;
            this.messages = messages;
            this.error = error;
        }

        public String getFileId() {
            return this.fileId;
        }

        public String getLink() {
            return this.link;
        }

        public String getUserId() {
            return this.userId;
        }

        public CometdConfig getCometdConf() {
            return this.cometdConf;
        }

        public Map<String, String> getMessages() {
            return this.messages;
        }

        public EditorError getError() {
            return this.error;
        }
    }
}

