/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.cometd.CometdInfo;
import org.exoplatform.onlyoffice.cometd.CometdOnlyofficeService;
import org.exoplatform.onlyoffice.webui.OnlyofficeClientContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/plugin/space/FileUIActivity.gtmpl", events={@EventConfig(listeners={FileUIActivity.ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={FileUIActivity.OpenFileActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditCommentActionListener.class})})})
public class FileUIActivity
extends org.exoplatform.wcm.ext.component.activity.FileUIActivity {
    private static final Log LOG = ExoLogger.getLogger(FileUIActivity.class);
    protected final OnlyofficeEditorService editorService = (OnlyofficeEditorService)this.getApplicationComponent(OnlyofficeEditorService.class);

    public void end() throws Exception {
        Node node;
        CometdOnlyofficeService cometdService = (CometdOnlyofficeService)this.getApplicationComponent(CometdOnlyofficeService.class);
        String userId = Utils.getViewerIdentity().getId();
        CometdInfo cometdInfo = new CometdInfo();
        cometdInfo.setUser(userId);
        cometdInfo.setCometdPath(cometdService.getCometdServerPath());
        cometdInfo.setUserToken(cometdService.getUserToken(userId));
        cometdInfo.setContainer(PortalContainer.getCurrentPortalContainerName());
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        HashMap<Node, String> editorLinks = new HashMap<Node, String>();
        if (this.getFilesCount() == 1 && (node = this.getContentNode(0)) != null) {
            editorLinks.computeIfAbsent(node, n -> {
                try {
                    return this.editorService.getEditorLink((Node)n);
                }
                catch (RepositoryException | OnlyofficeEditorException e) {
                    LOG.error((Object)e);
                    return null;
                }
            });
            String editorLink = (String)editorLinks.get(node);
            cometdInfo.setDocId(node.getUUID());
            String cometdInfoJson = ow.writeValueAsString((Object)cometdInfo);
            OnlyofficeClientContext.callModule("initActivity(" + cometdInfoJson + ", '" + this.getActivity().getId() + "','" + editorLink + "');");
        }
        for (int index = 0; index < this.getFilesCount(); ++index) {
            Node node2 = this.getContentNode(index);
            if (node2 == null) continue;
            editorLinks.computeIfAbsent(node2, n -> {
                try {
                    return this.editorService.getEditorLink((Node)n);
                }
                catch (RepositoryException | OnlyofficeEditorException e) {
                    LOG.error((Object)e);
                    return null;
                }
            });
            String editorLink = (String)editorLinks.get(node2);
            cometdInfo.setDocId(node2.getUUID());
            String cometdInfoJson = ow.writeValueAsString((Object)cometdInfo);
            OnlyofficeClientContext.callModule("initPreview(" + cometdInfoJson + ", '" + this.getActivity().getId() + "','" + editorLink + "','" + index + "');");
        }
        super.end();
    }
}

