/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.documents;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.onlyoffice.documents.OnlyofficeDocumentEditorPlugin;
import org.exoplatform.services.cms.documents.DocumentEditor;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.documents.NewDocumentTemplatePlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OnlyofficeNewDocumentTemplatePlugin
extends BaseComponentPlugin
implements NewDocumentTemplatePlugin {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeNewDocumentTemplatePlugin.class);
    private static final String DOCUMENT_TEMPLATES_CONFIGURATION = "document-templates-configuration";
    protected List<NewDocumentTemplate> templates = Collections.emptyList();
    protected final DocumentService documentService;

    public OnlyofficeNewDocumentTemplatePlugin(DocumentService documentService, InitParams initParams) {
        ObjectParameter typesParam = initParams.getObjectParam(DOCUMENT_TEMPLATES_CONFIGURATION);
        if (typesParam != null) {
            Object obj = typesParam.getObject();
            if (obj != null && DocumentService.DocumentTemplatesConfig.class.isAssignableFrom(obj.getClass())) {
                DocumentService.DocumentTemplatesConfig config = (DocumentService.DocumentTemplatesConfig)DocumentService.DocumentTemplatesConfig.class.cast(obj);
                this.templates = config.getTemplates().stream().map(NewDocumentTemplate::new).collect(Collectors.toList());
            } else {
                LOG.error((Object)"The document templates are not set");
            }
        }
        this.documentService = documentService;
    }

    public List<NewDocumentTemplate> getTemplates() {
        return this.templates;
    }

    public Node createDocument(Node parent, String title, NewDocumentTemplate template) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new document {} from template {}", new Object[]{title, template});
        }
        return this.documentService.createDocumentFromTemplate(parent, title, template);
    }

    public NewDocumentTemplate getTemplate(String name) {
        return this.templates.stream().filter(t -> t.getName().equals(name)).findAny().orElse(null);
    }

    public Class<? extends DocumentEditor> getEditorClass() {
        return OnlyofficeDocumentEditorPlugin.class;
    }
}

