/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.jcr;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.onlyoffice.jcr.NodeFinder;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.impl.NodeFinderImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class CMSNodeFinder
extends NodeFinderImpl
implements NodeFinder {
    protected final SessionProviderService sessionProviderService;
    protected final NodeHierarchyCreator hierarchyCreator;

    public CMSNodeFinder(RepositoryService repositoryService, LinkManager linkManager, SessionProviderService sessionProviderService, NodeHierarchyCreator hierarchyCreator) {
        super(repositoryService, linkManager);
        this.sessionProviderService = sessionProviderService;
        this.hierarchyCreator = hierarchyCreator;
    }

    @Override
    public String cleanName(String name) {
        int extIndex = name.lastIndexOf(46);
        StringBuilder jcrName = new StringBuilder();
        if (extIndex >= 0 && extIndex < name.length() - 1) {
            jcrName.append(Text.escapeIllegalJcrChars((String)Utils.cleanString((String)name.substring(0, extIndex))));
            String extName = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)name.substring(extIndex + 1)));
            jcrName.append('.').append(extName).toString();
        } else {
            jcrName.append(Text.escapeIllegalJcrChars((String)Utils.cleanString((String)name)));
        }
        return jcrName.toString();
    }

    @Override
    public Item findItem(Session session, String absPath) throws PathNotFoundException, RepositoryException {
        return this.getItem(session, absPath, true);
    }

    @Override
    public Collection<Node> findLinked(Session session, String uuid) throws PathNotFoundException, RepositoryException {
        LinkedHashSet<Node> res = new LinkedHashSet<Node>();
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query q = qm.createQuery("SELECT * FROM exo:symlink WHERE exo:uuid='" + uuid + "'", "sql");
            QueryResult qr = q.execute();
            NodeIterator niter = qr.getNodes();
            while (niter.hasNext()) {
                res.add(niter.nextNode());
            }
        }
        catch (AccessDeniedException | ItemNotFoundException throwable) {
            // empty catch block
        }
        return res;
    }

    @Override
    public Node getUserNode(String userName) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Node userNode = this.hierarchyCreator.getUserNode(sessionProvider, userName);
        return userNode;
    }
}

