/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.test;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.test.OnlyofficeMockHttpServletRequest;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.tools.DummyContainerResponseWriter;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/test/exo-onlyoffice-editor-services-test-configuration.xml")})
public class AbstractResourceTest
extends BaseCommonsTestCase {
    protected RequestHandlerImpl requestHandler;
    protected SessionProviderService sessionProviderService;
    protected SessionProvider sessionProvider;
    protected Session session;
    protected OnlyofficeEditorService onlyofficeEditorService;
    protected RepositoryService jcrService;

    protected void beforeClass() {
        super.beforeClass();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        this.sessionProviderService = (SessionProviderService)this.getContainer().getComponentInstanceOfType(SessionProviderService.class);
        this.container = PortalContainer.getInstance();
        this.requestHandler = (RequestHandlerImpl)this.getContainer().getComponentInstanceOfType(RequestHandlerImpl.class);
        this.jcrService = (RepositoryService)this.getContainer().getComponentInstanceOfType(RepositoryService.class);
        this.onlyofficeEditorService = (OnlyofficeEditorService)this.getContainer().getComponentInstanceOfType(OnlyofficeEditorService.class);
    }

    protected ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data) throws Exception {
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        ByteArrayInputStream in = null;
        if (data != null) {
            in = new ByteArrayInputStream(data);
        }
        EnvironmentContext envctx = new EnvironmentContext();
        OnlyofficeMockHttpServletRequest httpRequest = new OnlyofficeMockHttpServletRequest("", in, in != null ? in.available() : 0, method, (Map<String, List<String>>)headers);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        EnvironmentContext.setCurrent((EnvironmentContext)envctx);
        ContainerRequest request = new ContainerRequest(method, new URI(requestURI), new URI(baseURI), (InputStream)in, (MultivaluedMap)new InputHeadersMap((Map)headers));
        ContainerResponse response = new ContainerResponse((ContainerResponseWriter)new DummyContainerResponseWriter());
        this.requestHandler.handleRequest((GenericContainerRequest)request, (GenericContainerResponse)response);
        return response;
    }

    protected void startSessionAs(String user) throws RepositoryException {
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/administrators"));
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        this.sessionProviderService.setSessionProvider(null, new SessionProvider(state));
        this.sessionProvider = this.sessionProviderService.getSessionProvider(null);
        this.session = this.sessionProvider.getSession("portal-test", SessionProviderService.getRepository());
    }

    protected String createTestDocument(String user, String title, String content) throws Exception {
        Node node = this.session.getRootNode().addNode(title, "nt:file");
        Node contentNode = node.addNode("jcr:content", "nt:unstructured");
        contentNode.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.text");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNode.setProperty("jcr:data", content);
        this.session.save();
        String docId = this.onlyofficeEditorService.initDocument(node);
        Config config = this.onlyofficeEditorService.createEditor("http", "localhost", 8080, user, null, docId);
        return config != null ? config.getDocument().getKey() : null;
    }
}

