/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.onlyoffice.test.AbstractResourceTest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.junit.Test;

public class EditorServiceTest
extends AbstractResourceTest {
    protected static final Log LOG = ExoLogger.getLogger(EditorServiceTest.class);
    protected static final String RESOURCE_URL = "/onlyoffice/editor";
    protected static final String USER = "john";
    protected static final String SECRET_KEY = "1fRW5pBZu3UIBEdebbpDpKJ4hwExSQoSe97tw8gyYNhqnM1biHb";
    protected static final String WRONG_SECRET_KEY = "WRONG-SECRET-KEY-94037466gKfv37jvfdG43";
    protected String key;
    protected Map<String, Object> contentPayload = new HashMap<String, Object>();
    protected Map<String, Object> statusPayload = new HashMap<String, Object>();
    protected String statusPayloadJson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeClass() {
        super.beforeClass();
        if (this.key == null) {
            try {
                this.startSessionAs(USER);
                ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
                String containerName = PortalContainer.getCurrentPortalContainerName();
                try {
                    ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)containerName);
                    ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                    RequestLifeCycle.begin((ExoContainer)exoContainer);
                    LOG.info("Life cycle of {} container started.", new Object[]{containerName});
                    this.key = this.createTestDocument(USER, "abc.docx", "Testing Content");
                    this.contentPayload.put("key", this.key);
                    this.statusPayload.put("key", this.key);
                    this.statusPayload.put("satus", 1);
                    this.statusPayload.put("url", "localhost");
                    this.statusPayload.put("error", 0);
                    this.statusPayloadJson = "{ \"key\": \"" + this.key + "\", \"status\": 1, \"url\": \"localhost\", \"error\": 0 }";
                }
                catch (Throwable throwable) {
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
                    LOG.info("Life cycle of {} container ended.", new Object[]{containerName});
                    throw throwable;
                }
                RequestLifeCycle.end();
                ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
                LOG.info("Life cycle of {} container ended.", new Object[]{containerName});
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot prepare status payload", (Throwable)e);
            }
        }
    }

    @Test
    public void testContent() throws Exception {
        String token = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", this.contentPayload).signWith((Key)Keys.hmacShaKeyFor((byte[])SECRET_KEY.getBytes())).compact();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"authorization", (Object)("Bearer " + token));
        ContainerResponse response = this.service("GET", "/onlyoffice/editor/content/john/" + this.key, "", (Map<String, List<String>>)headers, null);
        String content = IOUtils.toString((InputStream)((InputStream)response.getEntity()), (String)StandardCharsets.UTF_8.name());
        EditorServiceTest.assertNotNull((Object)response);
        EditorServiceTest.assertEquals((int)200, (int)response.getStatus());
        EditorServiceTest.assertEquals((String)"Testing Content", (String)content);
    }

    @Test
    public void testContentWrongToken() throws Exception {
        String token = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", this.contentPayload).signWith((Key)Keys.hmacShaKeyFor((byte[])WRONG_SECRET_KEY.getBytes())).compact();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"authorization", (Object)("Bearer " + token));
        ContainerResponse response = this.service("GET", "/onlyoffice/editor/content/john/" + this.key, "", (Map<String, List<String>>)headers, null);
        EditorServiceTest.assertNotNull((Object)response);
        EditorServiceTest.assertEquals((int)401, (int)response.getStatus());
        EditorServiceTest.assertEquals((Object)"{\"error\":\"The token is not valid\"}", (Object)response.getEntity());
    }

    @Test
    public void testContentNoToken() throws Exception {
        ContainerResponse response = this.service("GET", "/onlyoffice/editor/content/john/" + this.key, "", null, null);
        EditorServiceTest.assertNotNull((Object)response);
        EditorServiceTest.assertEquals((int)401, (int)response.getStatus());
        EditorServiceTest.assertEquals((Object)"{\"error\":\"The token is not valid\"}", (Object)response.getEntity());
    }

    @Test
    public void testStatus() throws Exception {
        String token = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", this.statusPayload).signWith((Key)Keys.hmacShaKeyFor((byte[])SECRET_KEY.getBytes())).compact();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"authorization", (Object)("Bearer " + token));
        ContainerResponse response = this.service("POST", "/onlyoffice/editor/status/john/" + this.key, "", (Map<String, List<String>>)headers, this.statusPayloadJson.getBytes());
        EditorServiceTest.assertNotNull((Object)response);
        EditorServiceTest.assertEquals((int)200, (int)response.getStatus());
        EditorServiceTest.assertEquals((Object)"{\"error\": 0}", (Object)response.getEntity());
    }

    @Test
    public void testStatusWrongToken() throws Exception {
        String token = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", this.statusPayload).signWith((Key)Keys.hmacShaKeyFor((byte[])WRONG_SECRET_KEY.getBytes())).compact();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"authorization", (Object)("Bearer " + token));
        ContainerResponse response = this.service("POST", "/onlyoffice/editor/status/john/" + this.key, "", (Map<String, List<String>>)headers, this.statusPayloadJson.getBytes());
        EditorServiceTest.assertNotNull((Object)response);
        EditorServiceTest.assertEquals((int)401, (int)response.getStatus());
        EditorServiceTest.assertEquals((Object)"{\"error\":\"The token is not valid\"}", (Object)response.getEntity());
    }

    @Test
    public void testStatusNoToken() throws Exception {
        ContainerResponse response = this.service("POST", "/onlyoffice/editor/status/john/" + this.key, "", null, this.statusPayloadJson.getBytes());
        EditorServiceTest.assertNotNull((Object)response);
        EditorServiceTest.assertEquals((int)401, (int)response.getStatus());
        EditorServiceTest.assertEquals((Object)"{\"error\":\"The token is not valid\"}", (Object)response.getEntity());
    }
}

