/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class ServiceResponse {
    Response.Status status;
    Object entity;
    String type;
    Map<String, String> headers = new HashMap<String, String>();
    List<NewCookie> cookies = new ArrayList<NewCookie>();

    ServiceResponse status(Response.Status status) {
        this.status = status;
        return this;
    }

    ServiceResponse ok() {
        this.status = Response.Status.OK;
        return this;
    }

    ServiceResponse type(String type) {
        this.type = type;
        return this;
    }

    ServiceResponse clientError(Object entity) {
        this.status = Response.Status.BAD_REQUEST;
        this.entity = entity;
        return this;
    }

    ServiceResponse error(Object entity) {
        this.status = Response.Status.INTERNAL_SERVER_ERROR;
        this.entity = entity;
        return this;
    }

    ServiceResponse entity(Object entity) {
        this.entity = entity;
        return this;
    }

    ServiceResponse addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    ServiceResponse cookie(NewCookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    ServiceResponse cookie(String name, String value, String path, String domain, String comment, int maxAge, boolean secure) {
        this.cookies.add(new NewCookie(name, value, path, domain, comment, maxAge, secure));
        return this;
    }

    Response build() {
        Response.ResponseBuilder builder = Response.status((Response.Status)(this.status != null ? this.status : Response.Status.OK));
        if (this.entity != null) {
            builder.entity(this.entity);
        }
        if (this.cookies.size() > 0) {
            builder.cookie(this.cookies.toArray(new NewCookie[this.cookies.size()]));
        }
        for (Map.Entry<String, String> he : this.headers.entrySet()) {
            builder.header(he.getKey(), (Object)he.getValue());
        }
        if (this.type != null) {
            builder.type(this.type);
        }
        return builder.build();
    }
}

