/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.portlet;

import java.io.IOException;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;

public class EditorPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(EditorPortlet.class);
    private OnlyofficeEditorService onlyoffice;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.onlyoffice = (OnlyofficeEditorService)container.getComponentInstanceOfType(OnlyofficeEditorService.class);
    }

    @RenderMode(name="view")
    public void view(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        block10: {
            RequestContext rqContext = WebuiRequestContext.getCurrentInstance();
            RequireJS js = ((WebuiRequestContext)rqContext).getJavascriptManager().require("SHARED/onlyoffice", "onlyoffice");
            String docId = rqContext.getRequestParameter("docId");
            if (docId != null) {
                try {
                    Config config = this.onlyoffice.createEditor(request.getScheme(), this.requestHost((PortletRequest)request), request.getRemoteUser(), null, docId);
                    if (config != null) {
                        if (config.getEditorConfig().getLang() == null) {
                            if (request.getLocale() != null) {
                                config.getEditorConfig().setLang(request.getLocale().getLanguage());
                            } else {
                                config.getEditorConfig().setLang(Locale.getDefault().getLanguage());
                            }
                        }
                        js.addScripts("onlyoffice.initEditor(" + config.toJSON() + ");");
                        break block10;
                    }
                    js.addScripts("onlyoffice.showError('Error','Editor cannot be created. Please retry.');");
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading document node by ID: " + docId), (Throwable)e);
                    js.addScripts("onlyoffice.showError('Error','Cannot read the document. Please retry.');");
                }
                catch (OnlyofficeEditorException e) {
                    e.printStackTrace();
                }
                catch (JsonException e) {
                    e.printStackTrace();
                }
            } else {
                js.addScripts("onlyoffice.showError('Error','Wrong request: document ID required.');");
            }
        }
        PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/pages/editor.jsp");
        prDispatcher.include(request, response);
    }

    protected String requestHost(PortletRequest request) {
        StringBuilder host = new StringBuilder(request.getServerName());
        int port = request.getServerPort();
        if (port >= 0 && port != 80 && port != 443) {
            host.append(':');
            host.append(port);
        }
        return host.toString();
    }
}

