/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.portlet;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.webui.OnlyofficeClientContext;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;

public class EditorPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(EditorPortlet.class);
    private OnlyofficeEditorService onlyoffice;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.onlyoffice = (OnlyofficeEditorService)container.getComponentInstanceOfType(OnlyofficeEditorService.class);
    }

    @RenderMode(name="view")
    public void view(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle i18n = webuiContext.getApplicationResourceBundle();
        String docId = webuiContext.getRequestParameter("docId");
        if (docId != null) {
            try {
                Config config = this.onlyoffice.createEditor(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRemoteUser(), null, docId);
                if (config != null) {
                    if (config.getEditorConfig().getLang() == null) {
                        if (request.getLocale() != null) {
                            config.getEditorConfig().setLang(request.getLocale().getLanguage());
                        } else {
                            config.getEditorConfig().setLang(Locale.getDefault().getLanguage());
                        }
                    }
                    OnlyofficeClientContext.callModule((String)("initEditor(" + config.toJSON() + ");"));
                } else {
                    OnlyofficeClientContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.EditorCannotBeCreated"));
                }
                try {
                    ListenerService listenerService = (ListenerService)webuiContext.getApplication().getApplicationServiceContainer().getComponentInstanceOfType(ListenerService.class);
                    listenerService.broadcast("exo.onlyoffice.editor.open", (Object)this.onlyoffice, (Object)config);
                }
                catch (Exception e) {
                    LOG.error("Error firing listener with Onlyoffice event for user: {}, document: {}", new Object[]{request.getRemoteUser(), docId, e});
                }
            }
            catch (RepositoryException e) {
                LOG.error("Error reading document node by ID: {}", new Object[]{docId, e});
                OnlyofficeClientContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotReadDocument"));
            }
            catch (OnlyofficeEditorException e) {
                LOG.error("Error creating document editor for node by ID: {}", new Object[]{docId, e});
                OnlyofficeClientContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotCreateEditor"));
            }
            catch (JsonException e) {
                LOG.error("Error converting editor configuration to JSON for node by ID: {}", new Object[]{docId, e});
                OnlyofficeClientContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotSendEditorConfiguration"));
            }
        } else {
            OnlyofficeClientContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.DocumentIdRequired"));
        }
        PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/pages/editor.jsp");
        prDispatcher.include(request, response);
    }

    protected String requestHost(PortletRequest request) {
        StringBuilder host = new StringBuilder(request.getServerName());
        int port = request.getServerPort();
        if (port >= 0 && port != 80 && port != 443) {
            host.append(':');
            host.append(port);
        }
        return host.toString();
    }
}

