/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MODApplet
extends Applet {
    public static String DIALOG_TITLE = "IT Hit Ajax File Browser";
    public static String NEW_LINE = System.getProperty("line.separator");
    private FileSystemOperations fileOpener;
    private URL urlMount;

    @Override
    public void init() {
        String string = this.getParameter("file");
        String string2 = this.getParameter("folder");
        String string3 = this.getParameter("mountUrl");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (string3 == null) {
                throw new Exception("'mountUrl' parameter is missing.");
            }
            this.validate(string, string2);
            if (!string3.toLowerCase().startsWith("http")) {
                URL uRL = new URL(string != null ? string : string2);
                this.urlMount = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3);
            } else {
                this.urlMount = new URL(string3);
            }
            this.fileOpener = FileSystemOperations.Create(this.urlMount);
        }
        catch (Exception exception) {
            this.showFailDialog(exception);
        }
        this.open(string, string2);
    }

    public void open(final String string, final String string2) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MODApplet.this.validate(string, string2);
                    if (string == null) {
                        MODApplet.this.fileOpener.OpenFolder(new URL(string2));
                    } else if (MODApplet.this.isOpenConfirmed(MODApplet.this.getFilenameFromPath(string))) {
                        MODApplet.this.fileOpener.OpenDocument(new URL(string));
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.showFailDialog(exception);
        }
    }

    private boolean isOpenConfirmed(String string) {
        int n = JOptionPane.showConfirmDialog(null, "Some files can harm your computer. If the file information looks" + NEW_LINE + "suspicious or you do not fully trust the source, do not open the file." + NEW_LINE + NEW_LINE + "You are opening the following file:" + NEW_LINE + NEW_LINE + "File name: " + string + NEW_LINE + "From location: " + this.urlMount + NEW_LINE, "File Download", 2, 3);
        return n == 0;
    }

    private void validate(String string, String string2) {
        if (string == null && string2 == null) {
            throw new RuntimeException("'file' or 'folder' parameter is missing.");
        }
    }

    private void showFailDialog(Exception exception) {
        JOptionPane.showMessageDialog(this, exception.toString(), DIALOG_TITLE, 0);
    }

    private String getFilenameFromPath(String string) {
        if (string == null) {
            throw new RuntimeException("Path can't be empty");
        }
        return new File(string).getName();
    }
}

