/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.social;

import javax.jcr.Node;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;

public class OutlookActivitySupport {
    protected static final Log LOG = ExoLogger.getLogger(OutlookActivitySupport.class);
    public static final String CONTEXT_INITIALIZED = "outlookView_initialized";
    protected final DocumentService documentService;
    protected final ManageableRepository repository;

    protected OutlookActivitySupport(DocumentService documentService, ManageableRepository repository) {
        this.repository = repository;
        this.documentService = documentService;
    }

    String getDocOpenUri(Node node) {
        String uri;
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String nodePath = nodeLocation.getPath();
        try {
            DriveData docDrive = this.documentService.getDriveOfNode(nodePath);
            uri = this.documentService.getLinkInDocumentsApp(nodePath, docDrive);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get document open URI of node " + nodePath + " : " + e.getMessage()), (Throwable)e);
            uri = "";
        }
        return uri;
    }

    public String getActivityStatus(ExoSocialActivity activity) {
        String message = (String)activity.getTemplateParams().get("message");
        if (message == null) {
            return (String)activity.getTemplateParams().get("MESSAGE");
        }
        return null;
    }

    public String getPreviewLink(WebuiBindingContext ctx, BaseUIActivity uiActivity, Node node) throws Exception {
        String[] displayedIdentityLikes;
        Identity ownerIdentity = uiActivity.getOwnerIdentity();
        String docDownloadUrl = Utils.getDownloadLink((Node)node);
        String docOpenUri = this.getDocOpenUri(node);
        String ownerName = ownerIdentity.getProfile().getFullName();
        String escapedOwnerName = ownerName.replace("'", "\\'").replace("&#39;", "\\&#39;");
        ExoSocialActivity activity = uiActivity.getActivity();
        String activityPostedTime = uiActivity.getPostedTimeString(ctx, activity.getPostedTime().longValue());
        String escapedActivityPostedTime = activityPostedTime.replace("'", "\\'").replace("&#39;", "\\&#39;");
        String activityStatus = this.getActivityStatus(activity);
        String escapedActivityStatus = activityStatus != null ? StringEscapeUtils.escapeHtml((String)activityStatus.replace("'", "\\'").replace("&#39;", "\\&#39;").replace("\n", "").replace("\r", "")) : "";
        String ownerUri = LinkProvider.getUserProfileUri((String)ownerIdentity.getRemoteId());
        String ownerAvatar = ownerIdentity.getProfile().getAvatarUrl();
        if (ownerAvatar == null || ownerAvatar.length() == 0) {
            ownerAvatar = "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png";
        }
        int identityLikesNum = (displayedIdentityLikes = uiActivity.getDisplayedIdentityLikes()) != null ? displayedIdentityLikes.length : 0;
        String docPreviewUri = "javascript:require(['SHARED/social-ui-activity'], function(activity) {activity.previewDoc(event, {doc: {id:'" + node.getUUID() + "', repository:'" + this.repository.getConfiguration().getName() + "', workspace:'" + node.getSession().getWorkspace().getName() + "', path:'" + node.getPath() + "', title:'" + node.getName() + "', downloadUrl:'" + docDownloadUrl + "', openUrl:'" + docOpenUri + "'}, author: {username:'" + ownerIdentity.getRemoteId() + "', fullname:'" + escapedOwnerName + "', avatarUrl:'" + ownerAvatar + "', profileUrl:'" + ownerUri + "'}, activity: {id: '" + activity.getId() + "', postTime:'" + escapedActivityPostedTime + "', status: '" + escapedActivityStatus + "', liked: " + uiActivity.isLiked() + ", likes: " + identityLikesNum + "}})})";
        return docPreviewUri;
    }
}

