/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.social;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.outlook.social.OutlookActivitySupport;
import org.exoplatform.outlook.social.OutlookMessagePresentation;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/templates/OutlookAttachmentActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})})
public class OutlookAttachmentActivity
extends BaseUIActivity {
    public static final String ACTIVITY_TYPE = "outlook:attachment";
    public static final String COMMENT = "comment";
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "workspace";
    public static final String FILES = "files";
    public static final String AUTHOR = "author";
    public static final String DATE_CREATED = "dateCreated";
    public static final String DATE_LAST_MODIFIED = "lastModified";
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm";
    protected static final Log LOG = ExoLogger.getLogger(OutlookAttachmentActivity.class);
    protected List<Attachment> files;
    protected ManageableRepository repository;
    protected DocumentService documentService;
    protected final OutlookActivitySupport util;

    public OutlookAttachmentActivity() throws Exception {
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        this.repository = repositoryService.getCurrentRepository();
        this.documentService = (DocumentService)CommonsUtils.getService(DocumentService.class);
        this.util = new OutlookActivitySupport(this.documentService, this.repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Attachment> getFiles() throws RepositoryException, RepositoryConfigurationException {
        if (this.files != null) return Collections.unmodifiableList(this.files);
        OutlookAttachmentActivity outlookAttachmentActivity = this;
        synchronized (outlookAttachmentActivity) {
            if (this.files != null) return Collections.unmodifiableList(this.files);
            ExoSocialActivity activity = this.getActivity();
            if (activity == null) throw new IllegalArgumentException("Activity not set");
            String filesLine = (String)activity.getTemplateParams().get(FILES);
            if (filesLine == null || filesLine.length() <= 0) throw new IllegalArgumentException("Activity files empty");
            ArrayList<Attachment> files = new ArrayList<Attachment>();
            for (String fline : filesLine.split(",")) {
                files.add(this.parseAttachment(fline));
            }
            this.files = files;
            return Collections.unmodifiableList(this.files);
        }
    }

    public void renderAttachmentPresentation(Node node) throws Exception {
        OutlookMessagePresentation uicontentpresentation = (OutlookMessagePresentation)this.addChild(OutlookMessagePresentation.class, null, null);
        uicontentpresentation.setNode(node);
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        UIComponent fileComponent = uicontentpresentation.getUIComponent(mimeType);
        uicontentpresentation.renderUIComponent(fileComponent);
    }

    public String[] getSystemCommentBundle(Map<String, String> activityParams) {
        return org.exoplatform.wcm.ext.component.activity.listener.Utils.getSystemCommentBundle(activityParams);
    }

    public String[] getSystemCommentTitle(Map<String, String> activityParams) {
        return org.exoplatform.wcm.ext.component.activity.listener.Utils.getSystemCommentTitle(activityParams);
    }

    public String getWorkspace() {
        ExoSocialActivity activity = this.getActivity();
        if (activity != null) {
            return (String)activity.getTemplateParams().get(WORKSPACE);
        }
        throw new IllegalArgumentException("Activity not set");
    }

    public String getComment() {
        ExoSocialActivity activity = this.getActivity();
        if (activity != null) {
            return (String)activity.getTemplateParams().get(COMMENT);
        }
        throw new IllegalArgumentException("Activity not set");
    }

    public String toString() {
        ExoSocialActivity activity = this.getActivity();
        if (activity != null) {
            String title = activity.getTitle();
            return (title != null ? title : activity.getName()) + " (" + activity.getId() + ", " + activity.getPermaLink() + ' ' + ")";
        }
        return super.toString();
    }

    Attachment parseAttachment(String line) {
        String name;
        String fileUUID;
        int i = line.indexOf(61);
        if (i > 0) {
            fileUUID = line.substring(0, i);
            name = line.substring(++i);
        } else {
            fileUUID = line;
            name = null;
        }
        return new Attachment(fileUUID, name);
    }

    public static String attachmentString(String fileUUID, String name) {
        StringBuilder line = new StringBuilder();
        line.append(fileUUID);
        line.append('=');
        line.append(name);
        return line.toString();
    }

    public class Attachment {
        final String fileUUID;
        String name;
        ThreadLocal<Node> node = new ThreadLocal();

        protected Attachment(String fileUUID, String name) {
            this.fileUUID = fileUUID;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getFileUUID() {
            return this.fileUUID;
        }

        public String getTitle() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    return org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading node name " + node), (Throwable)e);
            }
            return this.getName();
        }

        public String getMimeType() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
                    if (mimeType.equals("application/rss+xml")) {
                        mimeType = "text/html";
                    }
                    return mimeType;
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error getting node mime type " + node), (Throwable)e);
            }
            return "";
        }

        public boolean isImage() throws Exception {
            String mimeType = this.getMimeType();
            return mimeType.startsWith("image") || mimeType.indexOf("icon") >= 0;
        }

        public String getSize() {
            Node node = null;
            try {
                node = this.node();
                if (node != null && node.hasNode("jcr:content")) {
                    Node contentNode = node.getNode("jcr:content");
                    double size = 0.0;
                    if (contentNode.hasProperty("jcr:data")) {
                        size = contentNode.getProperty("jcr:data").getLength();
                    }
                    return FileUtils.byteCountToDisplaySize((long)((long)size));
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error getting node mime type " + node), (Throwable)e);
            }
            return "";
        }

        public boolean isSupportPreview() throws Exception {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    UIExtensionManager manager = (UIExtensionManager)OutlookAttachmentActivity.this.getApplicationComponent(UIExtensionManager.class);
                    List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
                    HashMap<String, String> context = new HashMap<String, String>();
                    context.put("mimeType", node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                    context.put(Node.class.getName(), (String)node);
                    for (UIExtension extension : extensions) {
                        if (!manager.accept("org.exoplatform.ecm.dms.FileViewer", extension.getName(), context) || "Text".equals(extension.getName())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting node download link " + node), (Throwable)e);
            }
            return false;
        }

        public String getDownloadLink() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    return Utils.getDownloadLink((Node)node);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting node download link " + node), (Throwable)e);
            }
            return "";
        }

        public String getPdfThumbnailImageLink() throws RepositoryException, UnsupportedEncodingException {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    String portalName = PortalContainer.getCurrentPortalContainerName();
                    String restContextName = PortalContainer.getCurrentRestContextName();
                    String repositoryName = OutlookAttachmentActivity.this.repository.getConfiguration().getName();
                    String workspaceName = OutlookAttachmentActivity.this.getWorkspace();
                    String encodedPath = URLEncoder.encode(node.getPath(), "utf-8");
                    encodedPath = encodedPath.replaceAll("%2F", "/");
                    StringBuilder link = new StringBuilder();
                    link.append('/');
                    link.append(portalName);
                    link.append('/');
                    link.append(restContextName);
                    link.append("/thumbnailImage/big/");
                    link.append(repositoryName);
                    link.append('/');
                    link.append(workspaceName);
                    link.append(encodedPath);
                    return link.toString();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting node PDF thumbnail link " + node), (Throwable)e);
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getThumbnailImageLink() throws RepositoryException, UnsupportedEncodingException {
            block26: {
                Node node = null;
                try {
                    node = this.node();
                    if (node == null) break block26;
                    String portalName = PortalContainer.getCurrentPortalContainerName();
                    String restContextName = PortalContainer.getCurrentRestContextName();
                    String repositoryName = OutlookAttachmentActivity.this.repository.getConfiguration().getName();
                    String workspaceName = OutlookAttachmentActivity.this.getWorkspace();
                    String mimeType = this.getMimeType();
                    StringBuilder link = new StringBuilder();
                    link.append('/');
                    link.append(portalName);
                    link.append('/');
                    link.append(restContextName);
                    if (mimeType.indexOf("icon") >= 0) {
                        link.append("/jcr/");
                        link.append(repositoryName);
                        link.append('/');
                        link.append(workspaceName);
                        FriendlyService friendlyService = (FriendlyService)WCMCoreUtils.getService(FriendlyService.class);
                        if (node.isNodeType("nt:frozenNode")) {
                            String uuid = node.getProperty("jcr:frozenUuid").getString();
                            Node originalNode = node.getSession().getNodeByUUID(uuid);
                            link.append(originalNode.getPath());
                            link.append("?version=");
                            link.append(node.getParent().getName());
                        } else {
                            link.append(node.getPath());
                        }
                        return friendlyService.getFriendlyUri(link.toString());
                    }
                    String path = node.getPath();
                    try {
                        if (node.hasNode("jcr:content")) {
                            node = node.getNode("jcr:content");
                        }
                        ImageReader reader = null;
                        Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType(mimeType);
                        ImageInputStream iis = ImageIO.createImageInputStream(node.getProperty("jcr:data").getStream());
                        try {
                            reader = readers.next();
                            reader.setInput(iis, true);
                            int imageHeight = reader.getHeight(0);
                            int imageWidth = reader.getWidth(0);
                            int defaultDimension = 300;
                            if (imageHeight > imageWidth && imageHeight > 300) {
                                imageWidth = 300 * imageWidth / imageHeight;
                                imageHeight = 300;
                            } else if (imageWidth > imageHeight && imageWidth > 300) {
                                imageHeight = 300 * imageHeight / imageWidth;
                                imageWidth = 300;
                            } else if (imageWidth == imageHeight && imageHeight > 300) {
                                imageHeight = 300;
                                imageWidth = 300;
                            }
                            link.append("/thumbnailImage/custom/");
                            link.append(imageWidth);
                            link.append('x');
                            link.append(imageHeight);
                            link.append('/');
                        }
                        catch (NoSuchElementException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Cannot find image reader for node " + node), (Throwable)e);
                            }
                            link.append("/thumbnailImage/big/");
                        }
                        finally {
                            try {
                                iis.close();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Error closing image data stream of " + node), (Throwable)e);
                            }
                            if (reader != null) {
                                reader.dispose();
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Cannot read image node " + node + ":" + e.getMessage()));
                        link.append("/thumbnailImage/large/");
                    }
                    link.append(repositoryName);
                    link.append('/');
                    link.append(workspaceName);
                    String encodedPath = URLEncoder.encode(path, "utf-8");
                    encodedPath = encodedPath.replaceAll("%2F", "/");
                    link.append(encodedPath);
                    return link.toString();
                }
                catch (Exception e) {
                    LOG.error((Object)("Error getting node thumbnail link " + node), (Throwable)e);
                }
            }
            return "";
        }

        public String getOpenLink() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    return OutlookAttachmentActivity.this.util.getDocOpenUri(node);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting document open link " + node), (Throwable)e);
            }
            return "";
        }

        public String getPreviewLink(WebuiBindingContext ctx) {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    return OutlookAttachmentActivity.this.util.getPreviewLink(ctx, OutlookAttachmentActivity.this, node);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting document preview link " + node), (Throwable)e);
            }
            return "";
        }

        @Deprecated
        public String getViewLink() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    if (this.isSupportPreview()) {
                        return OutlookAttachmentActivity.this.event("ViewDocument", OutlookAttachmentActivity.this.getId(), this.fileUUID);
                    }
                    return Utils.getEditLink((Node)node, (boolean)false, (boolean)false);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting node view link " + node), (Throwable)e);
            }
            return "";
        }

        @Deprecated
        public String getLink() throws Exception {
            return this.isSupportPreview() ? this.getViewLink() : this.getDownloadLink();
        }

        public String getCssClassIcon() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)"uiIcon64x64");
                }
            }
            catch (Exception e) {
                return "uiIcon64x64Templatent_file uiIcon64x64nt_file";
            }
            return "";
        }

        public boolean isSupportThumbnailView() throws Exception {
            return org.exoplatform.services.cms.impl.Utils.isSupportThumbnailView((String)this.getMimeType());
        }

        public boolean isExists() throws RepositoryException {
            try {
                return this.node() != null;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        }

        public String getSummary() {
            Node node = null;
            try {
                node = this.node();
                if (node != null) {
                    return org.exoplatform.wcm.ext.component.activity.listener.Utils.getSummary((Node)node);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error getting node summary " + node), (Throwable)e);
            }
            return "";
        }

        public Node getNode() throws RepositoryException {
            return this.node();
        }

        protected Node node() throws RepositoryException {
            Node node = this.node.get();
            if (node != null) {
                try {
                    node.getIndex();
                }
                catch (AccessDeniedException | InvalidItemStateException e) {
                    node = null;
                }
            }
            if (node == null) {
                SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                Session session = sessionProvider.getSession(OutlookAttachmentActivity.this.getWorkspace(), OutlookAttachmentActivity.this.repository);
                try {
                    node = session.getNodeByUUID(this.fileUUID);
                    TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
                    if (trashService.isInTrash(node)) {
                        node = null;
                    } else {
                        this.node.set(node);
                    }
                }
                catch (AccessDeniedException | ItemNotFoundException throwable) {
                    // empty catch block
                }
            }
            return node;
        }

        public String getFullPath() throws RepositoryException {
            Node node = this.node();
            StringBuilder path = new StringBuilder();
            if (node != null) {
                path.append(node.getSession().getWorkspace().getName()).append(":").append(node.getPath()).toString();
            }
            return path.toString();
        }
    }
}

