/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.jcr;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.jcr.Folder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;

public abstract class HierarchyNode {
    public static final String MODIFIED_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String PATH_SEPARATOR;
    public static final String ROOT_PATH_LABEL;
    protected static final String EMPTY;
    protected static final Log LOG;
    protected final String parentPath;
    protected final String path;
    protected final String name;
    protected final String fullPath;
    protected final String title;
    protected String pathLabel;
    protected final String lastModifier;
    protected final Calendar lastModified;
    protected final Node node;
    protected final int hashCode;
    protected String url;
    protected String webdavUrl;

    public static boolean isFolder(Node node) throws RepositoryException {
        return node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured");
    }

    public static boolean isFile(Node node) throws RepositoryException {
        return node.isNodeType("nt:file");
    }

    protected HierarchyNode(String parentPath, Node node) throws RepositoryException, BadParameterException {
        this.path = node.getPath();
        this.fullPath = HierarchyNode.fullPath(node.getSession().getWorkspace().getName(), this.path);
        this.node = node;
        this.name = node.getName();
        if (parentPath == null) {
            throw new BadParameterException("Node  '" + this.name + "' should have root path or parent folder");
        }
        int hc = 1;
        hc = hc * 31 + this.path.hashCode();
        this.parentPath = parentPath;
        this.title = HierarchyNode.nodeTitle(node);
        this.pathLabel = this.path.equals(parentPath) ? ROOT_PATH_LABEL : HierarchyNode.pathLabel(parentPath, node);
        if (node.hasProperty("exo:lastModifier")) {
            String lastModifier = node.getProperty("exo:lastModifier").getString();
            if (IdentityConstants.SYSTEM.equals(lastModifier)) {
                lastModifier = "System";
            }
            this.lastModifier = lastModifier;
        } else {
            this.lastModifier = EMPTY;
        }
        if (node.hasProperty("exo:dateModified")) {
            this.lastModified = node.getProperty("exo:dateModified").getDate();
            hc = hc * 31 + this.lastModified.hashCode();
        } else {
            this.lastModified = null;
        }
        this.hashCode = hc;
    }

    protected HierarchyNode(Folder parent, Node node) throws RepositoryException, OutlookException {
        this(parent != null ? parent.getPath() : null, node);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().isAssignableFrom(obj.getClass())) {
            HierarchyNode other = (HierarchyNode)this.getClass().cast(obj);
            Node thisNode = this.getNode();
            Node otherNode = other.getNode();
            if (thisNode != null && otherNode != null) {
                try {
                    return thisNode.isSame((Item)otherNode);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            return this.getFullPath().equals(other.getFullPath());
        }
        return super.equals(obj);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getWebdavUrl() {
        return this.webdavUrl;
    }

    public void setWebdavUrl(String webdavUrl) {
        this.webdavUrl = webdavUrl;
    }

    public Node getNode() {
        return this.node;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPathLabel() {
        return this.pathLabel;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public String getLastModified() {
        if (this.lastModified != null) {
            Locale locale = this.userLocale();
            if (locale == null) {
                locale = Locale.getDefault();
                LOG.warn((Object)("OutlookUser locale not found, will use a default one " + locale));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(MODIFIED_FORMAT, locale);
            return dateFormat.format(this.lastModified.getTime());
        }
        return EMPTY;
    }

    protected static String nodeTitle(Node node) throws RepositoryException {
        String title = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : (node.hasProperty("exo:name") ? node.getProperty("exo:name").getString() : node.getName());
        return title;
    }

    protected static String pathLabel(String rootPath, Node node) throws RepositoryException {
        ArrayList<String> reversedSubpath = new ArrayList<String>();
        Node parent = node;
        while (!parent.getPath().equals(rootPath)) {
            reversedSubpath.add(HierarchyNode.nodeTitle(parent));
            parent = parent.getParent();
        }
        StringBuilder pathLabel = new StringBuilder();
        if (reversedSubpath.size() > 0) {
            for (int i = reversedSubpath.size() - 1; i >= 0; --i) {
                pathLabel.append(PATH_SEPARATOR);
                String plabel = (String)reversedSubpath.get(i);
                pathLabel.append(plabel);
            }
        } else {
            reversedSubpath.add(PATH_SEPARATOR);
        }
        return pathLabel.toString();
    }

    public static String fullPath(String workspace, String path) {
        return workspace + path;
    }

    public static String getPath(String fullPath) throws BadParameterException {
        if (fullPath.startsWith("/")) {
            return fullPath;
        }
        int i = fullPath.indexOf(47);
        if (i > 0) {
            return fullPath.substring(i);
        }
        throw new BadParameterException("Invalid path " + fullPath);
    }

    public static String getWorkspace(String fullPath) throws BadParameterException {
        if (fullPath.startsWith("/")) {
            return null;
        }
        int i = fullPath.indexOf(47);
        if (i > 0) {
            return fullPath.substring(0, i);
        }
        throw new BadParameterException("Invalid path " + fullPath);
    }

    public abstract boolean isFolder();

    protected abstract Locale userLocale();

    static {
        ROOT_PATH_LABEL = PATH_SEPARATOR = "/".intern();
        EMPTY = "".intern();
        LOG = ExoLogger.getLogger(Node.class);
    }
}

