/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.rest;

import java.net.URI;
import java.util.Scanner;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.outlook.rest.RESTServiceBase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

@Path(value="/outlook")
public class InfoService
extends RESTServiceBase {
    protected static final Log LOG = ExoLogger.getLogger(InfoService.class);
    public static final String DEFAULT_DISPLAY_NAME = "eXo Platform";
    public static final String ANONYMOUS_USER = "__anonim";

    @GET
    @Path(value="/manifest")
    @Produces(value={"text/xml"})
    public Response getManifest(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="guid") String guid, @QueryParam(value="hostName") String hostName, @QueryParam(value="displayName") String displayName) {
        Response.ResponseBuilder resp;
        String clientHost = this.getClientHost(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> Outlook manifest for " + clientHost + " as host:" + hostName + " with guid:" + guid));
        }
        URI requestURI = uriInfo.getRequestUri();
        StringBuilder serverHostBuilder = new StringBuilder();
        serverHostBuilder.append(requestURI.getScheme());
        serverHostBuilder.append("://");
        if (hostName != null && hostName.length() > 0) {
            serverHostBuilder.append(hostName);
        } else {
            serverHostBuilder.append(requestURI.getHost());
            int serverPort = requestURI.getPort();
            if (serverPort >= 0 && serverPort != 80 && serverPort != 443) {
                serverHostBuilder.append(':');
                serverHostBuilder.append(serverPort);
            }
        }
        String serverURL = serverHostBuilder.toString();
        try (Scanner mScanner = new Scanner(this.getClass().getResourceAsStream("/manifest/exo-outlook-manifest.template.xml"), "UTF-8").useDelimiter("\\A");){
            String mTemplate = mScanner.next();
            String manifest = mTemplate.replaceAll("\\$BASE_URL", serverURL);
            if (guid == null || (guid = guid.trim()).length() == 0) {
                guid = UUID.randomUUID().toString();
            }
            manifest = manifest.replaceAll("\\$GUID", guid);
            if (displayName == null || (displayName = displayName.trim()).length() == 0) {
                displayName = DEFAULT_DISPLAY_NAME;
            }
            manifest = manifest.replaceAll("\\$DISPLAY_NAME", displayName);
            resp = Response.ok().entity((Object)manifest);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error while generating manifest for " + clientHost), e);
            resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Cannot generate manifest");
        }
        return resp.build();
    }

    @GET
    @Path(value="userinfo")
    @Produces(value={"application/json"})
    public Response getUserInfo() throws Exception {
        int status;
        StringBuilder info = new StringBuilder();
        info.append("{");
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            if (userId != null && !userId.equals(ANONYMOUS_USER)) {
                info.append("\"authenticated\": true,");
                info.append("\"userId\": \"");
                info.append(userId);
                info.append('\"');
            } else {
                info.append("\"authenticated\": false");
            }
            status = 200;
        }
        catch (Throwable e) {
            LOG.error((Object)"Error getting user information", e);
            status = 500;
            info.append("\"error\": \"Error getting user information\"");
        }
        info.append("}");
        return Response.status((int)status).entity((Object)info.toString()).build();
    }
}

