/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.utils;

import io.meeds.kernel.test.KernelExtension;
import io.meeds.poll.BasePollTest;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.PollUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.poll", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase"})
@EnableJpaRepositories(basePackages={"io.meeds.poll"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/poll-rdbms.db.changelog-master.xml"})
public class PollUtilsTest
extends BasePollTest {
    private static final String MESSAGE = "Activity title";
    private Date createdDate = new Date(1508484583259L);
    private Date endDate = new Date(11508484583260L);
    @Autowired
    private PollService pollService;

    @Test
    public void getPollDuration() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption = new PollOption();
        pollOption.setDescription("pollOption");
        ArrayList<PollOption> options = new ArrayList<PollOption>();
        options.add(pollOption);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        long pollDuration = PollUtils.getPollDuration((Poll)createdPoll);
        Assertions.assertEquals((long)115740L, (long)pollDuration);
    }

    @Test
    public void formatToDate() throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        String dateInString = "7-Jun-2013";
        Date date = formatter.parse(dateInString);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
        Date nullConvertedDate = PollUtils.toDate(null);
        Date convertedDate = PollUtils.toDate((ZonedDateTime)zonedDateTime);
        Assertions.assertNull((Object)nullConvertedDate);
        Assertions.assertNotNull((Object)convertedDate);
        Assertions.assertEquals((long)date.getTime(), (long)convertedDate.getTime());
    }

    @Test
    public void getUserIdentityId() {
        long user1IdentityId = PollUtils.getUserIdentityId((IdentityManager)this.identityManager, (String)"testuser1");
        Assertions.assertEquals((long)Long.parseLong(this.user1Identity.getId()), (long)user1IdentityId);
    }
}

