/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.service;

import io.meeds.kernel.test.KernelExtension;
import io.meeds.poll.BasePollTest;
import io.meeds.poll.dao.PollDAO;
import io.meeds.poll.dao.PollOptionDAO;
import io.meeds.poll.dao.PollVoteDAO;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.service.PollService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.services.security.Identity;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.poll", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase"})
@EnableJpaRepositories(basePackages={"io.meeds.poll"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/poll-rdbms.db.changelog-master.xml"})
public class PollServiceTest
extends BasePollTest {
    private static final String MESSAGE = "Activity title";
    private static final String POLL_OPTION_DESCRIPTION = "pollOption";
    @Autowired
    private PollService pollService;
    @Autowired
    private PollDAO pollDAO;
    @Autowired
    private PollOptionDAO pollOptionDAO;
    @Autowired
    private PollVoteDAO pollVoteDAO;
    private Date createdDate = new Date(1508484583259L);
    private Date endDate = new Date(11508484583260L);

    @Override
    @AfterEach
    public void afterEach() {
        this.pollVoteDAO.deleteAll();
        this.pollOptionDAO.deleteAll();
        this.pollDAO.deleteAll();
        super.afterEach();
    }

    @Test
    public void createPoll() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        PollOption pollOption = new PollOption();
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> options = new ArrayList<PollOption>();
        options.add(pollOption);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        this.spaceService.addRedactor(this.space, this.user1Identity.getRemoteId());
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        Assertions.assertNotNull((Object)createdPoll);
        Assertions.assertEquals((long)Long.parseLong(this.user1Identity.getId()), (long)createdPoll.getCreatorId());
        Assertions.assertEquals((Object)"q1", (Object)createdPoll.getQuestion());
        Assertions.assertNotEquals((long)poll.getActivityId(), (long)createdPoll.getActivityId());
        Identity testuser2Identity = new Identity("testuser2");
        Poll poll1 = new Poll();
        poll1.setQuestion("q1");
        poll1.setCreatedDate(this.createdDate);
        poll1.setEndDate(this.endDate);
        poll1.setCreatorId(Long.parseLong(this.user2Identity.getId()));
        poll1.setSpaceId(1L);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.createPoll(poll1, pollOptionList, this.space.getId(), MESSAGE, testuser2Identity, new ArrayList()));
    }

    @Test
    public void getPollById() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption = new PollOption();
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> options = new ArrayList<PollOption>();
        options.add(pollOption);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        Poll retrievedPoll = this.pollService.getPollById(createdPoll.getId(), testUser1Identity);
        Assertions.assertNotNull((Object)poll);
        Assertions.assertEquals((Object)"q1", (Object)retrievedPoll.getQuestion());
        Assertions.assertEquals((Object)this.createdDate, (Object)retrievedPoll.getCreatedDate());
        Assertions.assertEquals((Object)this.endDate, (Object)retrievedPoll.getEndDate());
        Identity testUser3Identity = new Identity("testuser3");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.getPollById(retrievedPoll.getId(), testUser3Identity));
    }

    @Test
    public void getPollOptionById() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption = new PollOption();
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        PollOption retrievedPollOption = this.pollService.getPollOptionById(((PollOption)createdPollOptions.get(0)).getId(), testUser1Identity);
        Assertions.assertNotNull((Object)retrievedPollOption);
        Assertions.assertEquals((Object)POLL_OPTION_DESCRIPTION, (Object)retrievedPollOption.getDescription());
        Identity testUser3Identity = new Identity("testuser3");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.getPollOptionById(((PollOption)createdPollOptions.get(0)).getId(), testUser3Identity));
    }

    @Test
    public void getPollOptionsByPollId() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption = new PollOption();
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List retrievedPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        Assertions.assertNotNull((Object)retrievedPollOptions);
        Assertions.assertEquals((int)1, (int)retrievedPollOptions.size());
        Identity testUser3Identity = new Identity("testuser3");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser3Identity));
    }

    @Test
    public void voteOnPoll() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption = new PollOption();
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        PollVote voteAdded = this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser1Identity);
        Assertions.assertNotNull((Object)voteAdded);
        Assertions.assertEquals((long)((PollOption)createdPollOptions.get(0)).getId(), (long)voteAdded.getPollOptionId());
        Assertions.assertEquals((long)Long.parseLong(this.user1Identity.getId()), (long)voteAdded.getVoterId());
        Identity testUser3Identity = new Identity("testuser3");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser3Identity));
    }

    @Test
    public void voteOnExpiredPoll() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.createdDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption = new PollOption();
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser1Identity));
    }

    @Test
    public void getPollOptionTotalVotes() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Identity testUser2Identity = new Identity("testuser2");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption1 = new PollOption();
        pollOption1.setDescription("pollOption1");
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption1);
        PollOption pollOption2 = new PollOption();
        pollOption2.setDescription("pollOption2");
        pollOptionList.add(pollOption2);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser1Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser2Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(1)).getId()), this.space.getId(), testUser2Identity);
        int pollOption1Votes = this.pollService.getPollOptionTotalVotes(((PollOption)createdPollOptions.get(0)).getId(), this.space.getId(), testUser1Identity);
        int pollOption2Votes = this.pollService.getPollOptionTotalVotes(((PollOption)createdPollOptions.get(1)).getId(), this.space.getId(), testUser1Identity);
        Assertions.assertEquals((int)2, (int)pollOption1Votes);
        Assertions.assertEquals((int)1, (int)pollOption2Votes);
        Identity testUser3Identity = new Identity("testuser3");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.getPollOptionTotalVotes(((PollOption)createdPollOptions.get(0)).getId(), this.space.getId(), testUser3Identity));
    }

    @Test
    public void isPollOptionVoted() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Identity testUser2Identity = new Identity("testuser2");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption1 = new PollOption();
        pollOption1.setDescription("pollOption1");
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption1);
        PollOption pollOption2 = new PollOption();
        pollOption2.setDescription("pollOption2");
        pollOptionList.add(pollOption2);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser1Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser2Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(1)).getId()), this.space.getId(), testUser2Identity);
        boolean isPollOption1VotedByUser1 = this.pollService.isPollOptionVoted(((PollOption)createdPollOptions.get(0)).getId(), this.space.getId(), testUser1Identity);
        boolean isPollOption2VotedByUser1 = this.pollService.isPollOptionVoted(((PollOption)createdPollOptions.get(1)).getId(), this.space.getId(), testUser1Identity);
        boolean isPollOption1VotedByUser2 = this.pollService.isPollOptionVoted(((PollOption)createdPollOptions.get(0)).getId(), this.space.getId(), testUser2Identity);
        boolean isPollOption2VotedByUser2 = this.pollService.isPollOptionVoted(((PollOption)createdPollOptions.get(1)).getId(), this.space.getId(), testUser2Identity);
        Assertions.assertEquals((Object)true, (Object)isPollOption1VotedByUser1);
        Assertions.assertEquals((Object)false, (Object)isPollOption2VotedByUser1);
        Assertions.assertEquals((Object)true, (Object)isPollOption1VotedByUser2);
        Assertions.assertEquals((Object)true, (Object)isPollOption2VotedByUser2);
        Identity testUser3Identity = new Identity("testuser3");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pollService.isPollOptionVoted(((PollOption)createdPollOptions.get(0)).getId(), this.space.getId(), testUser3Identity));
    }

    @Test
    public void getPollOptionsNumber() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption1 = new PollOption();
        pollOption1.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption2 = new PollOption();
        pollOption2.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption3 = new PollOption();
        pollOption3.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption4 = new PollOption();
        pollOption4.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption1);
        pollOptionList.add(pollOption2);
        pollOptionList.add(pollOption3);
        pollOptionList.add(pollOption4);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        int pollOptionsNumber = this.pollService.getPollOptionsNumber(createdPoll.getId(), testUser1Identity);
        Assertions.assertEquals((int)4, (int)pollOptionsNumber);
    }

    @Test
    public void getPollTotalVotes() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Identity testUser2Identity = new Identity("testuser2");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption1 = new PollOption();
        pollOption1.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption2 = new PollOption();
        pollOption2.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption3 = new PollOption();
        pollOption3.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption4 = new PollOption();
        pollOption4.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption1);
        pollOptionList.add(pollOption2);
        pollOptionList.add(pollOption3);
        pollOptionList.add(pollOption4);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser1Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser2Identity);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(1)).getId()), this.space.getId(), testUser2Identity);
        int pollTotalVotes = this.pollService.getPollTotalVotes(createdPoll.getId(), testUser1Identity);
        Assertions.assertEquals((int)3, (int)pollTotalVotes);
    }

    @Test
    public void didVote() throws IllegalAccessException {
        Identity testUser1Identity = new Identity("testuser1");
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOption pollOption1 = new PollOption();
        pollOption1.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption2 = new PollOption();
        pollOption2.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption3 = new PollOption();
        pollOption3.setDescription(POLL_OPTION_DESCRIPTION);
        PollOption pollOption4 = new PollOption();
        pollOption4.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOption> pollOptionList = new ArrayList<PollOption>();
        pollOptionList.add(pollOption1);
        pollOptionList.add(pollOption2);
        pollOptionList.add(pollOption3);
        pollOptionList.add(pollOption4);
        Poll createdPoll = this.pollService.createPoll(poll, pollOptionList, this.space.getId(), MESSAGE, testUser1Identity, new ArrayList());
        List createdPollOptions = this.pollService.getPollOptionsByPollId(createdPoll.getId(), testUser1Identity);
        boolean didVote = this.pollService.didVote(testUser1Identity, Long.valueOf(createdPoll.getId()));
        Assertions.assertFalse((boolean)didVote);
        this.pollService.vote(String.valueOf(((PollOption)createdPollOptions.get(0)).getId()), this.space.getId(), testUser1Identity);
        didVote = this.pollService.didVote(testUser1Identity, Long.valueOf(createdPoll.getId()));
        Assertions.assertTrue((boolean)didVote);
    }
}

